(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     26031,        559]
NotebookOptionsPosition[     25670,        542]
NotebookOutlinePosition[     26010,        557]
CellTagsIndexPosition[     25967,        554]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"factor", "=", 
   RowBox[{"1", "/", "3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lambda", "=", "0.1333"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tlen", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"q", "[", 
    RowBox[{"a_", ",", "b_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"2", "\[Pi]", " ", "a", " ", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2", "\[Pi]", " ", 
       RowBox[{"x", "/", "b"}]}], "]"}], "/", "b"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"r", "[", 
    RowBox[{"a_", ",", "b_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Cos", "[", 
       RowBox[{"ArcTan", "[", 
        RowBox[{"q", "[", 
         RowBox[{"a", ",", "b", ",", "x"}], "]"}], "]"}], "]"}], ")"}], "^", 
     "2"}], 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", 
      RowBox[{"1", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"q", "[", 
          RowBox[{"a", ",", "b", ",", "x"}], "]"}], ")"}], "^", "2"}]}]}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
   RowBox[{"b", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{"r", "[", 
         RowBox[{"a", ",", "b", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "b"}], "}"}]}], "]"}], "-", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{"r", "[", 
         RowBox[{"a", ",", "b", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"0.25", "-", 
             RowBox[{"tlen", "/", "2"}]}], ")"}], "b"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"0.25", "+", 
             RowBox[{"tlen", "/", "2"}]}], ")"}], "b"}]}], "}"}]}], "]"}], 
      "-", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{"r", "[", 
         RowBox[{"a", ",", "b", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"0.75", "-", 
             RowBox[{"tlen", "/", "2"}]}], ")"}], "b"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"0.75", "+", 
             RowBox[{"tlen", "/", "2"}]}], ")"}], "b"}]}], "}"}]}], "]"}], 
      "+", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{"r", "[", 
         RowBox[{"0", ",", "b", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"0.25", "-", 
             RowBox[{"tlen", "/", "2"}]}], ")"}], "b"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"0.25", "+", 
             RowBox[{"tlen", "/", "2"}]}], ")"}], "b"}]}], "}"}]}], "]"}], 
      "+", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{"r", "[", 
         RowBox[{"0", ",", "b", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"0.75", "-", 
             RowBox[{"tlen", "/", "2"}]}], ")"}], "b"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"0.75", "+", 
             RowBox[{"tlen", "/", "2"}]}], ")"}], "b"}]}], "}"}]}], "]"}]}], 
     ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"factor", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"a", ",", "b"}], "]"}], "^", "1"}], "-", "1"}], ")"}]}], "+",
     "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"a", ",", "lambda"}], "]"}], ",", 
     RowBox[{
      RowBox[{"5", "a"}], "+", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "0.2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"DiscretePlot", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"0.1", ",", 
     RowBox[{"n", "*", "lambda"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Array", "[", 
   RowBox[{"vx", ",", "51"}], "]"}], ";", " ", 
  RowBox[{"Array", "[", 
   RowBox[{"vy", ",", "51"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"vx", "[", "i", "]"}], "=", 
     RowBox[{"0.2", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"i", "-", "1"}], ")"}], "/", "50"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "51"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"vy", "[", "i", "]"}], "=", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"vx", "[", "i", "]"}], ",", "lambda"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "51"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat1", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"vx", "[", "i", "]"}], ",", 
        RowBox[{"vy", "[", "i", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "51"}], "}"}]}], "]"}], "//", "N"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\<C:/Local/CAATasks\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Amplitude.dat\>\"", ",", "dat1", ",", "\"\<Table\>\"", ",", 
    RowBox[{"\"\<FieldSeparators\>\"", "\[Rule]", "\"\< \>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6236434437350826`*^9, 3.623643446595544*^9}, {
   3.6236434786514626`*^9, 3.6236434804591494`*^9}, {3.6236438082607985`*^9, 
   3.623643908698249*^9}, {3.623644122356844*^9, 3.6236441283336363`*^9}, {
   3.623644162798826*^9, 3.623644278956607*^9}, 3.623644311206869*^9, {
   3.62364445480711*^9, 3.623644592228402*^9}, {3.6236446679471292`*^9, 
   3.6236446857456646`*^9}, {3.623650837152768*^9, 3.62365083727289*^9}, {
   3.623650889602048*^9, 3.6236508897055674`*^9}, {3.623656183542864*^9, 
   3.623656210932107*^9}, {3.623656304343709*^9, 3.623656304919667*^9}, {
   3.6236563430334435`*^9, 3.6236563508615913`*^9}, {3.623656417007536*^9, 
   3.623656436785494*^9}, {3.6236566181107855`*^9, 3.6236566255743866`*^9}, {
   3.6236566628552914`*^9, 3.623656694210828*^9}, {3.6236568147685413`*^9, 
   3.6236569553484106`*^9}, {3.6236570136884265`*^9, 
   3.6236570143192453`*^9}, {3.635336244950496*^9, 3.6353362703928795`*^9}, {
   3.635336322526717*^9, 3.6353363594295015`*^9}, {3.6355907119704146`*^9, 
   3.6355909386500173`*^9}, {3.635591027981572*^9, 3.6355910505820494`*^9}, {
   3.6355911569123044`*^9, 3.635591193433238*^9}, {3.6355912595060873`*^9, 
   3.635591259578356*^9}, {3.6355913340773106`*^9, 3.635591393134266*^9}, {
   3.635591595026784*^9, 3.6355916105224957`*^9}, {3.6355916774332685`*^9, 
   3.6355916776813245`*^9}, {3.635591712084013*^9, 3.6355917360917706`*^9}, {
   3.635592694455719*^9, 3.635592743305251*^9}, {3.6355928254939537`*^9, 
   3.635592933246138*^9}, {3.6355930367696447`*^9, 3.6355930824501095`*^9}, {
   3.635593122730953*^9, 3.6355931317713394`*^9}, {3.6356590325124707`*^9, 
   3.635659085829948*^9}, {3.635659256725182*^9, 3.6356592572525463`*^9}, {
   3.6356592886932063`*^9, 3.6356593335259824`*^9}, {3.6356645568886614`*^9, 
   3.635664557081052*^9}, {3.6356646494351835`*^9, 3.635664668522831*^9}, {
   3.6356647017721543`*^9, 3.635664826324788*^9}, {3.635666355534875*^9, 
   3.6356663722708693`*^9}, {3.6356667624069433`*^9, 3.635666783334505*^9}, {
   3.6356668173914766`*^9, 3.635666891297635*^9}, {3.6356670058303533`*^9, 
   3.635667017429432*^9}, {3.635667061534641*^9, 3.6356670962478876`*^9}, {
   3.635667766716992*^9, 3.635667793277582*^9}, {3.635667830054385*^9, 
   3.635667886351469*^9}, {3.6356679197756033`*^9, 3.635667991066427*^9}, {
   3.6356680396044235`*^9, 3.635668080518104*^9}, {3.6356694565338316`*^9, 
   3.6356694576745005`*^9}, {3.63566950074842*^9, 3.635669566892562*^9}, {
   3.6356696165263033`*^9, 3.635669638777158*^9}, {3.635669849338954*^9, 
   3.635669867291792*^9}, {3.635669931516914*^9, 3.635670145681388*^9}, {
   3.6356702029306564`*^9, 3.6356702990378623`*^9}, {3.635670333526491*^9, 
   3.6356703368801355`*^9}, {3.635670402729344*^9, 3.6356704032586613`*^9}, {
   3.635670483057624*^9, 3.635670495993667*^9}, {3.6356705336025333`*^9, 
   3.6356705433704863`*^9}, {3.6356707297106495`*^9, 3.635670910867996*^9}, 
   3.635670950787498*^9, {3.6356710399129906`*^9, 3.635671040856386*^9}, {
   3.6356712316820726`*^9, 3.635671308659638*^9}, {3.63567147841518*^9, 
   3.635671513880409*^9}, {3.6356716808282256`*^9, 3.6356717698238306`*^9}, {
   3.635671800046671*^9, 3.6356718845762835`*^9}, 3.6356720128282785`*^9, {
   3.635672054348428*^9, 3.6356720688362885`*^9}, {3.635672128573934*^9, 
   3.635672131117977*^9}, {3.6362793677214327`*^9, 3.636279383130227*^9}, {
   3.636279452156315*^9, 3.6362794862552805`*^9}, {3.636279625230344*^9, 
   3.636279661636039*^9}, {3.6362796959244647`*^9, 3.636279825262439*^9}, {
   3.6362799110147552`*^9, 3.6362799130861235`*^9}, {3.6362800175276337`*^9, 
   3.6362800336913404`*^9}, {3.63628008419621*^9, 3.6362800856445074`*^9}, {
   3.6362802103270297`*^9, 3.6362802178751707`*^9}, {3.6362802544234495`*^9, 
   3.636280255151016*^9}, {3.6362802866053495`*^9, 3.636280292188571*^9}, 
   3.636280333077837*^9, {3.636868585171235*^9, 3.63686859896918*^9}, {
   3.636868656707672*^9, 3.6368686839705753`*^9}, {3.636868722888006*^9, 
   3.63686873952659*^9}, {3.636868816399599*^9, 3.6368688241754684`*^9}, {
   3.6368688586449423`*^9, 3.6368688860260024`*^9}, {3.6368689552207923`*^9, 
   3.6368689660990024`*^9}, {3.6368690527965784`*^9, 
   3.6368690531803427`*^9}, {3.636869101352064*^9, 3.636869129797509*^9}, {
   3.636869178489705*^9, 3.6368692155742455`*^9}, {3.636869286702506*^9, 
   3.636869446722537*^9}, {3.6368694987289743`*^9, 3.6368696954156046`*^9}, {
   3.6368772225598125`*^9, 3.6368772517649746`*^9}, {3.636877303449167*^9, 
   3.636877309904808*^9}, {3.636877365339737*^9, 3.6368774440290365`*^9}, {
   3.636877561563506*^9, 3.636877562042967*^9}, {3.636877611024207*^9, 
   3.6368776110710793`*^9}, {3.636877660083567*^9, 3.6368776761694517`*^9}, {
   3.6368805642336273`*^9, 3.63688058593634*^9}, {3.636882786602129*^9, 
   3.6368828366292005`*^9}, {3.6368828891531825`*^9, 
   3.6368829926963596`*^9}, {3.636883072058468*^9, 3.6368831311962843`*^9}, 
   3.6368831612910376`*^9, {3.6368832038713207`*^9, 3.6368832117340984`*^9}, 
   3.6374853401933193`*^9, {3.6374854277669945`*^9, 3.6374854376394444`*^9}, {
   3.637485496008873*^9, 3.637485526461214*^9}, {3.6374855617125673`*^9, 
   3.637485567105353*^9}, {3.637489761513482*^9, 3.637489777541441*^9}, {
   3.6380942952269897`*^9, 3.6380943333495502`*^9}, {3.6380944117849593`*^9, 
   3.6380944375030403`*^9}, {3.6380944758921843`*^9, 3.638094667059636*^9}, {
   3.638094711431796*^9, 3.638094788480576*^9}, {3.6380949004470425`*^9, 
   3.6380949466433043`*^9}, {3.6380949926716084`*^9, 
   3.6380950006066475`*^9}, {3.638095083959711*^9, 3.638095101333599*^9}, {
   3.638095160544653*^9, 3.6380953488558426`*^9}, {3.638095420258499*^9, 
   3.638095441952423*^9}, {3.638095673392688*^9, 3.638095860267446*^9}, {
   3.638095891595519*^9, 3.6380959621154194`*^9}, 3.6380960784146166`*^9, {
   3.6380961552143884`*^9, 3.6380961553022738`*^9}, {3.638096220135038*^9, 
   3.6380963561605115`*^9}, {3.6380964028782244`*^9, 
   3.6380964435387077`*^9}, {3.638096497486427*^9, 3.6380965690560646`*^9}, {
   3.638096607418844*^9, 3.638096652083954*^9}, {3.63809815134737*^9, 
   3.6380982248338776`*^9}, {3.638098301507681*^9, 3.638098307544404*^9}, {
   3.638098346223569*^9, 3.6380983578136473`*^9}},
 FontSize->18],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJwl0gk01YkXB3DeI5VlLM/yLA/hH/qHHpI0fUXjbylrWVOIMmQwvWxll3oo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     "]]}, 
   {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJwVjnk01AkAxx1NYlGm0TxFUfSY91gVU7q+SG0ouXLVRjqsylGRjUc6iEpm
PQmNHBVDOctRqRyF324iqkGOnnLNipkxMxjMb2f/+L7vP5/Pex8D/xDXE0oK
Cgr75fv/83jPw1qvb9hpERpJUVDgI96IWllBW4bTRpIsG0U+qNsjHiXT9JHb
c5Z5VYkPr+ZCvRiaOTR3BwYspvAxp97oHU6zxqiOF6Guxkdradt0KM0Z7EbL
JB0aH0zFL03BND8o0wW0TcZ88Ey8S4Jooeh4FWB40pmPoAuf9ifVxyJnn1pc
cgEfvhrJHZShBMSnWW0VzvBRrOQw2BbCArOleEftXgHqfEwETxpTQd/GvWKf
LQBLg6pyrzUdSwOTdJfxBQhnczfqmGXBqmtmOuM3ISZNc9Vor3Jg+muhwc0s
IZS2HSLXvc7DFpvh7MqfQuhXKZNRvIcIT+3yfWA3BXa/+ZVeQT5a8jzD/r4z
hUPZZX6USQ6G01dxvYamYPhhtcMF+mMw21OjiraJ4FikVT25shjshswwy1si
RIuEZuX2pbCQHCy9+l2Ei6eXX9arLkOalscWKysx/J+GPBmuKofm6KC2caIY
zht39bm9r8Bz0tCyZ0CMnyrdB3a3PUVkxxTnnbkEybTh5p6RZwgajjgSliCB
WxA7yH2uEoxBa/8b/RI06WofdJ2vgiw97UW32TR2KlNsRdQaLPor1308bhon
rKtDV9KfQ9/OatcW7jSKCWqr4YoXWDygHfvv+hnMJQ6ZdTJeYvXLAtnR6BnM
5ER2UExr4eTa9FHrwwykE/FRvXavUMLIHL5mNAu9xO2udz1fo5tXYe8bNQv+
xWenvni+waqTXorn/5nFj3aXt73MOtxe+1Rqv1YKYxYjjFVTB53MzL0+56WI
FnO3Vm2uR/Bs04+PDVK4S6wXldTXQ5TBaVDXmcPVtTcnAmwbkCJeIY4NnIMF
j/V1qrUBfilbA2vq5rCjL2LMxrkRe3i8DSbUeXhe2KSp1N4Iicm3vYr+85gq
KrJM9XmLrqIbueyaeYyoKceMfn2L9uF6p7OqC/h9MZ3Q/OMdpMdKdqgeXcCP
ApJRIHiHiZaByCXVC2gMI4oVzzVBOpqlbqMig2Gf0yazhSYwHbS+bT8iQ19o
ZbfupWbcOKm15FypDPlF/LRoWTM4pzxiNEkZhJdGPMoSWjBd6swMPkgiLfbN
5keqBI6UcW1V8kn4dq9THfqFQG9AlVFIAQnjjQk9hpoEvNfcWcLlkHjx3Tn6
IZWA+23XD/mPSQzsGWx4sIrAvjOt3nvK5bwGxSnPlICVcWNoXC2JlxkOx7Nd
CGjnlNxX7iRxTVhiOeBGIMUz6fLpTyScHJerrPEgoLX0zPHOzyS+zX8tvO9D
QD3GhPGgi8Qiv6DJrGMElA4/rLTtl/PrWZHscAICeub7y2Mk6JdEjr0RBILb
/iwd48l9rpeebiSB8XjPFJdxEucSDeruxRAYEdO8DCZJ3B2voNy7TqC/M/l7
nYiE3246tyeRwOGbwU3GEhKM+1GclbcI9NjuL2RNk6g9YOeYySLwpVwtxE9K
Io7D0e1JIeAWOObSMifvUdSY0LlD4KN+i4X5grzH5+wb77sEnLry6ekyeU/F
Z1ZGBoH3yXFSkiTxHymkcuE=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 1.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None},
  PlotRange->{{0., 0.19999999591836737`}, {1, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6356705698607616`*^9, 3.63567091887221*^9, 3.6356709671758223`*^9, 
   3.6356710628992248`*^9, {3.6356712364459276`*^9, 3.635671291923644*^9}, 
   3.6356714998837776`*^9, 3.6356718908802366`*^9, 3.6356721364502134`*^9, 
   3.636279491086521*^9, 3.6362796283476515`*^9, 3.6362796620716023`*^9, 
   3.6362796966647277`*^9, 3.6362798258806267`*^9, {3.636280023591344*^9, 
   3.6362800353427715`*^9}, 3.636280087286172*^9, 3.636280232158922*^9, {
   3.636280265708062*^9, 3.636280294146654*^9}, 3.636868607747915*^9, 
   3.636868686216525*^9, {3.6368687253487864`*^9, 3.6368687407315907`*^9}, {
   3.636868817871185*^9, 3.6368688260376544`*^9}, 3.6368689209339247`*^9, {
   3.636868957490178*^9, 3.636868967161434*^9}, {3.6368691193020873`*^9, 
   3.636869130851153*^9}, {3.6368691802913475`*^9, 3.636869184990266*^9}, {
   3.6368694367602844`*^9, 3.6368694531742725`*^9}, {3.6368696354233503`*^9, 
   3.6368696972563066`*^9}, 3.636877267908473*^9, {3.6368773061657896`*^9, 
   3.6368773126975985`*^9}, {3.636877379441373*^9, 3.6368774461558533`*^9}, 
   3.6368775642908707`*^9, 3.6368776136666164`*^9, {3.636877662894911*^9, 
   3.6368776783138456`*^9}, 3.6368806011990347`*^9, {3.636882813741017*^9, 
   3.6368828402188144`*^9}, {3.636882892540661*^9, 3.6368829958768206`*^9}, {
   3.636883096961171*^9, 3.636883134830817*^9}, 3.636883164973419*^9, {
   3.636883205621208*^9, 3.6368832152573104`*^9}, 3.6374854591236672`*^9, {
   3.637485501544242*^9, 3.6374855307523947`*^9}, 3.637485573533334*^9, 
   3.637489786375765*^9, 3.638094302025383*^9, 3.6380943393950615`*^9, {
   3.638094462152829*^9, 3.63809467030064*^9}, {3.638094714407192*^9, 
   3.638094763200944*^9}, {3.6380949036050434`*^9, 3.6380949496763134`*^9}, {
   3.6380949960913115`*^9, 3.63809500383398*^9}, {3.638095088511177*^9, 
   3.638095104638075*^9}, {3.6380951797787733`*^9, 3.6380952643671093`*^9}, {
   3.6380952999292865`*^9, 3.6380953522989817`*^9}, {3.6380954245775585`*^9, 
   3.63809544503621*^9}, 3.638095877707736*^9, {3.6380959554351826`*^9, 
   3.6380959691481724`*^9}, 3.6380961783789215`*^9, {3.6380963849848385`*^9, 
   3.6380964045363216`*^9}, {3.638096511807776*^9, 3.6380965710295715`*^9}, {
   3.6380981586193657`*^9, 3.6380981686773157`*^9}, {3.638098199772005*^9, 
   3.6380982277848606`*^9}, {3.6380982925355988`*^9, 
   3.6380983105822954`*^9}, {3.6380983529331007`*^9, 3.638098360587884*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.019444444444444445`], 
    AbsoluteThickness[1.6], {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.019444444444444445`], AbsoluteThickness[1.6], Opacity[0.2], LineBox[{},
       VertexColors->None]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.019444444444444445`], AbsoluteThickness[1.6], Opacity[0.2], 
      LineBox[{{{1., 1.513201423102608}, {1., 1}}, {{2., 1.229622051859359}, {
         2., 1}}},
       VertexColors->None]}}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.019444444444444445`], 
    AbsoluteThickness[1.6], {}, 
    PointBox[{{1., 1.513201423102608}, {2., 1.229622051859359}}], {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 1},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
    "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "RangePadding" -> Scaled[0.05]},
  PlotRange->{{1., 2.}, {1, 2}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6356705698607616`*^9, 3.63567091887221*^9, 3.6356709671758223`*^9, 
   3.6356710628992248`*^9, {3.6356712364459276`*^9, 3.635671291923644*^9}, 
   3.6356714998837776`*^9, 3.6356718908802366`*^9, 3.6356721364502134`*^9, 
   3.636279491086521*^9, 3.6362796283476515`*^9, 3.6362796620716023`*^9, 
   3.6362796966647277`*^9, 3.6362798258806267`*^9, {3.636280023591344*^9, 
   3.6362800353427715`*^9}, 3.636280087286172*^9, 3.636280232158922*^9, {
   3.636280265708062*^9, 3.636280294146654*^9}, 3.636868607747915*^9, 
   3.636868686216525*^9, {3.6368687253487864`*^9, 3.6368687407315907`*^9}, {
   3.636868817871185*^9, 3.6368688260376544`*^9}, 3.6368689209339247`*^9, {
   3.636868957490178*^9, 3.636868967161434*^9}, {3.6368691193020873`*^9, 
   3.636869130851153*^9}, {3.6368691802913475`*^9, 3.636869184990266*^9}, {
   3.6368694367602844`*^9, 3.6368694531742725`*^9}, {3.6368696354233503`*^9, 
   3.6368696972563066`*^9}, 3.636877267908473*^9, {3.6368773061657896`*^9, 
   3.6368773126975985`*^9}, {3.636877379441373*^9, 3.6368774461558533`*^9}, 
   3.6368775642908707`*^9, 3.6368776136666164`*^9, {3.636877662894911*^9, 
   3.6368776783138456`*^9}, 3.6368806011990347`*^9, {3.636882813741017*^9, 
   3.6368828402188144`*^9}, {3.636882892540661*^9, 3.6368829958768206`*^9}, {
   3.636883096961171*^9, 3.636883134830817*^9}, 3.636883164973419*^9, {
   3.636883205621208*^9, 3.6368832152573104`*^9}, 3.6374854591236672`*^9, {
   3.637485501544242*^9, 3.6374855307523947`*^9}, 3.637485573533334*^9, 
   3.637489786375765*^9, 3.638094302025383*^9, 3.6380943393950615`*^9, {
   3.638094462152829*^9, 3.63809467030064*^9}, {3.638094714407192*^9, 
   3.638094763200944*^9}, {3.6380949036050434`*^9, 3.6380949496763134`*^9}, {
   3.6380949960913115`*^9, 3.63809500383398*^9}, {3.638095088511177*^9, 
   3.638095104638075*^9}, {3.6380951797787733`*^9, 3.6380952643671093`*^9}, {
   3.6380952999292865`*^9, 3.6380953522989817`*^9}, {3.6380954245775585`*^9, 
   3.63809544503621*^9}, 3.638095877707736*^9, {3.6380959554351826`*^9, 
   3.6380959691481724`*^9}, 3.6380961783789215`*^9, {3.6380963849848385`*^9, 
   3.6380964045363216`*^9}, {3.638096511807776*^9, 3.6380965710295715`*^9}, {
   3.6380981586193657`*^9, 3.6380981686773157`*^9}, {3.638098199772005*^9, 
   3.6380982277848606`*^9}, {3.6380982925355988`*^9, 
   3.6380983105822954`*^9}, {3.6380983529331007`*^9, 3.638098360654286*^9}}]
}, Open  ]]
},
WindowSize->{1317, 885},
WindowMargins->{{4, Automatic}, {Automatic, 5}},
FrontEndVersion->"10.0 for Microsoft Windows (64-bit) (July 1, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 12407, 281, 577, "Input"],
Cell[12990, 305, 7389, 125, 251, "Output"],
Cell[20382, 432, 5272, 107, 253, "Output"]
}, Open  ]]
}
]
*)
icks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None},
  PlotRange->{{0., 0.19999999591836737`}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.6236569620296235`*^9, 3.6236570455242796`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(x\\)\
\[NoBreak] near \[NoBreak]\\!\\({x}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.02296959527496586`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(0.1314777811449318`\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.5348404198809747`*^-6\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6236569624290123`*^9, 3.6236570458543367`*^9}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.019444444444444445`], 
    AbsoluteThickness[1.6], {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.019444444444444445`], AbsoluteThickness[1.6], Opacity[0.2], LineBox[{},
       VertexColors->None]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.019444444444444445`], AbsoluteThickness[1.6], Opacity[0.2], 
      LineBox[{{{4., 0.36969784756997887`}, {4., 0}}, {{5., 
         0.3033144710546925}, {5., 0}}, {{6., 0.2563914589313092}, {
         6., 0}}, {{7., 0.22170592218540233`}, {7., 0}}, {{8., 
         0.1951198627694502}, {8., 0}}, {{9., 0.1741369827637536}, {
         9., 0}}, {{10., 0.15717672547799882`}, {10., 0}}, {{11., 
         0.1431952412262716}, {11., 0}}, {{12., 0.1314777811449318}, {
         12., 0}}},
       VertexColors->None]}}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.019444444444444445`], 
    AbsoluteThickness[1.6], {}, 
    PointBox[{{4., 0.36969784756997887`}, {5., 0.3033144710546925}, {6., 
     0.2563914589313092}, {7., 0.22170592218540233`}, {8., 
     0.1951198627694502}, {9., 0.1741369827637536}, {10., 
     0.15717672547799882`}, {11., 0.1431952412262716}, {12., 
     0.1314777811449318}}], {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{4., 0},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "MessagesHead" -> DiscretePlot, "AxisPadding" -> Scaled[0.02], 
    "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "RangePadding" -> Scaled[0.05]},
  PlotRange->{{4., 12.}, {0, 1}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {Automatic, Automatic}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.6236569620296235`*^9, 3.623657045865078*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(x\\)\
\[NoBreak] near \[NoBreak]\\!\\({x}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.02296959527496586`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(0.1314777811449318`\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.5348404198809747`*^-6\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6236569624290123`*^9, 3.623657047691133*^9}]
}, Open  ]]
},
WindowSize->{767, 873},
WindowMargins->{{167, Automatic}, {Automatic, 43}},
FrontEndVersion->"10.0 for Microsoft Windows (64-bit) (July 1, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 3112, 79, 172, "Input"],
Cell[3695, 103, 3608, 68, 251, "Output"],
Cell[7306, 173, 828, 15, 56, "Message"],
Cell[8137, 190, 3470, 84, 253, "Output"],
Cell[11610, 276, 826, 15, 56, "Message"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
