% A new plot
FontSize=18;
fig=figure;
axes('YScale','log');
set(fig,'Position',[100,100,750,450]);
set(gca,'FontSize',FontSize-2);

xlim([0, log2(64)]);
set(gca,'XTickLabel',2.^[0:6]);
xlabel('Number of iterations, $I$','fontsize',FontSize,'interpreter','latex');
ylabel('Clock cycles','fontsize',FontSize,'interpreter','latex');
grid;
box on;
set(gca,'YMinorGrid','off');
hold on


eval('load Data/bcjr_512_4.mat');
l1=plot (log2(iter(:,1)),iter(:,2),'o-k','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','w','MarkerSize',8);
eval('load Data/bcjr_512_16.mat');
l2=plot (log2(iter(:,1)),iter(:,2),'d-.k','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','w','MarkerSize',8);
eval('load Data/bcjr_512_64.mat');
l3=plot (log2(iter(:,1)),iter(:,2),'s--k','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','w','MarkerSize',8);
eval('load Data/bcjr_6144_48.mat');
l4=plot (log2(iter(:,1)),iter(:,2),'o-b','LineWidth',2,'MarkerEdgeColor','b','MarkerFaceColor','b','MarkerSize',8);
eval('load Data/bcjr_6144_192.mat');
l5=plot (log2(iter(:,1)),iter(:,2),'d-.b','LineWidth',2,'MarkerEdgeColor','b','MarkerFaceColor','b','MarkerSize',8);
eval('load Data/bcjr_6144_768.mat');
l6=plot (log2(iter(:,1)),iter(:,2),'s--b','LineWidth',2,'MarkerEdgeColor','b','MarkerFaceColor','b','MarkerSize',8);



leg=legend ([l1 l2 l3 l4 l5 l6],{'$N$=512, $K$=4','$N$=512, $K$=16','$N$=512, $K$=64','$N$=6144, $K$=48','$N$=6144, $K$=192','$N$=6144, $K$=768'});
set(legend,'Location','NorthWest','color','none','Box','off','interpreter','latex','FontSize',FontSize);
%rect = [0.25, 0.75, 0.15, 0.15];
%set(leg, 'Position', rect)