% A new plot
FontSize=18;
fig=figure;

set(fig,'Position',[100,100,750,450]);
set(gca,'FontSize',FontSize-2);
xlim([0 35]);
ylim ([0 100]);
xlabel ('Benchmarker number of iterations, $I$','fontsize',FontSize,'interpreter','latex');
ylabel ('Fully adaptive equivalent iterations','fontsize',FontSize,'interpreter','latex');
grid;
box on;
hold on

% Plot
a=[1.8, 3.6, 7.3, 14.8, 29.4, 59.0, 117.8];
b=[1, 2, 4, 8, 16, 32, 64];
l1=plot ((b),(a),'o-k','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','w','MarkerSize',8);
hold on
a=[2, 4, 8.2, 16.4, 32.5, 65.6, 129.7];
l2=plot ((b),(a),'d--k','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','w','MarkerSize',8);
a=[2.3, 4.7, 9.4, 19, 37.3, 75.6, 151.2];
l3=plot ((b),(a),'s:k','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','w','MarkerSize',8);

a=[2, 4.1, 8.1, 16.2, 32.3, 64.4, 128.6 ];
l4=plot ((b),(a),'o-b','LineWidth',2,'MarkerEdgeColor','b','MarkerFaceColor','b','MarkerSize',8);
a=[2.3, 4.4, 8.8, 17.6, 35.2, 70.3, 140.4 ];
l5=plot ((b),(a),'d--b','LineWidth',2,'MarkerEdgeColor','b','MarkerFaceColor','b','MarkerSize',8);
a=[2.5, 5.0, 10, 20, 40.2, 80.2, 160.3 ];
l6=plot ((b),(a),'s:b','LineWidth',2,'MarkerEdgeColor','b','MarkerFaceColor','b','MarkerSize',8);

% Legend
legend ([l1 l2 l3 l4 l5 l6], {'$N$=512, $K$=4','$N$=512, $K$=16','$N$=512, $K$=64','$N$=6144, $K$=48','$N$=6144, $K$=192','$N$=6144, $K$=768'});
set(legend,'Location','NorthWest','color','none','Box','off','interpreter','latex','FontSize',FontSize);


