
%% Settings
bits_per_frame  = 512; % 512 or 6144
bits_per_window = 64;  % 4,16 or 64 for 512; 48,192 or 768 for 6144 
windows_per_frame= bits_per_frame/bits_per_window; % or number of processors for each decoder (half the NoC size)
Iter=[2 4 8 16 32]; %[2 4 8 16 32] for 512; [2 4 8 16] for 6144
eval(['load Data/bcjr_',num2str(bits_per_frame),'_',num2str(bits_per_window),'.mat']);
BERstop=1e-4;

%% New plot
FontSize=18;
fig=figure;
axes('YScale','log');
if(bits_per_frame==6144)
    xlim([0.8, 1.8]);
end
ylim([1e-7, 1]);
set(fig,'Position',[100,100,750,450]);
set(gca,'FontSize',FontSize-2);
xlabel('$E_b/N_0$ (dB)','fontsize',FontSize,'interpreter','latex');
set(gca,'YTick',[1e-8 1e-7 1e-6 1e-5 1e-4 1e-3 1e-2 1e-1 1e0]);
%set(gca,'XTick',[0:0.5:3]);
ylabel('BER','fontsize',FontSize,'interpreter','latex');
grid;
set(gca,'YMinorGrid','off');
box on
hold on

% First benchmarker results
filename = ['Data/results_pivi_',num2str(bits_per_frame),'_',num2str(bits_per_frame),'.mat'];
load (filename,'results');
results_bcjr=results;
[~,m]=size(results);
SNR=results(:,1);
Throug=bits_per_frame/(3*bits_per_frame + 12);
Throug_dp=10*log10(Throug);
EbNo=SNR-Throug_dp;
BER=results(:,m)./results(:,2);
%BER=results(:,Iter(end)+2)./results(:,2);

l1=semilogy(EbNo,BER,'k','LineWidth',1.5,'MarkerEdgeColor','k','MarkerFaceColor','g','MarkerSize',6);

%first=['Log-BCJR, $K=N$\n, $I=' num2str(m-2),'$' ];
first = sprintf(['Log-BCJR ($K$=$N$), $I=', num2str(m-2),'$']);

BER=results_bcjr(:,m)./results_bcjr(:,2);
[N,~]=size(BER);
for i=1 : N
    if BER(i) <= BERstop
        SNRindx=i+0;
        bcjr_snr=results_bcjr(SNRindx,1);
        bcjr_EbNo=EbNo(SNRindx+1);
        break;
    end
end

% PIVI benchmarker results
filename = ['Data/results_pivi_',num2str(bits_per_frame),'_',num2str(bits_per_window),'.mat'];
load (filename,'results');
results_pivi=results;
[~,m]=size(results_pivi);

SNR=results_pivi(:,1);
Throug=bits_per_frame/(3*bits_per_frame + 12);
Throug_dp=10*log10(Throug);
EbNo=SNR-Throug_dp;
for k=3: 1:m
    BER=results_pivi(:,k)./results_pivi(:,2);
    if BER(SNRindx) <= BERstop
        pivi_iter=k-2;
        break;
    end
end

% second='Log-BCJR (PIVI), $I\in\{';
% for k=1: 1:(log2(m-2))-1  
%         second=strcat(second, num2str(Iter(k)));
%         second=strcat(second, ',');
% end
% second=strcat(second, num2str(Iter(k+1)));
% second=strcat(second, '\}$');
second='Log-BCJR (PIVI),\n CCs $\\in$ \\{';
for k=1:length(Iter)
    second=strcat(second, num2str(iter((iter(:,1)==Iter(k)),2),'%10.1e'));
    if(k<length(Iter))
        second=strcat(second, ',  ');
    end
    if(k==3)
        second=strcat(second, '\n');
    end
end
second=sprintf(strcat(second, '\\}'));

for k=1: 1:(log2(m-2))  
        BER=results_pivi(:,Iter(k)+2)./results_pivi(:,2);
        l2=semilogy(EbNo,BER,'*--k','LineWidth',1.5,'MarkerEdgeColor','k','MarkerFaceColor','g','MarkerSize',6);
        hold on
end

% Fully-parallel results
filename = ['Data/results_fp_',num2str(bits_per_frame),'_',num2str(bits_per_window),'.mat'];
load (filename,'results');
results_fp=results;
[~,m]=size(results_fp);

SNR=results_fp(:,1);
Throug=bits_per_frame/(3*bits_per_frame + 12);
Throug_dp=10*log10(Throug);
EbNo=SNR-Throug_dp;

for k=3: 1:m
    BER=results_fp(:,k)./results_fp(:,2);
    if BER(SNRindx) <= BERstop
        fp_iter=k-2;
        break;
    end
end

for k=1: 1: 3
        BER=results_fp(:,Iter(k)+2)./results_fp(:,2);
        l3=semilogy(EbNo,BER, 'o-b','LineWidth',1.5,'MarkerEdgeColor','b','MarkerSize',6);
        hold on
end
%BERgain=(pivi_EbNo-fp_EbNo)/pivi_EbNo*100   % print the BER gain!

%xlabel ('E_{b}/N_{0} (dB)','FontSize', 35)
%ylabel ('Bit Error Rate (BER)','FontSize', 35)
%set(gca, 'FontSize', 25)
%third='FP, $I\in\{2,4,8\}$';
%third=sprintf('FP, CCs $\\in$ \\{1.3e3, 1.5e3, 2.1e3\\}');
third='FP, CCs $\\in$ \\{';
for k=1:3
    third=strcat(third, num2str(iter((iter(:,1)==Iter(k)),2),'%10.1e'));
    if(k<3)
        third=strcat(third, ', ');
    end
end
third=sprintf(strcat(third, '\\}'));

 
I=legend([l1 l2 l3], {first,second,third}); 
set(legend,'Location','SouthWest','color','none','Box','off','interpreter','latex','FontSize',FontSize-2);

%rect = [0.25, 0.25, .25, .25];
%set(I, 'Position', rect)
%legend boxoff
%set(gcf, 'Position', get(0,'Screensize')); % Maximize figure. 
%ylim([1e-7 1]);
%xlim ([EbNo(1) EbNo(end)]);

