set term pslatex
set output 'SER1.tex' 
set key bottom left spacing 1.2 width 0 noautotitles nobox
set size square 0.93,2

set xlabel "$E_b/N_0~$[dB]" 
set ylabel "SER"  offset 5.8,0

set xrange [0.5:4.5] 
set yrange [1e-5:1e-0] 

set format y '$10^{%T}$'

set log y

#set ytics mirror 0,0.1,1
#set xtics mirror 0,0.1,1
#set grid xtics ytics

set arrow 5 from 1.18,0.0008 to 1.18,0.8 nohead
set label 1 "Capacity bound" at 1.05,0.0009 rotate left

#set arrow 1 from 2,0.001 to 1.6862,0.001
#set arrow 2 from 2,0.001 to  2.9272,0.001
#set label 2 "1.24 dB" at 1.95,0.0012 font "Times,10" 

#set arrow 3 from 3.5572,0.001 to  2.9272,0.001
#set arrow 4 from 4.0572,0.001 to 3.0572,0.001
#set label 3 "0.13 dB" at 3.2572,0.0012

      
plot 'EGCC_U1_C12_0.2.txt' using 2:3 with lp lt 1 pt 10 ps 2,\
'EGEC_U1_C12_0.2.txt' using 2:3 with lp lt 1 pt 6 ps 2,\
'REG_NoPro_U1_C91_0.2.txt' using 2:3 with lp lt 2 pt 4 ps 2,\
'REG_U1_C91_0.2.txt' using 2:3 with lp lt 1 pt 4 ps 2,\
'dummy.txt' using 1:2 title '  REGEC' with points pt 4 ps 2,\
'dummy.txt' using 1:2 title '  EGEC' with points pt 6 ps 2,\
'dummy.txt' using 1:2 title '  EG-CC' with points pt 10 ps 2,\
'dummy.txt' using 1:2 title 'With probs' with line lt 1,\
'dummy.txt' using 1:2 title 'No probs' with line lt 2
