set term pslatex
set output 'SER3.tex' 
set key bottom left spacing 1.2 width 0 noautotitles nobox
set size square 0.93,2

set xlabel "$E_b/N_0~$[dB]" 
set ylabel "SER"  offset 5.8,0

set xrange [0.5:4.5] 
set yrange [1e-5:1e-0] 

set format y '$10^{%T}$'

set log y

#set ytics mirror 0,0.1,1
#set xtics mirror 0,0.1,1
#set grid xtics ytics

set arrow 5 from 1.69,0.0008 to 1.69,0.8 nohead
set label 1 "Capacity bound" at 1.56,0.0009 rotate left

set arrow 1 from 4,0.001 to 4,0.6
set label 2 "UEC Converge at 8 dB" at 3.88,0.001 rotate left
#set arrow 2 from 2,0.001 to  2.9272,0.001
#set label 2 "1.24 dB" at 1.95,0.0012 font "Times,10" 

set arrow 3 from 2.5,0.001 to 1.69,0.001
set arrow 4 from 2.5,0.001 to 2.97,0.001
set label 3 "1.2 dB" at 2,0.0012

      
plot 'EGCC_U1_C12_0.6.txt' using 2:3 with lp lt 1 pt 10 ps 2,\
'EGEC_U1_C12_0.6.txt' using 2:3 with lp lt 1 pt 6 ps 2,\
'REG_NoPro_U1_C91_0.6.txt' using 2:3 with lp lt 2 pt 4 ps 2,\
'REG_U1_C91_0.6.txt' using 2:3 with lp lt 1 pt 4 ps 2,\
'UEC_U1_C12_0.6.txt' using 2:3 with lp lt 1 pt 8 ps 2,\
'dummy.txt' using 1:2 title '  REGEC' with points pt 4 ps 2,\
'dummy.txt' using 1:2 title '  EGEC' with points pt 6 ps 2,\
'dummy.txt' using 1:2 title '  EG-CC' with points pt 10 ps 2,\
'dummy.txt' using 1:2 title '  UEC' with points pt 8 ps 2,\
'dummy.txt' using 1:2 title 'With probs' with line lt 1,\
'dummy.txt' using 1:2 title 'No probs' with line lt 2
