set term pslatex
set output 'SER_video.tex' 
set key bottom left spacing 1.2 width 0 noautotitles nobox
set size square 1,2

set xlabel "$E_b/N_0~$[dB]" 
set ylabel "SER"  offset 5.8,0

set xrange [0.5:6] 
set yrange [1e-5:1e-0] 

set format y '$10^{%T}$'

set log y

#set ytics mirror 0,0.1,1
#set xtics mirror 0,0.1,1
#set grid xtics ytics

set arrow 5 from 1.3,0.0009 to 1.3,0.8 nohead
set label 1 "Capacity bound" at 1.15,0.0008 rotate left

set arrow 1 from 2,0.001 to 1.3,0.001
set arrow 2 from 2,0.001 to  2.74,0.001
set label 2 "1.4 dB" at 1.7,0.0012 font "Times,10" 

set arrow 3 from 3.00,0.001 to 2.74,0.001
set arrow 4 from 3.00,0.001 to 3.4,0.001
set label 3 "0.7 dB" at 2.8,0.0012

      
plot 'video_EGCC.txt' using 2:3 with lp lt 1 pt 10 ps 2,\
'video_EGEC.txt' using 2:3 with lp lt 1 pt 6 ps 2,\
'video_REGEC.txt' using 2:3 with lp lt 1 pt 4 ps 2,\
'video_REGEC_NoPro.txt' using 2:3 with lp lt 2 pt 4 ps 2,\
'video_UEC.txt' using 2:3 with lp lt 1 pt 8 ps 2,\
'dummy.txt' using 1:2 title '  REGEC' with points pt 4 ps 2,\
'dummy.txt' using 1:2 title '  EGEC' with points pt 6 ps 2,\
'dummy.txt' using 1:2 title '  EG-CC' with points pt 10 ps 2,\
'dummy.txt' using 1:2 title '  UEC' with points pt 8 ps 2,\
'dummy.txt' using 1:2 title 'With probs' with line lt 1,\
'dummy.txt' using 1:2 title 'No probs' with line lt 2

