% ======================== Description ==================================
% This script is an example about how to use he provided functions

% The Round Window compliance is set to be its nominal value
% If you want to plot results for for a stiffing round window, you will
% need to change C_RW in the functions provided, e.g. using C_RW=C_RW/100
% for the case the round window stiffness increases by a factor of 100.

% Written by          Guangjian NI       06/08/2016
%                     ISVR University of Southampton
%                     niguangjian@gmail.com

% MATLAB release: MATLAB R2015b
%%
clear
close all
clc
%% Test plot
nf=100; % number of frequency samples
freq=logspace(log10(100),log10(1e4),nf);
c1=[000 158 115]/255;  %  (dark green)
%% Cochlear input impedance 
Z_C=CochleaInputImpedance(freq);
figure(1)
set(gcf, 'Position', get(0,'Screensize'));
subplot(2,1,1)
loglog(freq, abs(Z_C),'-','linewidth',3,'color',c1)
set(gca,'FontSize',14);% Tick size
set(gca, 'FontName','Times New Roman');% Font type
xlabel('Frequency [Hz]','FontSize',18,'FontName','Times New Roman')
ylabel('|Z_C| [Pa s m^{-3}]','FontSize',18,'FontName','Times NewRoman')
xlim([100 10000])
ylim([1e10,1e13])
set(gca,'XTick',[100 1000 5000 10000])
subplot(2,1,2)
semilogx(freq, unwrap(angle(Z_C))/(2*pi),'-','linewidth',3,'color',c1)
set(gca,'FontSize',14);% Tick size
set(gca, 'FontName','Times New Roman');% Font type
xlabel('Frequency [Hz]','FontSize',18,'FontName','Times New Roman')
ylabel('\angle Z_C [Cycles]','FontSize',18,'FontName','Times NewRoman')
xlim([100 10000])
ylim([-0.3,0.3])
set(gca,'YTick',-0.3:0.1:0.3)
set(gca,'XTick',[100 1000 5000 10000])
%% Ear durm impedance
Ped_by_Qed = EarDrumImpedance(freq);
figure(2)
set(gcf, 'Position', get(0,'Screensize'));
subplot(2,1,1)
semilogx(freq, 20*log10(abs(Ped_by_Qed)),'-','linewidth',3,'color',c1)
set(gca,'FontSize',14);% Tick size
set(gca, 'FontName','Times New Roman');% Font type
xlabel('Frequency [Hz]','FontSize',18,'FontName','Times New Roman')
ylabel('|p_{ed}/q_{ed}| [dB]','FontSize',18,'FontName','Times NewRoman')
xlim([100 10000])
set(gca,'XTick',[100 1000 5000 10000])
ylim([140,180])
set(gca,'YTick',140:10:180)

subplot(2,1,2)
semilogx(freq, unwrap(angle(Ped_by_Qed))/(2*pi),'-','linewidth',3,'color',c1)
set(gca,'FontSize',14);% Tick size
set(gca, 'FontName','Times New Roman');% Font type
xlabel('Frequency [Hz]','FontSize',18,'FontName','Times New Roman')
ylabel('\angle p_{ed}/q_{ed} [Cycles]','FontSize',18,'FontName','Times NewRoman')
xlim([100 10000])
ylim([-0.5,0.25])
set(gca,'YTick',-0.5:0.25:0.25)
set(gca,'XTick',[100 1000 5000 10000])
%% p_BM to p_ME
pBM_pME = pBM_pME(freq);
figure(3)
set(gcf, 'Position', get(0,'Screensize'));
subplot(2,1,1)
loglog(freq, abs(pBM_pME),'-','linewidth',3,'color',c1)
set(gca,'FontSize',14);% Tick size
set(gca, 'FontName','Times New Roman');% Font type
xlabel('Frequency [Hz]','FontSize',18,'FontName','Times New Roman')
ylabel('|p_{BM}/p_{ME}|','FontSize',18,'FontName','Times NewRoman')
xlim([100 10000])
ylim([1e-3,1])
set(gca,'XTick',[100 1000 5000 10000])

subplot(2,1,2)
semilogx(freq, unwrap(angle(pBM_pME))/(2*pi),'-','linewidth',3,'color',c1)
set(gca,'FontSize',14);% Tick size
set(gca, 'FontName','Times New Roman');% Font type
xlabel('Frequency [Hz]','FontSize',18,'FontName','Times New Roman')
ylabel('\angle p_{BM}/p_{ME} [Cycles]','FontSize',18,'FontName','Times NewRoman')
xlim([100 10000])
ylim([-1.5,0.5])
set(gca,'XTick',[100 1000 5000 10000])