function G = parallel_side_by_side_rad_kernel(kr)
%computes the component of the radiation dernel in the direction of two
%parallel dipoles that are perpendicular to the vector that separates them.
% kr - the separation distance in units of lambda/2pi

Re_G = cos(kr)./kr - sin(kr)./(kr.^2) - cos(kr)./(kr.^3);
Im_G = sin(kr)./kr + (cos(kr)-sin(kr)./(kr))./(kr.^2);
G = Re_G + 1i * Im_G;