function F = cdf_of_r(r,sigma_rho,sigma_z)
%This function computes the cumulative distribution function for the
%distance of an atom from the center of the trap

F = zeros(size(r));
f = @(rr) pdf_of_r(rr,sigma_rho,sigma_z);
F(1) = integral(f,0,r(1));
for n=2:numel(r)
    F(n) = F(n-1) + integral(f,r(n-1),r(n));
end