function [h_fig, h_top, h_mid, h_bot] = make_3_stacked_axes()
%% This function produces a figure with 2 axes, and returns the figure and
%% axis handles.  

journal_plot_params;
norm_ax_width = 0.81;
norm_ax_height = 0.27;
norm_inset_bottom = 0.55;
norm_inset_width = 0.4;
norm_inset_height = 0.4;
left_space_1 = 0.15;
left_space_2 = 0.12;
v_space = 0.11;
v_space_2 = 0.03;
ax_mid_start = v_space + norm_ax_height+v_space_2;
ax_top_start = v_space + 2*(norm_ax_height+v_space_2);

h_fig = figure('units','centimeters',...
    'Position', [10 10 width_1 2.5*height_1_2]);

set(h_fig,'Renderer','painters');
set(h_fig,'PaperUnits','centimeters');
set(h_fig,'PaperSize',[width_1 2.5*height_1_2]);
set(h_fig,'PaperPositionMode','manual');
set(h_fig,'PaperPosition',[0 0 width_1 2.5*height_1_2]);

h_bot = axes('Units','normalized',...
    'LineWidth',alw,...
    'Position',[left_space_1 v_space norm_ax_width norm_ax_height],...
    'FontUnits','points', ...
    'FontWeight','normal',...
    'FontSize', fsz,...
    'FontName', f_name);

h_mid = axes('Units','normalized',...
     'LineWidth',alw,...
     'Position',[left_space_1 ax_mid_start norm_ax_width norm_ax_height],...
     'FontUnits','points', ...
     'FontWeight','normal',...
     'FontSize', fsz,...
     'FontName', f_name);

h_top = axes('Units','normalized',...
     'LineWidth',alw,...
     'Position',[left_space_1 ax_top_start norm_ax_width norm_ax_height],...
     'FontUnits','points', ...
     'FontWeight','normal',...
     'FontSize', fsz,...
     'FontName', f_name);
h_mid.XTickLabelMode='manual';
h_top.XTickLabelMode='manual';
remove_x_tick_labels(h_top);
remove_x_tick_labels(h_mid);

