% make_shift_relFluor_fig.m

plotLine = @(x,y,style,color_number) plot(x,y,style,'LineWidth',lw,'MarkerSize',msz,'MarkerFaceColor',line_colors(color_number,:));

[h_shift_rel_flor, h_shift, h_rf] = make_2_axes();
axes(h_shift);
hold on;
plotLine(data_hom.N_at, data_hom.shift, '-ks',1);
plot_shift_vs_N_ebar(h_shift,data_inhom_5_Gamma,2,'x');
plot_shift_vs_N_ebar(h_shift,data_inhom_10_Gamma,3,'d');
plot_shift_vs_N_ebar(h_shift,data_inhom_50_Gamma,4,'o');
plot(data_hom.N_at,-3.2104e-3*data_hom.N_at,'--k');
axis([0 450 -2 0.5]);
h_shift.YTick = [-2 -1 0];
h_shift.FontSize = fsz;
journal_xlabel(h_shift,'$N$');
journal_ylabel(h_shift,'Shift$(N)/\Gamma$');
h_a = text(40,0.3,'(a)','FontSize',l_fsz,'FontName',f_name);

%% Now, we take care of th relative fluorescence

% Now plot the relative fluorescence
axes(h_rf);
hold on;
% define a shortcut to plot a formatted line
plt_rf = @(data,color_number,marker) plot(data.N_at, data.rel_fluor, strcat('-',marker), ...
    'MarkerFaceColor',line_colors(color_number,:),...
    'MarkerEdgeColor',line_colors(color_number,:),'Color',line_colors(color_number,:),...
    'LineWidth',lw,'MarkerSize',msz);
plt_rf(data_hom,1,'s');
plt_rf(data_inhom_5_Gamma,2,'x');
plt_rf(data_inhom_10_Gamma,3,'d');
plt_rf(data_inhom_50_Gamma,4,'o');
plot([0 500], [0 500], '--k','LineWidth',lw);
axis([0 450 0 450]);
h_rf.FontSize = fsz;
journal_xlabel(h_rf,'$N$');
h_ylab = journal_ylabel(h_rf,'Relative fluorescence');
% move the y-label so that it does not overlap with other plot
pos = h_ylab.Position;
pos(1) = pos(1) + 25;
h_ylab.Position = pos;
h_b = text(30,400,'(b)','FontSize',l_fsz,'FontName',f_name);

