% make_spectrum_plots.m

journal_plot_params;

labPos = [4 10];
textLab = @(lab) text(labPos(1),labPos(2),lab,'FontSize',l_fsz,'FontName',f_name);

[h_fig_spec, h_spec_2l_a, h_spec_ml_b] = make_2_axes();
plot_semi_log_spectra(data_hom_2_level,h_spec_2l_a);
journal_xlabel(h_spec_2l_a,'$\Delta/\Gamma$');
h_spec_2l_a.FontSize = fsz;
h_spec_2l_a.YScale = 'log';
textLab('(a)');
h_y = journal_ylabel(h_spec_2l_a,'$I_{\mathrm{Scatt}}$');
h_y.Position = h_y.Position + [0.5 0 0];

plot_semi_log_spectra(data_hom,h_spec_ml_b);
h_spec_ml_b.FontSize = fsz;
h_spec_ml_b.XLim = [-6 6];
h_spec_ml_b.YLim = h_spec_2l_a.YLim;
journal_xlabel(h_spec_ml_b,'$\Delta/\Gamma$');
h_spec_ml_b.YScale = 'log';
textLab('(b)');
