function [V_av tot_ex] = average_dipole_dipole_energy_parallel_dip(Delta,kr)
%This function produces the average dipole-dipole interaction enerby in
%response to an incident field (with amplitude 1 in dimensionless units)
%for a range of single-atom detunings Delta and distances (kr). 

N_Delta = numel(Delta);
N_kr = numel(kr);
Delta = reshape(Delta,N_Delta,1);
kr = reshape(kr,1,N_kr);

tot_ex = zeros(N_Delta,N_kr);
V_av = zeros(N_Delta,N_kr);
for n_kr = 1:N_kr
    for n_D = 1:N_Delta
        b = twoLevel.twoAtom.parallel_side_by_side_response(Delta(n_D),kr(n_kr));
        tot_ex(n_D,n_kr) = b'*b;
        G = twoLevel.twoAtom.parallel_side_by_side_rad_kernel(kr(n_kr));
        V_av(n_D,n_kr) = -3*real(conj(b(2))*b(1))*real(G);
    end
end
