% DD_interaction_plot_data.m
% 2015-07-29
% Stewart D. Jenkins

N = 450;


sigma_rho = 2*pi*0.3204;
sigma_z = 2.4359*2*pi;
f_pdf_times_r = @(r) r.*pdf_nearest_neighbor_to_center(r,sigma_rho,sigma_z,N);
r_bar = integral(f_pdf_times_r,0,10);

kr = (1:200)*1.5/200;
f_nn = pdf_nearest_neighbor_to_center(kr,sigma_rho,sigma_z,N);
F_nn = cdf_nearest_neighbor_to_center(kr,sigma_rho,sigma_z,N);


[ssr_shift, Gamma_super, Gamma_sub] = supersubrad_parallel_dip_shifts(kr);

Delta_dd = supersubrad_parallel_dip_shifts(r_bar);
[V_av, tot_ex] = twoLevel.twoAtom.average_dipole_dipole_energy_parallel_dip(Delta_dd,kr);
[V_av_1, tot_ex_1] = twoLevel.twoAtom.average_dipole_dipole_energy_parallel_dip(0,kr);

