% dd_interaction_figure.m 

[h_dd_int,h_nn_dist,h_dd_shift,h_V_av] = make_3_stacked_axes;
plot_curve = @(h_ax,x,y,type,color) plot(h_ax,x,y,type,'Color',color,'LineWidth',lw);
plot_curve(h_nn_dist,kr,f_nn,'-k',line_color_1);
axis(h_nn_dist); hold on;
plot(h_nn_dist,[r_bar r_bar], h_nn_dist.YLim,'--k','LineWidth',lw);
journal_ylabel(h_nn_dist,'$p_{nn}$');
h_nn_dist.XLim = [0 max(kr)];
h_nn_dist.FontSize = fsz;
text(0.05*max(kr),0.9*h_nn_dist.YLim(2),'(a)','FontSize',l_fsz,'FontName',f_name);
remove_x_tick_labels(h_nn_dist);

plot_curve(h_dd_shift,kr,ssr_shift,'-k',[0 0 1]);
hold(h_dd_shift,'on');
plot_curve(h_dd_shift,kr,ssr_shift+Gamma_super/2,'--k',[0 0 1]);
plot_curve(h_dd_shift,kr,ssr_shift-Gamma_super/2,'--k',[0 0 1]);
plot_curve(h_dd_shift,kr,-ssr_shift,'-k',[1 0 0]);
plot_curve(h_dd_shift,kr,-ssr_shift+Gamma_sub/2,'--k',[1 0 0]);
plot_curve(h_dd_shift,kr,-ssr_shift-Gamma_sub/2,'--k',[1 0 0]);
h_dd_shift.YLim = [-5 5];
h_dd_shift.XLim = [0 max(kr)];
h_dd_shift.FontSize = fsz;
plot(h_dd_shift,[r_bar r_bar], h_dd_shift.YLim,'--k','LineWidth',lw);
remove_x_tick_labels(h_dd_shift);
axes(h_dd_shift);
text(0.05*max(kr),0.8*h_dd_shift.YLim(2),'(b)','FontSize',l_fsz,'FontName',f_name);
journal_ylabel(h_dd_shift,'$\delta/\Gamma$');

plot_curve(h_V_av,kr,V_av,'-k',[0 0 0]);
hold(h_V_av,'on');
plot_curve(h_V_av,kr,V_av_1,'--k',line_color_7);
plot(h_V_av,[r_bar r_bar], h_V_av.YLim,'--k','LineWidth',lw);
h_V_av.XLim = [0 max(kr)];
axes(h_V_av);
text(0.05*max(kr),0.9*h_V_av.YLim(2),'(c)','FontSize',l_fsz,'FontName',f_name);
h_V_av.FontSize=fsz;
journal_xlabel(h_V_av,'$r/[\lambda/(2\pi)]$');
journal_ylabel(h_V_av,'$V_{dd}/(\hbar\Gamma)$');
