function f = pdf_of_r(r,sigma_rho,sigma_z)
% The probability density of finding a particle a distance r from the
% center of a Gaussian cloud with axial width sigma_z and radial width
% sigma_rho.

% r - is a vector of radii.
% sigma_rho - the radial width of the cigar/pancake shaped cloud
% sigma_z - the longitudinal width of the cloud

if sigma_rho == sigma_z
    f = 2*r.^2 * exp(-0.5*(r/sigma_rho).^2)/(sigma_rho^2*sigma_z*sqrt(2*pi));
else
    sig2_eff = sigma_z^2*sigma_rho^2/(sigma_rho^2-sigma_z^2);
    h = @(z) exp(-z.^2/(2*sig2_eff));
    f= zeros(size(r));
    for n=1:numel(r)
        f(n) = 2*r(n)/(sigma_rho^2*sigma_z*sqrt(2*pi)) *  exp(-0.5*(r(n)/sigma_rho)^2) ...
            * integral(h,0,r(n));
    end
end