function shift = peak_single_atom_intensity(p,B)
% Let p be the vector indicating atomic populations with elements
% p_{-2},\ldots, p_{1},p_{2}

Rb87_constants;

m = -2:2;
m = reshape(m,size(p));
c = zeros(size(m));
delta = zeros(size(m));
for i = 1:5
    c(i) = ClebschGordan(F_g,1,F_e,m(i),1,m(i)+1);
    delta(i) = (g_e*(m(i)+1) - g_g*m(i)) * mu_B_on_Gamma * B;
end

L_Deriv = @(Delta) - 2 * sum(p.*c.^4.*(Delta-delta)./((Delta-delta).^2 + 0.25));
shift = fzero(L_Deriv,delta(5));
