function h_plot = plot_shift_vs_N_ebar(h_ax,data,color_number,marker,isFilled)
% Add a plot of shift vs number of atoms with error bars 

journal_plot_params;

if nargin < 7
    isFilled = 1;
end
if isFilled == 0;
    faceColor = [1, 1, 1];
else
    faceColor = line_colors(color_number,:);
end
L = data.shift - data.shift_ci(1,:);
U = data.shift_ci(2,:) - data.shift;
h_plot = errorbar(h_ax,data.N_at,data.shift,L,U,strcat('-',marker),'MarkerFaceColor',faceColor,...
    'MarkerEdgeColor',line_colors(color_number,:),'Color',line_colors(color_number,:),...
    'LineWidth',lw,'MarkerSize',msz);