#setdep @node|StrainExtraction@
#setdep @node|Slice_2D@

#if @[string match @Domain@ "TN"]@
#-- NMOS Specification
#define _Vg_    @Vg@
#define _Vd_    @Vd@	
#define _QC_     
#define _CAR_    Electron
#elif @[string match @Domain@ "TP"]@
#-- PMOS Specification
#define _Vg_    @Vg@	
#define _Vd_    @Vd@	
#define _QC_     
#define _CAR_    Hole

#endif

File {
  Grid      = "n@node|Slice_2D@_msh.tdr"
  Parameter = "@parameter@"
  Plot      = "@tdrdat@"
  Current   = "@plot@"
  Output    = "@log@"
  NonLocalPlot=   "n@node@_nonlocal.plt"
}

#if "@Domain@" == "TN"
NonLocalPlot((0 0))
        { eDensity }
#else
NonLocalPlot((0 0))
        { hDensity }
#endif

Electrode {
  
#if @[string match @Domain@ "TN"]@
  { Name= "gate"      Voltage= 0.0 workfunction= 4.2 }


#elif @[string match @Domain@ "TP"]@
  { Name= "gate"      Voltage= 0.0 workfunction= 4.9 }
  
#endif
  { Name= "source"    Voltage= 0.0 }
  { Name= "drain"     Voltage= 0.0 }
}

Physics{
#include "DD_Physics_des.cmd"
}

Physics (material= "Silicon") {
	_QC_
}


Math(MaterialInterface="Oxide/Silicon") {
    NonLocal(
        Length=@<YMax*1.e3*1.e-7*2>@
        Permeation=@<YMax*1.e3*1.e-7*2>@
        Direction=(0 1 0)
        MaxAngle=1.e-5
        -Outside
    )
}


Plot{
  NonLocal
  eDensity hDensity
  TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
  eMobility hMobility
  eVelocity hVelocity
  eQuasiFermi hQuasiFermi
  eTemperature Temperature * hTemperature
  ElectricField/Vector Potential SpaceCharge
  Doping DonorConcentration AcceptorConcentration
  SRH Band2Band * Auger
  AvalancheGeneration eAvalancheGeneration hAvalancheGeneration
  eGradQuasiFermi/Vector hGradQuasiFermi/Vector
  eEparallel hEparallel eENormal hENormal
  BandGap 
  BandGapNarrowing
  Affinity
  ConductionBand ValenceBand
  eBarrierTunneling hBarrierTunneling * BarrierTunneling
  eTrappedCharge  hTrappedCharge
  eGapStatesRecombination hGapStatesRecombination
  eDirectTunnel hDirectTunnel
  Stress/Tensor
}

Math {
  Extrapolate
  Digits= 5
  RHSmin= 1e-10
  Notdamped= 50
  Iterations= 20
  ExitOnFailure
}

Solve {
NewCurrentPrefix="init_"
	Coupled ( Iterations= 100 LineSearchDamping= 1e-8 ){ Poisson _QC_}
	Plot(FilePrefix="n@node@_ini")
#-- Ramp drain to VdSat
  Quasistationary( 
    InitialStep= 1e-3 Increment= 1.5 
    MinStep= 1e-6 MaxStep= 0.25
    
    Goal { Name= "drain"  Voltage= _Vd_ }

  ){ Coupled { Poisson _CAR_ _QC_} }
    Save ( FilePrefix= "n@node@_VdSat" )
NewCurrentPrefix=""
    Quasistationary( 
    DoZero 
    InitialStep= 1e-2 Increment= 1.45 
    MinStep= 1e-6 MaxStep= 0.25
    Goal { Name= "gate" Voltage= _Vg_ }

  ){ Coupled { Poisson _CAR_ _QC_} }
  
  Save(FilePrefix="n@node@")
NewCurrentPrefix="Charge_"
  Quasistationary( 
    InitialStep= 1e-3 Increment= 1.5 
    MinStep= 1e-6 MaxStep= 0.25
    
    Goal { Name= "drain"  Voltage= 0 }

  ){ Coupled { Poisson _CAR_ _QC_} }
}

