#setdep @node|DD_NoQC@ 
#setdep @node|DD_QC@

#set EPSOXNEW 3.9

proj_load "n@node|-3@_nonlocal.plt" qmnonloc

puts "proj_load = n@node|-3@_nonlocal.plt"


# Charge centroid for high bias
cv_createDS qmdist "qmnonloc Pos(0,0) Distance" "qmnonloc Pos(0,0) Distance"
#if "@Domain@" == "TN"
cv_createDS qmdens "qmnonloc Pos(0,0) Distance" "qmnonloc Pos(0,0) eDensity"
#else
cv_createDS qmdens "qmnonloc Pos(0,0) Distance" "qmnonloc Pos(0,0) hDensity"
#endif
cv_createWithFormula qmnenn "integr(<qmdens>)" 0.0 @<HalfFin>@
cv_createWithFormula qmzaehl "integr(<qmdens>*<qmdist>)" 0.0 @<HalfFin>@


# xqm is computed from the high bias curve
set xqm  [ cv_compute "vecmax(<qmzaehl>)/vecmax(<qmnenn>)" A A A A ]


proj_load "n@node|-1@_nonlocal.plt" nonloc

puts "proj_load = n@node|-1@_nonlocal.plt"

# Charge centroid for high bias
cv_createDS dist "nonloc Pos(0,0) Distance" "nonloc Pos(0,0) Distance"
#if "@Domain@" == "TN"
cv_createDS dens "nonloc Pos(0,0) Distance" "nonloc Pos(0,0) eDensity"
#else
cv_createDS dens "nonloc Pos(0,0) Distance" "nonloc Pos(0,0) hDensity"
#endif
cv_createWithFormula nenn "integr(<dens>)" 0.0 @<HalfFin>@
cv_createWithFormula zaehl "integr(<dens>*<dist>)" 0.0 @<HalfFin>@


# xcl is computed from the high bias curve
set xcl  [ cv_compute "vecmax(<zaehl>)/vecmax(<nenn>)" A A A A ]

puts $xqm
puts $xcl

# extract the computed values to the GENESISe family table
set epsnew [expr @<tox>@/(@<tox>@/3.9+($xqm-$xcl)/11.7)]

ft_scalar EPSOXNEW [ format %.3f $epsnew ]
puts  "New oxide epsilon  = $epsnew"
puts  "\n"

exit
