#setdep @node|sprocess@

#if @[string match @Domain@ "TN"]@
#-- NMOS Specification
#define _Vgg_    @Vgg@	
#define _VdLin_  0.05
#define _VdSat_  1.3
#define _QC_     eQuantumPotential
#define _CAR_    Electron
#elif @[string match @Domain@ "TP"]@
#-- PMOS Specification
#define _Vgg_    @Vgg@	
#define _VdLin_  -0.05
#define _VdSat_  -1.3
#define _QC_     hQuantumPotential
#define _CAR_    Hole

#endif

File {
  Grid      = "@tdr@"
  Parameter = "@parameter@"
  Plot      = "@tdrdat@"
  Current   = "@plot@"
  Output    = "@log@"
}

Electrode {
  
#if @[string match @Domain@ "TN"]@
  { Name= "gate"      Voltage= 0.0 workfunction= 4.2 }

#elif @[string match @Domain@ "TP"]@
  { Name= "gate"      Voltage= 0.0 workfunction= 4.9 }
  
#endif
  { Name= "source"    Voltage= 0.0 }
  { Name= "drain"     Voltage= 0.0 }
  { Name= "substrate" Voltage= 0.0 }
}

Physics{
  Mobility(
    PhuMob
    HighFieldSaturation( GradQuasiFermi )
    Enormal ( Lombardi( AutoOrientation ) )
    )
  EffectiveIntrinsicDensity( OldSlotboom )
  Recombination(SRH(DopingDep))
  Piezo(
    Model(
      DeformationPotential
      Mobility(
         eSubBand(Doping)
         hTensor(Kanda)
      	      )
         )
       )
}

Physics (material= "Silicon") {
      _QC_
}


Plot{
  eDensity hDensity
  TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
  eMobility hMobility
  eVelocity hVelocity
  eQuasiFermi hQuasiFermi
  eTemperature Temperature * hTemperature
  ElectricField/Vector Potential SpaceCharge
  Doping DonorConcentration AcceptorConcentration
  SRH Band2Band * Auger
  AvalancheGeneration eAvalancheGeneration hAvalancheGeneration
  eGradQuasiFermi/Vector hGradQuasiFermi/Vector
  eEparallel hEparallel eENormal hENormal
  BandGap 
  BandGapNarrowing
  Affinity
  ConductionBand ValenceBand
  eBarrierTunneling hBarrierTunneling * BarrierTunneling
  eTrappedCharge  hTrappedCharge
  eGapStatesRecombination hGapStatesRecombination
  eDirectTunnel hDirectTunnel
}

Math {
  Extrapolate
  Derivatives
  Avalderivatives
  RelErrControl
  Digits= 5
  RHSmin= 1e-10
  Notdamped= 50
  Iterations= 20
  ExitOnFailure
  method= ILS
  *Number_Of_Threads = 4
}

Solve {
  Coupled ( Iterations= 100 LineSearchDamping= 1e-8 ){ Poisson _QC_}
    Save ( FilePrefix= "n@node@_init" )
#if 0
    Quasistationary(
    DoZero
    InitialStep= 1e-3 Increment= 1.5 
    MinStep= 1e-6 MaxStep= 0.025
    
#if @[string match @Domain@ "TP"]@
	Goal { Name= "drain"  Voltage= _VdLin_ }
#elif @[string match @Domain@ "TN"]@
    	Goal { Name= "drain" Voltage= _VdLin_ }
#endif

  ){ Coupled { Poisson _CAR_ _QC_} }
  Save ( FilePrefix= "n@node@_VdLin" )
#endif
#-- Ramp drain to VdSat
  Load ( FilePreFix= "n@node@_init" )
  Quasistationary( 
    InitialStep= 1e-3 Increment= 1.5 
    MinStep= 1e-6 MaxStep= 0.025
    
#if @[string match @Domain@ "TP"]@
    Goal { Name= "drain"  Voltage= _VdSat_ }
#elif @[string match @Domain@ "TN"]@
    Goal { Name= "drain" Voltage= _VdSat_ }   
#endif

  ){ Coupled { Poisson _CAR_ _QC_} }
    Save ( FilePrefix= "n@node@_VdSat" )
#if 0
#-- Vg sweep for Vd=VdLin
  NewCurrentFile= "IdVg_VdLin_" 
  Load ( FilePrefix= "n@node@_VdLin" )
  Quasistationary( 
    DoZero 
    InitialStep= 1e-3 Increment= 1.45 
    MinStep= 1e-6 MaxStep= 0.025
    Goal { Name= "gate" Voltage= _Vgg_ }
    
  ){ Coupled { Poisson _CAR_ _QC_} }
  
#-- Vg sweep for Vd=VdSat
  NewCurrentFile= "IdVg_VdSat_" 
  Load ( FilePrefix= "n@node@_VdSat" )
#endif
  Quasistationary( 
    DoZero 
    InitialStep= 1e-2 Increment= 1.45 
    MinStep= 1e-6 MaxStep= 0.025
    Goal { Name= "gate" Voltage= _Vgg_ }

  ){ Coupled { Poisson _CAR_ _QC_} }
}

