#setdep @tool|sprocess@

#set Exx 0.0
#set Eyy 0.0
#set Ezz 0.0
#set Eyz 0.0
#set Exz 0.0
#set Exy 0.0


# stress tensor extracted from channel source-side in mechanical simulation 
set sxx @Sxx_Pa@
set syy @Syy_Pa@
set szz @Szz_Pa@
set syz 0.0
set sxz 0.0
set sxy 0.0

set txx [ expr $sxx ]
set tyy [ expr $syy ]
set tzz [ expr $szz ]
set tyz [ expr $syz ]
set txz [ expr $sxz ]
set txy [ expr $sxy ]

puts  "Stress Sxx (simulation coordinates) = $txx"
puts  "Stress Syy (simulation coordinates) = $tyy"
puts  "Stress Szz (simulation coordinates) = $tzz"

# Transform stress to band structure coordinate system
set sxx [ expr $txx ]
set syy [ expr $tzz ]
set szz [ expr $tyy ]
set syz [ expr -$tyz ]
set sxz [ expr -$txy ]
set sxy [ expr $txz ]

# Transform stress to principal crystallographic coordinate system
#if "@channel@" == "110"
set txx [ expr 0.5*($sxx-2.0*$sxz+$szz) ]
set tyy [ expr 0.5*($sxx+2.0*$sxz+$szz) ]
set tzz [ expr 1.0*$syy ]
set tyz [ expr -($sxy+$syz)/sqrt(2.0) ]
set txz [ expr ($syz-$sxy)/sqrt(2.0) ]
set txy [ expr 0.5*($sxx-$szz) ]
#else
set txx [ expr $sxx ]
set tyy [ expr $syy ]
set tzz [ expr $szz ]
set tyz [ expr $syz ]
set txz [ expr $sxz ]
set txy [ expr $sxy ]
#endif

# Compute the symmetric strain tensor
set S11 [ expr 0.77*1.0e-11 ]
set S12 [ expr -0.21*1.0e-11 ]
set S44 [ expr 1.25*1.0e-11 ]

set exx [ expr $S11*$txx+$S12*($tyy+$tzz) ]
set eyy [ expr $S11*$tyy+$S12*($txx+$tzz) ]
set ezz [ expr $S11*$tzz+$S12*($txx+$tyy) ]
set eyz [ expr 0.5*$S44*$tyz ]
set exz [ expr 0.5*$S44*$txz ]
set exy [ expr 0.5*$S44*$txy ]

# extract the computed values to the SWB table

ft_scalar Exx  [ format %.6f $exx   ]
puts  "Stress Exx (simulation coordinates) = $exx"
ft_scalar Eyy  [ format %.6f $eyy   ]
puts  "Stress Eyy (simulation coordinates) = $eyy"
ft_scalar Ezz  [ format %.6f $ezz   ]
puts  "Stress Ezz (simulation coordinates) = $ezz"
ft_scalar Eyz  [ format %.6f $eyz   ]
puts  "Stress Eyz (simulation coordinates) = $eyz"
ft_scalar Exz  [ format %.6f $exz   ]
puts  "Stress Exz (simulation coordinates) = $exz"
ft_scalar Exy  [ format %.6f $exy   ]
puts  "Stress Exy (simulation coordinates) = $exy"

puts  "\n"


exit

