#set YMax 0
#set XMax 0
#set HalfFin 0
#header

proc ChangeMaterialMatchRegions {args} {
 # ChangeMaterialMatchRegions - procedure to chage the material
 # for regions that contain certain stem in the name
 # It take the following three arguments:
 # NameStem - name stem;
 # NewMat   - new material;
 # ZeroData - Reset Doping Data
     global ExecuteOn    
    if { ! $ExecuteOn } {
       if {[llength $args] < 2} {
          error "ChangeMaterialMatchRegions: wrong number of arguments"
          exit -1
       }
    }
    set NameStem   [lindex $args 0]
    set NewMat     [lindex $args 1]
    set ZeroData   [lindex $args 2]
    
    set Regions [region list.bulk]
    foreach LocalRegion $Regions {
        if { [string match $NameStem* $LocalRegion] && [string match $ZeroData Nozerodata] } {
           region name=$LocalRegion $NewMat change.material !zero.data
           }
        if { [string match $NameStem* $LocalRegion] && [string match $ZeroData zerodata] } {
           region name=$LocalRegion $NewMat change.material zero.data
        }
    }

  return;

}

proc HexaPrism {args} {
#rem # HexaPrism - procedure to create prism from hexagon along SProcess Z
#rem # using 
#rem # It take the following arguments:
#rem # 0. Name - name of the prism
#rem # 1. Height - height of the prism
#rem # 2. DeltaX - Prism center translation along SProcess X (optional, default=0)
#rem # 3. DeltaZ - Prism center translation along SProcess Z (optional, default=0)
#rem # 4. DeltaY - Prism center translation along SProcess Y (optional, default=0)
#rem # 5. alpha  - Prism hexagon angle measured from YZ plane(optional, default=60)
#rem # 6. ZZ     - Prism hegagon diagonal   along SProcess Z (optional)
#rem # 7. YY     - Prism width             along SProcess YY (optional, default=height)


       if {[llength $args] < 2 || [llength $args] > 8} {
          error "HexaPrism: wrong number of arguments"
          exit -1
       }
    set name      [lindex $args 0]
    set h         [lindex $args 1]
    set dx 0
    set dy 0
    set dz 0
    if {[llength $args] > 2 } {
      set dx  [lindex $args 2]
    }
    if {[llength $args] > 3 } {
      set dz  [lindex $args 3]
    }
    if {[llength $args] > 4 } {
      set dy  [lindex $args 4]
    }
    if {[llength $args] > 5 } {
      set alpha  [expr [lindex $args 5]*atan(1.0)/45.0]
    } else {
      set alpha [ expr 60.0*atan(1.0)/45.0]
    }
    if {[llength $args] > 6 } {
      set zz  [lindex $args 6]
    } else {
      set zz $h
    }
    if {[llength $args] == 8 } {
      set yy  [lindex $args 7]
    } else {
      set yy  [expr  $h*(1.0+1.0/tan($alpha))/2.0 ]
    }
   
    set x1 [expr  $h/2.0 + $dx]
    set x2 $dx 
    set x3 [expr -$h/2.0 + $dx]
    
    set z1 [expr -$zz/2.0 + $dz]
    set z2 [expr  $zz/2.0 + $dz]
    
    set y1 [expr  $yy/2.0+$dy]
    set y2 [expr -$yy/2.0+$dy]
    set y3 [expr  $yy/2.0-$h/(tan($alpha)*2.0)+$dy]
    set y4 [expr -$yy/2.0+$h/(tan($alpha)*2.0)+$dy]
    if {$y3 < $y4} {
         error "ERROR: inconsistent input: check heigh ,width and angle!"
         exit 1
    }

    # Points
    point name= p1_$name coord= { $x1 $y4 $z1}
    point name= p2_$name coord= { $x1 $y3 $z1}
    point name= p3_$name coord= { $x2 $y1 $z1}
    point name= p4_$name coord= { $x3 $y3 $z1 }
    point name= p5_$name coord= { $x3 $y4 $z1}
    point name= p6_$name coord= { $x2 $y2 $z1 }
    point name= p7_$name coord= { $x1 $y4 $z2}
    point name= p8_$name coord= { $x1 $y3 $z2}
    point name= p9_$name coord= { $x2 $y1 $z2}
    point name= p10_$name coord= { $x3 $y3 $z2}
    point name= p11_$name coord= { $x3 $y4 $z2}
    point name= p12_$name coord= { $x2 $y2 $z2}
    
    # Polygons
    polygon name= hex1_$name   points= " p1_$name p2_$name p3_$name p4_$name p5_$name p6_$name "
    polygon name= hex2_$name   points= " p7_$name p8_$name p9_$name p10_$name p11_$name p12_$name "
    polygon name= rec1_$name   points= " p1_$name p2_$name p8_$name p7_$name "
    polygon name= rec2_$name   points= " p2_$name p8_$name p9_$name p3_$name "
    polygon name= rec3_$name   points= " p3_$name p9_$name p10_$name p4_$name "
    polygon name= rec4_$name   points= " p4_$name p10_$name p11_$name p5_$name "
    polygon name= rec5_$name   points= " p5_$name p11_$name p12_$name p6_$name "
    polygon name= rec6_$name   points= " p6_$name p12_$name p7_$name p1_$name "
    
    polyhedron name= $name polygons= " hex1_$name hex2_$name rec1_$name rec2_$name rec3_$name rec4_$name rec5_$name rec6_$name" info= 2
}

#rem # PARALLEL and unified coordinate system
math numThreads= 8
math coord.ucs

pdbSet ImplantData ResistSkip 1
pdbSet ImplantData BackBoundary  Reflect
pdbSet ImplantData LeftBoundary  Reflect
pdbSet ImplantData FrontBoundary Reflect
pdbSet ImplantData RightBoundary Reflect
pdbSet Silicon SiliconGermanium.ConversionConc 2e23
pdbSetBoolean Mechanics StressHistory 1

## Design Rule
fset PolyPitch 0.130
fset GateThick 0.025
fset IsoPitch  0.14
#fset FinPitch  0.05
fset FinPitch 0.045

fset debug 1
fset fp 1.0

fset HFin 0.034        ;# Scaled for 32nm CMOS 
fset STI_depth 0.15  
fset Tsub 1.0
fset SiliconAngle 88
 
## Fin Width
fset Wfin @<0.017+Delta_W>@       
fset Tpoly 0.08
fset Lg    @<0.025+Delta_Lg>@      
fset gox   @tox@
fset THK   @thk@
fset MetalG   0.004 
fset CapOx 0.005  

fset PolyReox 0.002    
fset Lsp  0.002      
fset Lspepi 0.0125

#rem #---------------------------------------------------------------------#
#rem #   LAYOUT
#rem #---------------------------------------------------------------------#

icwb filename= "FinSRAM_lyt.mac" scale= 1e-3
#rem # Loading of the "TCAD Layout" file.


#rem # Selecting the simulation domain.
icwb domain= @Domain@ 
icwb stretch name= GateWidth value=@Delta_Lg@
icwb stretch name= NFinWidth value=@Delta_W@
icwb stretch name= PFinWidth value=@Delta_W@
set DIM [icwb dimension]
#rem # Query utility: Returns the dimension of the selected simulation domain.
LogFile "icwb: dimension -> $DIM"

#rem # Query utility: Returns the bounding box of the simulation
set Ymin [icwb bbox left ]
set Ymax [expr [icwb bbox right] /2]
set Zmin [icwb bbox back ]
set Zmax [expr [icwb bbox front] /2]

#endheader
puts "YZ domain: $Ymin $Zmin $Ymax $Zmax"

# -------------------------------------------------------
# initial grid and structure initialization
# -------------------------------------------------------
# keep user-defined lines
pdbSetBoolean Grid MGoals UseLines 1

line x location= 0.0 tag= top
line x location= 0.1 
line x location= $Tsub tag= bottom

line z location= $Zmin tag= back
line z location= [expr $Wfin/2.0]
line z location= $Zmax tag= front

line y location= $Ymin spa= 0.02 tag= left
line y location= [expr $Lg/2.0]
line y location= $Ymax spa= 0.02 tag= right

region silicon substrate xlo= top xhi= bottom ylo= left yhi= right zlo= back zhi= front

#if "@channel@"=="100"
init field= Boron concentration= 1.0e15 wafer.orient= {0 0 1} flat.orient= {0 1 0} slice.angle= -90
#else
init field= Boron concentration= 1.0e15 wafer.orient= {0 0 1} flat.orient= {-1 1 0} slice.angle= -90
#endif

# -------------------------------------------------------
# pdb settings
# -------------------------------------------------------

AdvancedCalibration

# turn off SDE integrated approach and use MGOALS3D
sde off

# turn off stress relaxation after depo/etch
pdbSet Mechanics EtchDepoRelax 1

# preserve the brep representation
pdbSet Grid MGoals Keep3DBrep 1

# meshing strategy
mgoals on min.normal.size= 0.005/$fp normal.growth.ratio= 2 resolution= 0.3 accuracy= 1e-6 max.box.angle= 165
refinebox interface.materials= {Silicon }

icwb.refine.mask name= Total layer.name= "FIN" oversize= 0.75 xtop= 0.0 xbot= $Tsub \
 xrefine= " 0.5/$fp "  yrefine= " $Wfin/(2.0*$fp) " zrefine= " $Lg/(2.0*$fp) "  all add
 
icwb.refine.mask name= FinSurf layer.name= "FIN" oversize= 0.75 xtop= -0.01 xbot= $STI_depth \
 min.normal.size= 0.001 normal.growth.ratio= 2.0 interface.mat.pairs= {Silicon Oxide} all add
 
# ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
# process flow begins
# ----------------------------------------------------------------------------------------------------------------------------------------------------------------------

# Hard mask nitride
deposit material= {Oxide}   type= anisotropic  rate= {1.0} time= 0.01
deposit material= {Nitride} type= anisotropic  rate= {1.0} time= 0.1

# Fin mask
icwb.create.mask layer.name= "FIN" name= FIN info= 1 polarity= negative 
photo mask= FIN thickness= 0.02
etch material= {Nitride} type= anisotropic rate= {0.1} time= 1.1
if { $debug } { struct tdr.bnd= n@node@_01 }

strip Photoresist
etch material= {Oxide} type= anisotropic rate= {0.01} time= 1.1
etch material= {Silicon} type= trapezoidal rate= $STI_depth time= 1.0 angle= $SiliconAngle undercut= 0
strip Nitride
strip Oxide
if { $debug } { struct tdr.bnd= n@node@_02 }

etch    material= {Silicon} type= isotropic rate= {0.002} time= 1.0
deposit material= {Silicon} type= isotropic rate= {0.002} time= 1.0 selective.materials= {Silicon}
if { $debug } { struct tdr.bnd= n@node@_03 }

deposit oxide fill coord= -0.005
etch oxide thickness= [expr $HFin+0.005] anisotropic
if { $debug } { struct tdr.bnd= n@node@_04 }

# Cap oxide and fill
deposit material= {Oxide} type= isotropic  rate= $CapOx time= 1.0
if { $debug } { struct tdr.bnd= n@node@_05 }

stressdata Oxide sxxi= -5e8<Pa> syyi= -5e8<Pa> szzi= -5e8<Pa>
diffuse stress.relax time= 1e-10 temp= 600

# --------------------------------------------------------------
# WELL/Vt implant
# --------------------------------------------------------------

icwb.refine.mask name= Vt layer.name= "FIN" oversize= 0.004 xtop= 0.0 xbot= [expr 2*$HFin ] \
 xrefine= " 0.005/$fp "  yrefine= " $FinPitch/(8.0*$fp) " zrefine= " $PolyPitch*@<(Delta_Lg+0.13)/0.13>@/(6.0*$fp) "  all add

refinebox remesh

icwb.create.mask layer.name= "NWELL" name= PWELL info= 1 polarity= negative 
photo mask= PWELL thickness= 1.0

implant Boron dose= @VtDose@ energy= 180 tilt= 0.0
implant Boron dose= @VtDose@ energy= 60  tilt= 0.0
implant Boron dose= @VtDose@ energy= 15  tilt= 0.0

if { $debug } { struct tdr.bnd= n@node@_06 }
strip Photoresist

icwb.create.mask layer.name= "NWELL" name= NWELL info= 1 polarity= positive 
photo mask= NWELL thickness= 1.5

implant Phosphorus dose= 1.0e13 energy= 120 tilt= 0.0
implant Phosphorus dose= 5.0e12 energy= 70  tilt= 0.0
implant Arsenic    dose= 1.5e12 energy= 30  tilt= 0.0

if { $debug } { struct tdr.bnd= n@node@_07 }
strip Photoresist

# Well RTA

temp_ramp name= well temperature= 600<C>  time= 0.067      t.final= 900
temp_ramp name= well temperature= 900<C>  time= 0.033<min> t.final= 1050
temp_ramp name= well temperature= 1050<C> time= 0.2<min>   t.final= 750
temp_ramp name= well temperature= 750<C>  time= 0.1<min>   t.final= 600
diffuse stress.relax temp.ramp= well

etch material= {Oxide} type= cmp coord= $HFin  
if { $debug } { struct tdr.bnd= n@node@_08 }

#split @Poly@

# gate stack
deposit material= {Oxide} type= isotropic rate= {1.0} time= $gox
deposit material= {HfO2} type= isotropic  rate= $THK time= 1.0
if { $debug } { struct tdr.bnd= n@node@_09 }

# MetalGate
mater add name= TiN new.like= Nitride
pdbSetDouble TiN Mechanics BulkModulus  [ Enu2K 600e10 0.25 ]
pdbSetDouble TiN Mechanics ShearModulus [ Enu2G 600e10 0.25 ]
pdbSetDouble TiN Mechanics ThExpCoeff   9.4e-6
deposit material= {TiN}  type= isotropic  rate= $MetalG  time= 1.0

# Poly etching (gate mask)
icwb.create.mask layer.name= "GATE" name= POLY info= 1  polarity= negative 
deposit material= {PolySilicon} type= anisotropic  thickness= $Tpoly+$gox+$HFin mask= POLY
etch    material= {PolySilicon} type= cmp coord= -$Tpoly-$gox
if { $debug } { struct tdr.bnd= n@node@_10 }

strip Photoresist

set Gstack [expr $gox+$HFin]
etch material= {TiN HfO2 Oxide} type= anisotropic rate= {$Gstack $Gstack $Gstack} time= 2.0
deposit oxide fill coord= $HFin
if { $debug } { struct tdr.bnd= n@node@_011 }

# Offset spacer
deposit material= {Oxide} type= isotropic  rate= {1.0} time= $PolyReox
if { $debug } { struct tdr.bnd= n@node@_014 }

deposit material= {Nitride} type= isotropic  rate= {$Lsp} time= 1.0
if { $debug } { struct tdr.bnd= n@node@_015 }

etch nitride thickness= [expr $PolyReox+$Lsp+0.004] type= directional direction= { 1 1 0 }
if { $debug } { struct tdr.bnd= n@node@_016 }

icwb.refine.mask name= HALO layer.name= "FIN" oversize= 0.005 xtop= -$gox-$THK xbot=1.5*$HFin \
 xrefine= " 0.002/$fp 0.005/$fp " yrefine= " $FinPitch/(10.0*$fp) "  zrefine= " $PolyPitch*@<(Delta_Lg+0.13)/0.13>@/(20.0*$fp) " all add

icwb.refine.mask name= YEXT layer.name= "GATE" \
 oversize= 0.008 xtop= 0.0 xbot=$HFin \
 xrefine= " 0.001/$fp "  yrefine= " $FinPitch/(20.0*$fp) " zrefine= " $PolyPitch*@<(Delta_Lg+0.13)/0.13>@/(40.0*$fp) " Silicon add

icwb.refine.mask name= EXT_IF layer.name= "FIN" \
 oversize= 0.001 xtop= -$gox xbot= $HFin min.normal.size= 0.0005/$fp normal.growth.ratio= 2.0 \
 interface.mat.pairs= {Silicon Oxide} Silicon add

refinebox remesh

#split @Ext@

#-- SiC Material prop to activate Molefraction Dependent stress ---#
pdbSetBoolean Si IsCompound 1
pdbSetString Mechanics BCompoundList {Silicon Carbon}
pdbSetDoubleArray Silicon Carbon Conc.Strain {0 0 1 -0.432}
pdbSetDoubleArray SiliconCarbon CompoundInterp {0 0 1 1}
pdbSetDouble Silicon Mechanics TopRelaxedNodeCoord 0.05e-4

# ------------ Halo implantation
icwb.create.mask layer.name= "NWELL" name= PWELL info= 1 polarity= negative 
photo mask= PWELL thickness= 1.0
if { $debug } { struct tdr.bnd= n@node@_Ext1 }

implant Boron dose= @HaloDose@ energy= @HaloEnergy@ tilt= 30 rotation= 120 
implant Boron dose= @HaloDose@ energy= @HaloEnergy@ tilt= 30 rotation= 240 
implant Boron dose= @HaloDose@ energy= @HaloEnergy@ tilt= 30 rotation= 300 
implant Boron dose= @HaloDose@ energy= @HaloEnergy@ tilt= 30 rotation= 60  

## ---------- S/D Extension implantation nFinFET -----------------------
implant Carbon  dose= 1.0e15 energy= 2.5  tilt= 45 rotation= -90.0 !pai

implant Arsenic dose= 2.5e+15 energy= 4.0 tilt= 45 rotation= 90.0
implant Arsenic dose= 2.5e+15 energy= 4.0 tilt= 45 rotation= 270.0
        
strip Photoresist

icwb.create.mask layer.name= "NWELL" name= NWELL info= 1 polarity= positive 
photo mask= NWELL thickness= 1.5

if { $debug } { struct tdr.bnd= n@node@_Ext2 }

implant Arsenic dose= 8.5e12 energy= 25 tilt= 30 rotation= 120    
implant Arsenic dose= 8.5e12 energy= 25 tilt= 30 rotation= 240 
implant Arsenic dose= 8.5e12 energy= 25 tilt= 30 rotation= 300 
implant Arsenic dose= 8.5e12 energy= 25 tilt= 30 rotation= 60

implant Phosphorus dose= 8.0e12 energy= 40 tilt= 30 rotation= 120
implant Phosphorus dose= 8.0e12 energy= 40 tilt= 30 rotation= 240
implant Phosphorus dose= 8.0e12 energy= 40 tilt= 30 rotation= 300
implant Phosphorus dose= 8.0e12 energy= 40 tilt= 30 rotation= 60

## ---------- S/D Extension implantation pFinFET -----------------------
implant BF2  dose= 6.5e15 energy= 2.0 tilt= 45 rotation= 90.0
implant BF2  dose= 6.5e15 energy= 2.0 tilt= 45 rotation= 270.0

strip Photoresist

struct tdr= n@node@_ext_impl

diffuse temperature= 750<C> time= 1.0<min>

#split @SD@

etch oxide thickness= $PolyReox*1.8 type= directional direction= { 1 1 0 }
etch material= {Oxide} type= cmp coord= -0.075
etch material= {Nitride} type= cmp coord= -0.075
deposit oxide fill coord= $HFin

if { $debug } { struct tdr.bnd= n@node@_Epi1 }

# Spacer for epi
deposit material= {Nitride} type= isotropic rate= {$Lspepi} time= 1.0
etch Nitride thickness= 1.8*$Lspepi type= directional direction= { 1 1 0 }
if { $debug } { struct tdr.bnd= n@node@_Epi2 }

# Diamond shaped Si Epitaxy  
mater add name= SiGePocket new.like= Silicon alt.matername= SiliconGermanium
pdbSet SiGePocket SiliconGermanium.ConversionConc 1e21
mater add name= SMTPocket  new.like= Silicon alt.matername= Silicon

# Height and Dimension of The Epi pocket
set heigth  [expr 1.2*$HFin]
set width   [expr 1.2*$FinPitch]
set length  [expr $PolyPitch-$Lg-2.0*($PolyReox+$Lsp)]
set xcenter [expr $HFin/2.0]

#if @[ string match @Domain@ "TN" ]@

HexaPrism SMT_n $heigth $xcenter $Zmin  $Ymax 40.0 $length $width
polyhedron list
insert polyhedron= SMT_n replace.materials= { Gas } new.material= SMTPocket new.region= SMTPocket_1
if { $debug } { struct tdr.bnd= n@node@_Epi3 }

#elif @[ string match @Domain@ "TP" ]@

# Following steps need to modify during Full3D simulation
etch   material= {Silicon} type= anisotropic rate= {0.003} time= 1.0
etch   material= {Silicon} type= isotropic rate= {0.001} time= 1.0
deposit material= {Oxide} type= fill coord= $HFin

HexaPrism SiGe_p $heigth $xcenter $Zmin $Ymax 40.0 $length $width 
polyhedron list
insert polyhedron= SiGe_p replace.materials= { Gas } new.material= SiGePocket new.region= SiGePocket_1
if { $debug } { struct tdr.bnd= n@node@_Epi4 }
#endif

grid remesh

#############################################
# Problem with interpolation from Si
ChangeMaterialMatchRegions SMTPocket Oxynitride  zerodata
ChangeMaterialMatchRegions SMTPocket SMTPocket   zerodata
ChangeMaterialMatchRegions SiGePocket Oxynitride zerodata
ChangeMaterialMatchRegions SiGePocket SiGePocket zerodata

sel z= 1.5e22 name= Germanium SiGePocket store
sel z= 1.5e20 name= Boron     SiGePocket store
sel z= 1.5e20 name= Arsenic   SMTPocket  store
sel z= 1.5e21 name= Carbon    SMTPocket  store

diffuse stress.relax time= 1e-10 temp= 600

## To merge the SMTpocket with substrate and Reset the doping in Si-like materials
ChangeMaterialMatchRegions SMTPocket Silicon Nozerodata

# ----------------------------------------------------------------
#   SD implantation
#----------------------------------------------------------------

icwb.create.mask layer.name= "NWELL" name= PWELL info= 1 polarity= negative 
photo mask= PWELL thickness= 1.0

implant Arsenic dose= 5.0e+15 energy= 12.0 tilt= 0 rotation= 90 

if { $debug } { struct tdr.bnd= n@node@_SD1 }
strip Photoresist

icwb.create.mask layer.name= "NWELL" name= NWELL info= 1 polarity= positive 
photo mask= NWELL thickness= 1.5

implant BF2 dose= 5.0e15 energy= 12.0 tilt= 0 rotation= 90

if { $debug } { struct tdr.bnd= n@node@_SD2 }
strip Photoresist

# ---- laser annealing ----
temp_ramp name= laser  time= 1e-03<s> ramprate= 5e+05<C/s>  temperature= 600.0
temp_ramp name= laser  time= 1e-03<s> ramprate= -5e+04<C/s> temperature= 1100.0

diffuse temp.ramp= laser stress.relax

struct tdr= n@node@_sd

## ---------- Contact silicidation -----------------------

diffuse stress.relax time= 1e-10 temp= 400

etch material= {Silicon}  type= isotropic rate= 0.06*$HFin time= 1.2
etch material= {SiGePocket} type= isotropic rate= 0.06*$HFin time= 1.2
if { $debug } { struct tdr.bnd= n@node@_C1 }

deposit material= {NickelSilicide} type= isotropic rate= 0.1*$HFin time= 1.0 selective.materials= {SMTPocket SiGePocket Silicon}
if { $debug } { struct tdr.bnd= n@node@_C2 }

diffuse stress.relax time= 1<min>  temperature= 400  ramprate= [ expr 20.0 - 400.0 ]<K/min>

#split @DeviceMesh@

fset fd 1.0 

#Remove Poly and metal gate
strip PolySilicon
strip TiNitride

#Polishing
etch material= {Nitride} type= cmp coord= -$gox-$THK-$MetalG
etch material= {Oxide} type= cmp coord= -$gox-$THK-$MetalG


#STI Oxide

mater add name = STIOxide new.like = Oxide

polygon name= STI_2D min= { $Ymin $Zmin } max= { $Ymax $Zmax} rectangle
polyhedron name= STI_3D polygons= STI_2D min=0.033 max= 0.2
insert polyhedron = STI_3D replace.materials= { Oxide } new.material = "Gas"

if { $debug } { struct bndfile= n@node@_STIOX_1 }

insert polyhedron = STI_3D replace.materials= { "Gas" } new.material = "STIOxide"

if { $debug } { struct bndfile= n@node@_STIOX_2 }



##---------------Remeshing for device simulation--------##
# clear the process simulation mesh
refinebox clear
refinebox !keep.lines
refinebox clear.interface.mats
line clear
line x loc=@ZCut@

# reset default settings for adaptive meshing
pdbSet Grid AdaptiveField Refine.Abs.Error     1e37
pdbSet Grid AdaptiveField Refine.Rel.Error     1e10
pdbSet Grid AdaptiveField Refine.Target.Length 100.0

# Set high quality delaunay meshes
pdbSet Grid sMesh 1
pdbSet Grid Adaptive 1
pdbSet Grid SnMesh DelaunayType boxmethod
pdbSet Grid SnMesh CoplanarityAngle 179
pdbSet Grid SnMesh MaxPoints 5000000
pdbSet Grid SnMesh MaxNeighborRatio 1e6
pdbSet Grid SnMesh SliverAngle 170



# Set the interface spacing
mgoals min.normal.size= 1.0 normal.growth.ratio= 2.0 max.box.angle= 179
# Which interfaces are to have interface meshes
# refinebox interface.materials= {Silicon SiGePocket} interface.mat.pairs = {Silicon SiGePocket SiGePocket Nitride}
# Refinement strategy


refinebox min.normal.size= 0.001 normal.growth.ratio= 2.0 \
interface.mat.pairs= { STIOxide Silicon }

icwb.refine.mask name= Device_FINS layer.name= FIN \
 oversize= 0.01 xtop= -$Tpoly xbot= $STI_depth \
 xrefine= " 0.03/$fd "  yrefine= $FinPitch/(2.0*$fd)  zrefine= " $PolyPitch*@<(Delta_Lg+0.13)/0.13>@/(2*$fd) " all add

icwb.refine.mask name= Device_FINS layer.name= FIN \
 oversize= 0.015 xtop= -$MetalG-$THK-$gox xbot= $HFin+0.01 \
 refine.fields= { NetActive} def.max.asinhdiff= 0.5 \
 refine.max.edge= " 0.01  0.01   0.01" \
 refine.min.edge= " 0.002 0.001  0.002" adaptive all

icwb.refine.mask name= Device_GATES layer.name= GATE \
 oversize= 0.0075 xtop= -$gox xbot= $HFin+0.01 \
 xrefine= " 0.004/$fd "  yrefine= " $FinPitch/(10.0*$fd) " zrefine= " $PolyPitch*@<(Delta_Lg+0.13)/0.13>@/(40.0*$fd) " materials= {Silicon SiGePocket} add

#icwb.refine.mask name= Device_IF layer.name= GATE \
# oversize= 0.01 xtop= -$MetalG-$THK-$gox xbot= $HFin+0.01  \
# min.normal.size= 0.0002/$fd normal.growth.ratio= 1.1 \
# interface.mat.pairs= {Silicon Oxide} Silicon

icwb.refine.mask name= Device_IF layer.name= GATE \
 oversize= 0.01 xtop= 0 xbot= 1  \
 min.normal.size= 0.0002/$fd normal.growth.ratio= 1.1 \
 interface.mat.pairs= {Silicon Oxide} Silicon

ChangeMaterialMatchRegions SiGePocket Silicon Nozerodata
 
 
refinebox remesh info= 2


transform reflect front
transform reflect right


## --------------- Extract channel stress

#x, y, z referes to the coordinate in 2D simulation

#set Sxx_Pa 0.0
#set Syy_Pa 0.0
#set Szz_Pa 0.0

set FinMin [lindex [lindex [icwb list polygon.bounding.boxes layer.name=FIN] 0] 0]
set FinMax [lindex [lindex [icwb list polygon.bounding.boxes layer.name=FIN] 0] 2]
set GateMin [lindex [lindex [icwb list polygon.bounding.boxes layer.name=GATE] 0] 1]
set GateMax [lindex [lindex [icwb list polygon.bounding.boxes layer.name=GATE] 0] 3]

#if @[ string match @Domain@ "TN" ]@
puts "DOE: HalfFin [expr ($FinMax-$FinMin)/2+@ZCut@/tan(3.14*$SiliconAngle/180)]"

#elif @[ string match @Domain@ "TP" ]@
puts "DOE: HalfFin [expr ($FinMax-$FinMin-0.002)/2+@ZCut@/tan(3.14*$SiliconAngle/180)]"

#endif

select z = " ( z > $GateMin && z < $GateMax && x > @<ZCut-0.001>@ && x < @<ZCut+0.001>@ && y > $FinMin && y < $FinMax) ? 1.0 : 0.0 " name = One Silicon store
set volume [lindex [integrate name=One Silicon ] 0]

select z = " ( z > $GateMin && z < $GateMax && x > @<ZCut-0.001>@ && x < @<ZCut+0.001>@ && y > $FinMin && y < $FinMax)? StressKK_x / $volume / 10.0 : 0.0 " name = StressXXtmp Silicon store
select z = " ( z > $GateMin && z < $GateMax && x > @<ZCut-0.001>@ && x < @<ZCut+0.001>@ && y > $FinMin && y < $FinMax)? StressKK_y / $volume / 10.0 : 0.0 " name = StressYYtmp Silicon store
select z = " ( z > $GateMin && z < $GateMax && x > @<ZCut-0.001>@ && x < @<ZCut+0.001>@ && y > $FinMin && y < $FinMax)? StressKK_z / $volume / 10.0 : 0.0 " name = StressZZtmp Silicon store

set intXX [lindex [integrate name=StressZZtmp Silicon ] 0]
set intYY [lindex [integrate name=StressYYtmp Silicon ] 0]
set intZZ [lindex [integrate name=StressXXtmp Silicon ] 0]

puts  "XX-component of stress tensor  = [format %.2e $intXX]"
LogFile "DOE: Sxx_Pa [format %.2e $intXX]"
puts  "YY-component of stress tensor  = [format %.2e $intYY]"
LogFile "DOE: Syy_Pa [format %.2e $intYY]"
puts  "ZZ-component of stress tensor  = [format %.2e $intZZ]"
LogFile "DOE: Szz_Pa [format %.2e $intZZ]"


#-Contacts
icwb.contact.mask layer.name= "GATE"  name= "gate" box HfO2 xlo= -$gox-$THK-$MetalG xhi= $HFin+0.001 adjacent.material= Gas
contact name= "source" x= -0.1*$HFin y= $Ymax+0.001 z= 0.002 point NickelSilicide replace
contact name= "source" x= -0.1*$HFin y= $Ymax-0.001 z= 0.002 point NickelSilicide add
contact name= "drain" x= -0.1*$HFin  y= $Ymax+0.001 z= $Zmax*2-0.002 point NickelSilicide replace
contact name= "drain" x= -0.1*$HFin y= $Ymax-0.001 z= $Zmax*2-0.002 point NickelSilicide add
contact bottom name= substrate Silicon


puts "DOE: YMax $Ymax"
puts "DOE: XMax $Zmax"

math coord.dfise
struct smesh= n@node@ mshcmd
# if { [catch { exec tdx -mtt -Y -ren source=drain n@node@_fps.tdr n@node@_3Dfull_fps.tdr} Err] !=0 } { 
#    LogFile $Err
# } 
 
exit
