#setdep @previous@

#if @[string match @Domain@ "TN"]@
#-- NMOS Specification
#define _Vg_    @Vg@	
#define _Vd_  @Vd@
#define _QC_
#define _CAR_    Electron
#elif @[string match @Domain@ "TP"]@
#-- PMOS Specification
#define _Vg_    @Vg@	
#define _Vd_  @Vd@
#define _QC_
#define _CAR_    Hole

#endif

File {
  Grid      = "n@node|Slice_2D@_msh.tdr"
  Parameter = "@parameter@"
  Plot      = "@tdrdat@"
  Current   = "@plot@"
  Output    = "@log@"

}


Electrode {
  
#if @[string match @Domain@ "TN"]@
  { Name= "gate"      Voltage= 0.0 workfunction= @<4.2+VTS-VTS_DD>@ }

#elif @[string match @Domain@ "TP"]@
  { Name= "gate"      Voltage= 0.0 workfunction= @<4.9+VTS-VTS_DD>@ }
  
#endif
  { Name= "source"    Voltage= 0.0 }
  { Name= "drain"     Voltage= 0.0 }
}

Physics{
#include "DD_Physics_des.cmd"
}

Physics (material= "Silicon") {
	_QC_
}

Plot{
  NonLocal
  eDensity hDensity
  TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
  eMobility hMobility
  eVelocity hVelocity
  eQuasiFermi hQuasiFermi
  eTemperature Temperature * hTemperature
  ElectricField/Vector Potential SpaceCharge
  Doping DonorConcentration AcceptorConcentration
  SRH Band2Band * Auger
  AvalancheGeneration eAvalancheGeneration hAvalancheGeneration
  eGradQuasiFermi/Vector hGradQuasiFermi/Vector
  eEparallel hEparallel eENormal hENormal
  BandGap 
  BandGapNarrowing
  Affinity
  ConductionBand ValenceBand
  eBarrierTunneling hBarrierTunneling * BarrierTunneling
  eTrappedCharge  hTrappedCharge
  eGapStatesRecombination hGapStatesRecombination
  eDirectTunnel hDirectTunnel
  Stress/Tensor
}

Math {
  Extrapolate
  Digits= 5
  RHSmin= 1e-10
  Notdamped= 50
  Iterations= 20
  ExitOnFailure
}

Solve {
NewCurrentPrefix="init_"
	Coupled ( Iterations= 100 LineSearchDamping= 1e-8 ){ Poisson _QC_}
	Plot(FilePrefix="n@node@_ini")


#-- Ramp drain to Vd
  Quasistationary( 
    InitialStep= 1e-3 Increment= 1.5 
    MinStep= 1e-6 MaxStep= 0.1
    
    Goal { Name= "drain"  Voltage= _Vd_ }

  ){ Coupled { Poisson _CAR_ _QC_} }
    Save ( FilePrefix= "n@node@_Vd" )
NewCurrentPrefix=""
    Quasistationary( 
    DoZero 
    InitialStep= 1e-2 Increment= 1.45 
    MinStep= 1e-6 MaxStep= 0.1
    Goal { Name= "gate" Voltage= _Vg_ }

  ){ Coupled { Poisson _CAR_ _QC_} }

  Save(FilePrefix="n@node@")
}

