#setdep @node|DD_for_MC@

#if @[string match @Domain@ "TN"]@
#-- NMOS Specification
#define _CAR_    Electron

#elif @[string match @Domain@ "TP"]@
#-- PMOS Specification
#define _CAR_    Hole

#endif


electrode {
            { name="source" voltage=0.0 }
            { name="drain"  voltage=@Vd@ }

#if @[string match @Domain@ "TN"]@
  { Name= "gate"      Voltage= @Vg@ workfunction= @<4.2+VTS-VTS_DD>@ }

#elif @[string match @Domain@ "TP"]@
  { Name= "gate"      Voltage= @Vg@ workfunction= @<4.9+VTS-VTS_DD>@ }
  
#endif 
          }
File {
  Grid      = "n@node|Slice_2D@_msh.tdr"
  Output=   "@log@"
  Parameter="@parameter@" 
  Load=  "n@node|DD_for_MC@_des.sav"
  MonteCarloOut = "n@node@_mc"
  Plot= "@tdrdat@"
     }

plot {
        MCField/Vector
        hMCDensity
        hMCEnergy
        hMCVelocity/Vector
        hMCCurrent/Vector
        eMCDensity
        eMCEnergy
        eMCVelocity/Vector
        eMCCurrent/Vector
     }
MonteCarlo {
#if "@Strain@" == "Yes"
  MCStrain = (@Exx@,@Eyy@,@Ezz@,@Eyz@,@Exz@,@Exy@)
#endif
#if "@channel@"=="100"
  Normal2OxideDirection = (0:0:1)
  ChannelDirection = (1:0:0)

#else
  Normal2OxideDirection = (-1:1:0)
  ChannelDirection = (1:1:0)
#endif

  SurfScattRatio = 0.85
  CurrentErrorBar = 2.5
  MinCurrentComput = 5
  DrainContact = "drain" # No. of Drain contact in .tdr (count from 0, view with TDX)
  SelfConsistent(FrozenQF)
  Window = Rectangle[ (-@XMax@, -@YMax@)
                      (@XMax@, @YMax@) ]

  FinalTime = @<(16.0e-6*0.025/0.2)/100*60>@
  Plot { Range=(0,@<(16.0e-6*0.025/0.1)*3>@) intervals = 100 }
}

Physics {  
#include "DD_Physics_des.cmd"

}



Math {
   ExitOnFailure
   Method=blocked
   Digits=6
   Extrapolate
   Iterations=20
   Notdamped=50
   CurrentWeighting
   NumberOfSolverThreads= @Threads@
}

solve {
         coupled {poisson _CAR_ }
         montecarlo
}

