##setdep @previous@

#set Vtgm   x
#set VtiLin x
#set IdLin  x
#set SSlin  x
#set gmLin  x
#set IdSat  x
#set Ioff   x
#set VtiSat x
#set SSSat  x
#set gmSat  x

set N     @node@
set i     @node:index@

set Lg    0.025
set Wfin  [expr (0.017/2.0)]
set Hfin  0.04
set Weff  [expr ($Hfin+$Wfin)]
set Vd    1.0
set Vg    @Vgg@

if { [string match @Domain@ "TN"] } {
  set Type nMOS
} else {
  set Type pMOS
}

puts "Gate Length: $Lg um"

set ID "$Type"
set N   ${Type}_${N}


#----------------------------------------------------------------------#
# Plotting Id vs Vg curves
gr_setTitleAttr "IdVg Lg=$Lg $ID"

proj_load  IdVg_VdLin_@plot@ PLTLin($N)

if { $Type == "nMOS" } { set SIGN 1.0 } else { set SIGN -1.0 }
cv_createDS IdVgLin($N) \
 "PLTLin($N) gate OuterVoltage" "PLTLin($N) drain TotalCurrent" y
cv_createWithFormula IdVgLinSc($N) "$SIGN*<IdVgLin($N)>/$Weff" A A A A
cv_abs IdVgLin($N) y
cv_setCurveAttr IdVgLin($N) "IdVgLin Vd=0.05" \
  blue solid 2 none 3 defcolor 1 defcolor


proj_load  IdVg_VdSat_@plot@ PLTSat($N)

if { $Type == "nMOS" } { set SIGN 1.0 } else { set SIGN -1.0 }
cv_createDS IdVgSat($N) \
 "PLTSat($N) gate OuterVoltage" "PLTSat($N) drain TotalCurrent" y
cv_createWithFormula IdVgSatSc($N) "$SIGN*<IdVgSat($N)>/$Weff" A A A A
cv_abs IdVgSat($N) y
cv_setCurveAttr IdVgSat($N) "IdVgSat Vd=1.0" \
  red solid 2 none 3 defcolor 1 defcolor

gr_setAxisAttr X  {Gate Voltage (V)}  12  {} {} black 1 10 0 5 0
gr_setAxisAttr Y  {Drain Current (A)} 12  {} {} black 1 10 0 5 1

#- Extraction
#----------------------------------------------------------------------#
load_library EXTRACT

#- Defining Normalized current level for Vti extraction
#----------------------------------------------------------------------#
set Io    [expr 1.0e-7*$Weff/$Lg] ; # [A]

if { $Type == "nMOS" } { set SIGN 1.0 } else { set SIGN -1.0 }


set Vtgm   [ExtractVtgmb Vtgm   IdVgLin($N) $Type]
set VtiLin [ExtractVti   VtiLin IdVgLin($N) $Io]
set IdLin  [ExtractMax   IdLin  IdVgLinSc($N)]
set SSlin  [ExtractSS    SSlin  IdVgLin($N) [expr $SIGN*1e-2]]
set gmLin  [ExtractGmb   gmLin  IdVgLin($N) $Type]

set VtiSat [ExtractVti   VtiSat IdVgSat($N) $Io]
set IdSat  [ExtractMax   IdSat  IdVgSatSc($N)]
set Ioff   [ExtractIoff  Ioff   IdVgSat($N) [expr $SIGN*1e-4]]
set SSSat  [ExtractSS    SSSat  IdVgSat($N) [expr $SIGN*1e-2]]
set gmSat  [ExtractGmb   gmSat  IdVgSat($N) $Type]

