#setdep @previous@
#set VTS 0
#set VTS_DD 0
#----------------------------------------------------------------------#

set plot @plot@

set out_file [file rootname $plot]
puts "out_file = $out_file"
proj_load "$plot"
puts "proj_load = $plot"

cv_createDS iv "$out_file gate OuterVoltage" "$out_file source TotalCurrent"

cv_createWithFormula absiv  "fabs(<iv>+1.e-32)"  	A A A A
cv_createWithFormula sqrtiv "sqrt(<absiv>)"     	A A A A
cv_createWithFormula ivlog "log(<absiv>)"     	A A A A

#if "@Domain@" == "TN"
set VTS [ cv_compute "vecvalx(<ivlog>, log(1e-5))" A A A A ]
#else
set VTS [ cv_compute "vecvalx(<ivlog>, log(1e-6))" A A A A ]

#endif

set VTS   [ format "%.3lg" [ expr $VTS   ] ]

puts  "S: Threshold   voltage VTS ( slope sqrt pentode )        = $VTS  Volts"

ft_scalar VTS      $VTS



