##setdep @previous@

#set Vtgm   x
#set VtiLin x
#set IdLin  x
#set SSlin  x
#set gmLin  x
#set IdSat  x
#set Ioff   x
#set VtiSat x
#set SSsat  x
#set gmSat  x

set N     @node@
set i     @node:index@
set Lg    30
set Wd    8
set Vd    1
set Vg    @Vgg@
set Type nMOS
set SIGN 1.0


puts "Gate Length: $Lg nm"

set ID nMOS
set N   nMOS_${N}


#- INSPECT IdVg plotting
#----------------------------------------------------------------------#
# Plotting Id vs Vg curves
gr_setTitleAttr "IdVg Lg=$Lg $ID"

proj_load  IdVg_VdLin_@plot@ PLTLin($N)
proj_load  IdVg_VdSat_@plot@ PLTSat($N)

cv_create IdVgLinNC($N) \
 "PLTLin($N) gate OuterVoltage" "PLTLin($N) drain TotalCurrent" y
cv_createWithFormula IdVgLin($N) "$SIGN*<IdVgLinNC($N)>/$Wd" A A
cv_setCurveAttr IdVgLin($N) "IdVg Vd=0.05" \
  blue solid 2 none 3 defcolor 1 defcolor
cv_display IdVgLin($N)

cv_create IdVgSatNC($N) \
 "PLTSat($N) gate OuterVoltage" "PLTSat($N) drain TotalCurrent" y
cv_createWithFormula IdVgSat($N) "$SIGN*<IdVgSatNC($N)>/$Wd" A A
cv_setCurveAttr IdVgSat($N) "IdVg Vd=$Vg" \
  red solid 2 none 3 defcolor 1 defcolor
cv_display IdVgSat($N)

gr_setAxisAttr X  {Gate Voltage (V)}     12  {} {} black 1 10 0 5 0
gr_setAxisAttr Y  {Drain Current (A)} 12  {} {} black 1 10 0 5 1

#- Extraction
#----------------------------------------------------------------------#
load_library EXTRACT

#- Defining current level for Vti extraction
#----------------------------------------------------------------------#
set Io    [expr 0.1e-6/$Lg] ; # [A]

puts "Io= $Io"

set Vtgm   [ExtractVtgmb Vtgm   IdVgLin($N) nMOS]
set VtiLin [ExtractVti   VtiLin IdVgLin($N) $Io]
set IdLin  [ExtractMax   IdLin  IdVgLin($N)]
set SSlin  [ExtractSS    SSlin  IdVgLin($N) [expr $SIGN*1e-2]]
set gmLin  [ExtractGmb   gmLin  IdVgLin($N) nMOS]

set VtiSat [ExtractVti   "VtiSat" IdVgSat($N) $Io]
set IdSat  [ExtractMax   "IdSat"  IdVgSat($N)]
set Ioff   [ExtractIoff  "Ioff"   IdVgSat($N) [expr $SIGN*1e-2]]
set SSsat  [ExtractSS    "SSsat"  IdVgSat($N) [expr $SIGN*1e-2]]
set gmSat  [ExtractGmb   "gmSat"  IdVgSat($N) $Type]


