#setdep @node|sprocess@

#if @[string match @Domain@ "TN"]@
#-- NMOS Specification
#define _Vgg_    @Vgg@	
#define _VdLin_  0.05
#define _VdSat_  0.8
#define _QC_     eQuantumPotential
#define _CAR_    Electron
#elif @[string match @Domain@ "TP"]@
#-- PMOS Specification
#define _Vgg_    @Vgg@	
#define _VdLin_  -0.05
#define _VdSat_  -0.8
#define _QC_     hQuantumPotential
#define _CAR_    Hole

#endif

File {
  Grid      = "n@previous@_sano0_msh.tdr"
  Piezo     = "n@previous@_sano0_msh.tdr"
  Parameter = "@parameter@"
  Plot      = "@tdrdat@"
  Current   = "@plot@"
  Output    = "@log@"
}

Electrode {
  
#if @pSchottky@ == 1
  { Name="gate" Schottky Workfunction= 4.2
    Voltage= ( 0.0 at 0, 0.0 at @<DoseTime+10>@ , 0.1 at @<DoseTime+11>@, 0.2 at @<DoseTime+12>@, 0.3 at @<DoseTime+13>@ , 0.4 at @<DoseTime+14>@  , 
   0.5 at @<DoseTime+15>@ , 0.6 at @<DoseTime+16>@ , 0.7 at @<DoseTime+18>@ , 0.8 at @<DoseTime+20>@ ) }
#endif

  { Name="drain"   
  Voltage= ( @Vds@ at 0, 0.0 at @DoseTime@, 0.01 at @<DoseTime+2>@ , 0.02 at @<DoseTime+4>@ , 0.03 at @<DoseTime+6>@ , 0.04 at @<DoseTime+8>@ , 0.05 at @<DoseTime+10>@ ) }
  { Name= "source"    Voltage= 0.0 }
  { Name= "substrate" Voltage= 0.0 }
}

Physics (material= "STIOxide") {
    Radiation (
    	DoseTime=(10, @DoseTime@ )
    	DoseRate=@pDoseRate@
    )
    
    EffectiveIntrinsicDensity(NoBandGapNarrowing)
    Mobility(ConstantMobility)
    
    Traps (
    Level Donor Conc=@pTraps@ fromValBand EnergyMid=4.0 material="Oxide"    	    
    )
}

Physics (material= "Silicon") {
   _QC_
   
   #if @RadSil@ == 1
   	Radiation (
    		DoseTime=(10, @DoseTime@ )
    		DoseRate=@pDoseRate@
    	)
   #endif	
      
  Mobility(
    PhuMob
    HighFieldSaturation( GradQuasiFermi )
    Enormal ( Lombardi( AutoOrientation ) )
    )
  EffectiveIntrinsicDensity( OldSlotboom )
  Recombination(SRH(DopingDep))
  Piezo(
    Model(
      DeformationPotential
      Mobility(
         eSubBand(Doping)
         hTensor(Kanda)
      	      )
         )
       )
}

Physics(MaterialInterface="STIOxide/Silicon") { 
	Heterointerface 
	#if  @eTherm@ == 1  
		eThermionic
	#endif
	#if  @hTherm@ == 1 
		hThermionic
	#endif
}

CurrentPlot {

	eCurrentDensity (Average(MaterialInterface="STIOxide/Silicon"))
	hCurrentDensity (Average(MaterialInterface="STIOxide/Silicon"))
	TotalCurrentDensity (Average(MaterialInterface="STIOxide/Silicon"))
	RadiationGeneration (Average(Material="STIOxide"))

}

  
Plot{
  eDensity hDensity
  TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
  eMobility hMobility
  eVelocity hVelocity
  eQuasiFermi hQuasiFermi
  eTemperature Temperature * hTemperature
  ElectricField/Vector Potential SpaceCharge
  Doping DonorConcentration AcceptorConcentration
  SRH Band2Band * Auger
  AvalancheGeneration eAvalancheGeneration hAvalancheGeneration
  eGradQuasiFermi/Vector hGradQuasiFermi/Vector
  eEparallel hEparallel eENormal hENormal
  BandGap 
  BandGapNarrowing
  Affinity
  ConductionBand ValenceBand
  eBarrierTunneling hBarrierTunneling * BarrierTunneling
  eTrappedCharge  hTrappedCharge
  eGapStatesRecombination hGapStatesRecombination
  eDirectTunnel hDirectTunnel
  RadiationGeneration
}

Math {  
  CNormPrint
  Extrapolate
  Derivatives
  Avalderivatives
  RelErrControl
  Digits= 5
  RHSmin= 1e-10
  Notdamped= 50
  Iterations= 100
  ExitOnFailure
  ##method= ILS
  Number_Of_Threads=16
  }

Solve {
  Coupled ( Iterations= 100 LineSearchDamping= 1e-8 ){ Poisson } 
  Coupled ( Iterations= 100 LineSearchDamping= 1e-8 ){ Poisson _QC_} 
  Coupled { Poisson Electron Hole _QC_ }

  Save ( FilePrefix= "n@node@_init" )
  Plot ( FilePrefix= "n@node@_PEH" )
  
  Transient(
	InitialTime = 0 FinalTime=@DoseTime@
	MinStep = 1e-10 MaxStep = 500
   ){
   	*Coupled ( LineSearchDamping= 0.01 Iterations= 100  ){ Poisson } 
	Coupled { Poisson Electron Hole _QC_ }
	Plot ( FilePrefix="n@node@" Time=( 1; 5; 10; 12.59; 22.95; 35.9; 61.81; 87.72; 113.62; 139.53; 269.06; 528.13; 787.2; 1046.26; 1305.33; 2600.67; 5191.34; 7782.02; 10372.69; 12963; @DoseTime@ )  NoOverwrite )
	
   }
   
   Set (Traps(Frozen))
   
        NewCurrentPrefix= "IDVD_"
   
        Transient ( InitialTime= @DoseTime@ FinalTime= @<DoseTime+10>@ MaxStep= 0.1 MinStep= 1e-25 Increment= 2.0 )
		{ Coupled { Poisson Electron Hole _QC_ } } 

	NewCurrentPrefix= "IDVG_"

	Transient ( InitialTime= @<DoseTime+10>@ FinalTime= @<DoseTime+20>@ MaxStep= 0.1 MinStep= 1e-25 Increment= 2.0 )
		{ Coupled { Poisson Electron Hole _QC_ } }   
  
}



