set terminal pslatex 8
set xlabel 'SNR (dB)'
set ylabel 'SER' offset 5,0
set logscale y
set format y '$10^{%L}$'
set yrange[0.00001:1]
set output 'results_run.tex'
eta = 1
capacity = -10
ebstart = -0.5
ebend = 6
exist = system("[ -f eta.cfg ] && echo '1' || echo '0'") + 0
if (exist)  load 'eta.cfg' 
if (exist)  set xlabel '$E_\mathrm{b}/N_0$ (dB)'
set xrange[ebstart : ebend ]
if (exist)  set arrow from capacity,0.0002 to capacity,0.9 nohead
if (exist)  set label 2 "Capacity bound"   at capacity+0.08,0.0002 rotate left

set style line 1 lt 1 ps 1 pt 1 lc rgb 'black'
set style line 2 lt 1 ps 1 pt 1 lc rgb 'blue'
set style line 3 lt 1 ps 1 pt 1 lc rgb 'red'
set style line 4 lt 1 ps 1 pt 1 lc rgb 'green'
set style line 5 lt 1 ps 1 pt 1 lc rgb 'orange'
set style line 6 lt 1 ps 1 pt 1 lc rgb 'yellow'
set style line 7 lt 1 ps 1 pt 1 lc rgb 'purple'

set style line 11 lt 1 ps 1 pt 6 lc rgb 'black' 
set style line 12 lt 1 ps 1 pt 7 lc rgb 'black'

set style line 21 lt 1 ps 1 pt 4 lc rgb 'black'
set style line 22 lt 1 ps 1 pt 5 lc rgb 'black'

set style line 31 lt 2 ps 1 pt 1 lc rgb 'black'
set style line 41 lt 2 ps 1 pt 2 lc rgb 'black'
set style line 51 lt 2 ps 1 pt 3 lc rgb 'black'

set title 'SER UEC-URC implementated performance'

plot 'results_data.dat' using ($5-10*log10(eta)):($6==0) ? NaN : $6 with linespoints ls 11 title 'Proposed schedule, $\max$ SE', \
'results_data.dat' using ($3-10*log10(eta)):($4==0) ? NaN : $4 with linespoints ls 12 title 'Proposed schedule, $\max$', \
'results_data.dat' using ($1-10*log10(eta)):($2==0) ? NaN : $2 with linespoints ls 13 title 'Proposed schedule, $\max$*', \
'results_data.dat' using ($7-10*log10(eta)):($8==0) ? NaN : $8 with linespoints ls 16 title 'Proposed schedule, $\max$-SE, fixed-point