/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class Apply_Mask
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";

    public void run(String command) {
        if (IJ.versionLessThan((String)"1.48n")) {
            return;
        }
        IJ.showStatus((String)"Applying Mask...");
        int Nimg = WindowManager.getImageCount();
        if (Nimg < 2) {
            IJ.error((String)"At least two images are required - the original and the mask.");
            return;
        }
        String[] lstImages = WindowManager.getImageTitles();
        int[] lstImageIds = WindowManager.getIDList();
        String[] lstMasks = new String[Nimg];
        int Nmasks = Nimg;
        for (int i = 0; i < Nimg; ++i) {
            ImageProcessor temp = WindowManager.getImage((int)lstImageIds[i]).getProcessor();
            if (temp.getMin() == 0.0 && temp.getMax() == 1.0 || temp.isBinary()) {
                lstMasks[i] = lstImages[i];
                continue;
            }
            lstMasks[i] = "--not a mask--";
            --Nmasks;
        }
        if (Nmasks < 1) {
            IJ.error((String)"Could not find valid mask. (A mask needs to be binary, or only contain values between 0 and 1)");
            return;
        }
        GenericDialog gd = new GenericDialog(command + " Apply Mask");
        gd.addChoice("Image", lstImages, lstImages[0]);
        gd.addChoice("Mask", lstMasks, lstMasks[0]);
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int AM_srcID = lstImageIds[gd.getNextChoiceIndex()];
        int AM_maskID = lstImageIds[gd.getNextChoiceIndex()];
        ImagePlus image = WindowManager.getImage((int)AM_srcID);
        ImagePlus mask = WindowManager.getImage((int)AM_maskID);
        int tHeight = image.getHeight();
        int tWidth = image.getWidth();
        int tDepth = image.getNSlices();
        int tFrames = mask.getNFrames();
        int tChannels = mask.getNChannels();
        ImagePlus imgout = IJ.createHyperStack((String)"Result", (int)tWidth, (int)tHeight, (int)tChannels, (int)tDepth, (int)tFrames, (int)8);
        for (int z = 1; z <= tDepth; ++z) {
            ImageProcessor imageIP = image.getStack().getProcessor(z).convertToByte(true);
            for (int f = 1; f <= tFrames; ++f) {
                for (int c = 1; c <= tChannels; ++c) {
                    int index = mask.getStackIndex(c, z, f);
                    ImageProcessor maskIP = mask.getStack().getProcessor(index).convertToByte(true);
                    String label = mask.getStack().getShortSliceLabel(index);
                    ImageProcessor outputIP = imgout.getStack().getProcessor(index);
                    imgout.getStack().setSliceLabel(label, index);
                    byte[] mPixels = (byte[])maskIP.getPixels();
                    byte[] iPixels = (byte[])imageIP.getPixels();
                    byte[] oPixels = (byte[])outputIP.getPixels();
                    for (int y = 0; y < tHeight; ++y) {
                        int x = 0;
                        int p = x + y * tWidth;
                        while (x < tWidth) {
                            oPixels[p] = mPixels[p] == 0 ? (byte)0 : iPixels[p];
                            ++x;
                            ++p;
                        }
                    }
                }
            }
        }
        imgout.show();
        IJ.showStatus((String)"Mask Applied.");
    }
}

