/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import java.awt.Component;
import java.awt.Font;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import lj.LJPrefs;

public class Apply_Weka_Classifier
implements PlugIn,
ActionListener {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    public static final String PLUGIN_TWS = "2.3.0";
    public static String TWS_version = "v2.3.0";
    private static String LJ_srcDirectory = LJPrefs.LJ_inpDirectory;
    private static String LJ_clsDirectory = LJPrefs.LJ_clsDirectory;
    private static int AC_channel = 1;
    JButton clsfilebtn;
    JTextField clsdirtxt;
    JButton srcfilebtn;
    JTextField srcdirtxt;
    GenericDialog gd;

    public void run(String command) {
        if (IJ.versionLessThan((String)"1.49s")) {
            return;
        }
        IJ.showStatus((String)"Initializing...");
        IJ.showProgress((int)0, (int)100);
        String arguments = "";
        if (IJ.isMacro() && Macro.getOptions() != null && !Macro.getOptions().trim().isEmpty()) {
            arguments = Macro.getOptions().trim();
            IJ.log((String)arguments);
            IJ.log((String)"^- arguments\n");
            AC_channel = 6;
            LJ_srcDirectory = LJPrefs.retrieveOption(arguments, "filepath", LJ_srcDirectory);
            LJ_clsDirectory = LJPrefs.retrieveOption(arguments, "classifier", LJ_clsDirectory);
            AC_channel = LJPrefs.retrieveOption(arguments, "class", 1);
            IJ.log((String)("filepath: " + LJ_srcDirectory));
            IJ.log((String)("classifier: " + LJ_clsDirectory));
            IJ.log((String)("channel: " + AC_channel));
        } else {
            GenericDialog gd = new GenericDialog(command + " Apply Weka Classifier");
            Font gdFont = gd.getFont();
            JLabel srcdirlbl = new JLabel("Image Filepath  ", 4);
            srcdirlbl.setFont(gdFont);
            this.srcdirtxt = new JTextField(LJ_srcDirectory, 50);
            this.srcdirtxt.setFont(gdFont);
            this.srcfilebtn = new JButton("...");
            this.srcfilebtn.addActionListener(this);
            Panel srcpanel = new Panel();
            gd.setInsets(10, 10, 0);
            srcpanel.add((Component)srcdirlbl, -1);
            srcpanel.add((Component)this.srcdirtxt, -1);
            srcpanel.add((Component)this.srcfilebtn, -1);
            gd.addPanel(srcpanel);
            JLabel clsdirlbl = new JLabel("Classifier Directory  ", 4);
            clsdirlbl.setFont(gdFont);
            this.clsdirtxt = new JTextField(LJ_clsDirectory, 50);
            this.clsdirtxt.setFont(gdFont);
            this.clsfilebtn = new JButton("...");
            this.clsfilebtn.addActionListener(this);
            Panel clspanel = new Panel();
            clspanel.add((Component)clsdirlbl, -1);
            clspanel.add((Component)this.clsdirtxt, -1);
            clspanel.add((Component)this.clsfilebtn, -1);
            gd.addPanel(clspanel);
            gd.addNumericField("Class No", 1.0, 0);
            IJ.showStatus((String)"Waiting for user input...");
            if (IJ.getVersion().compareTo("1.42p") >= 0) {
                gd.addHelp(PLUGIN_HELP_URL);
            }
            gd.showDialog();
            if (gd.wasCanceled()) {
                IJ.showStatus((String)"Plug-In Aborted...");
                IJ.showProgress((int)100, (int)100);
                return;
            }
            IJ.showStatus((String)"Initializing...");
            LJ_srcDirectory = this.srcdirtxt.getText();
            LJ_clsDirectory = this.clsdirtxt.getText();
            AC_channel = (int)gd.getNextNumber();
            Recorder.recordOption((String)"filepath", (String)LJ_srcDirectory);
            Recorder.recordOption((String)"classifier", (String)LJ_clsDirectory);
            LJPrefs.LJ_srcDirectory = LJ_srcDirectory;
            LJPrefs.LJ_clsDirectory = LJ_clsDirectory;
            LJPrefs.savePreferences();
        }
        File file = new File(LJ_srcDirectory);
        String LJ_srcFile = file.getName();
        IJ.showStatus((String)"Opening Trainable Weka Segmentation...");
        IJ.runMacro((String)("open('" + LJ_srcDirectory.replace("\\", "\\\\") + "');"));
        IJ.run((String)"Trainable Weka Segmentation");
        IJ.runMacro((String)("close('" + LJ_srcFile + "');"));
        int Nimg = WindowManager.getImageCount();
        String[] lstImages = WindowManager.getImageTitles();
        String tempStr = "";
        for (int i = 0; i < Nimg; ++i) {
            if (!lstImages[i].startsWith("Trainable Weka Segmentation") || TWS_version.equals(tempStr = lstImages[i].replace("Trainable Weka Segmentation ", ""))) continue;
            IJ.log((String)("Newer version of the Trainable WEKA Segmentation found (found " + tempStr + ", expected " + TWS_version + "). There might be compatibility issues..."));
            TWS_version = tempStr;
        }
        IJ.showProgress((int)5, (int)100);
        IJ.showStatus((String)"Loading classifier...");
        IJ.runMacro((String)("selectWindow('Trainable Weka Segmentation " + TWS_version + "'); call('trainableSegmentation.Weka_Segmentation.loadClassifier', '" + LJ_clsDirectory.replace("\\", "\\\\") + "');"));
        if (WindowManager.getNonImageTitles().length <= 0) {
            IJ.log((String)Integer.toString(WindowManager.getNonImageTitles().length));
            IJ.log((String)"failed to initialize Trainable Weka Segmentation");
            IJ.showProgress((int)100, (int)100);
            return;
        }
        IJ.showProgress((int)20, (int)100);
        IJ.showStatus((String)"Getting Probability Map...");
        IJ.runMacro((String)"call('trainableSegmentation.Weka_Segmentation.getProbability');");
        IJ.showProgress((int)90, (int)100);
        IJ.showStatus((String)"Finishing...");
        IJ.runMacro((String)("selectWindow('Trainable Weka Segmentation " + TWS_version + "'); close(); selectWindow('Probability maps');"));
        ImagePlus image = WindowManager.getCurrentImage();
        int[] properties = image.getDimensions();
        int nSlices = properties[3];
        int nChannels = 2;
        AC_channel = AC_channel < 0 ? 0 : AC_channel;
        AC_channel = AC_channel > nChannels ? nChannels : AC_channel;
        IJ.run((String)"Slice Remover", (String)("first=" + AC_channel + " last=" + nSlices + " increment=" + nChannels));
        IJ.showStatus((String)"Probability map created.");
        IJ.showProgress((int)100, (int)100);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser;
        if (e.getSource() == this.clsfilebtn) {
            chooser = new JFileChooser(LJ_clsDirectory);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Classifier Model", "model");
            chooser.addChoosableFileFilter(filter);
            chooser.setFileSelectionMode(0);
            chooser.setSelectedFile(new File(this.clsdirtxt.getText()));
            int returnVal = chooser.showDialog((Component)this.gd, "Choose Classifier");
            if (returnVal == 0) {
                this.clsdirtxt.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        }
        if (e.getSource() == this.srcfilebtn) {
            chooser = new JFileChooser(LJ_srcDirectory);
            FileNameExtensionFilter tiffilter = new FileNameExtensionFilter("tif images (*.tif, *.tiff)", "tif", "tiff");
            FileNameExtensionFilter rawfilter = new FileNameExtensionFilter("raw data (*.raw)", "raw");
            chooser.addChoosableFileFilter(tiffilter);
            chooser.addChoosableFileFilter(rawfilter);
            chooser.setFileSelectionMode(0);
            chooser.setSelectedFile(new File(this.srcdirtxt.getText()));
            int returnVal = chooser.showDialog((Component)this.gd, "Choose Image");
            if (returnVal == 0) {
                this.srcdirtxt.setText(chooser.getSelectedFile().getPath());
            }
        }
    }
}

