/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.Plot;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.RoiManager;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import lj.LJPrefs;

public class Average_ROI_Colour
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static double plotYmax = 0.0;

    public void run(String arg) {
        RoiManager manager = RoiManager.getInstance();
        if (manager != null) {
            int[] table = manager.getIndexes();
            double[] mean = new double[]{0.0, 0.0, 0.0, 0.0};
            IJ.log((String)"manager not null");
            if (table != null) {
                IJ.log((String)"table not null");
                for (int label : table) {
                    int sn;
                    Roi roi = manager.getRoi(label);
                    ImagePlus img = roi.getImage();
                    if (img == null) {
                        img = WindowManager.getCurrentImage();
                    }
                    if ((sn = roi.getPosition()) != 0) {
                        img.setSlice(sn);
                    }
                    ImageProcessor ip = img.getProcessor();
                    if (roi != null && roi.getType() == 10) {
                        mean = this.updateMean(ip, (PointRoi)roi, mean);
                        continue;
                    }
                    if (roi != null && roi.getType() == 2) {
                        IJ.log((String)"Can't include polygon ROI in analysis!");
                        continue;
                    }
                    if (roi != null && roi.getType() == 0) {
                        mean = this.updateMean(ip, roi, mean);
                        continue;
                    }
                    if (roi == null) continue;
                    IJ.log((String)("Can't include unknown ROI type " + roi.getType() + " in analysis!"));
                }
                double[] std = new double[]{0.0, 0.0, 0.0};
                for (int label : table) {
                    int sn;
                    Roi roi = manager.getRoi(label);
                    ImagePlus img = roi.getImage();
                    if (img == null) {
                        img = WindowManager.getCurrentImage();
                    }
                    if ((sn = roi.getPosition()) != 0) {
                        img.setSlice(sn);
                    }
                    ImageProcessor ip = img.getProcessor();
                    if (roi != null && roi.getType() == 0) {
                        std = this.updateStd(ip, roi, std, mean);
                        continue;
                    }
                    if (roi == null || roi.getType() != 10) continue;
                    std = this.updateStd(ip, (PointRoi)roi, std, mean);
                }
                std[0] = Math.sqrt(std[0]);
                std[1] = Math.sqrt(std[1]);
                std[2] = Math.sqrt(std[2]);
                int n = (int)mean[0];
                int df = n - 1;
                double pG = 0.0;
                double pB = 0.0;
                double p1G = 0.0;
                double p1B = 0.0;
                double t = 0.5 * (double)n / std[0];
                double p = this.tToP(t, df);
                if (mean[2] != 0.0) {
                    double tG = 0.5 * (double)n / std[1];
                    pG = this.tToP(tG, df);
                    double tB = 0.5 * (double)n / std[2];
                    pB = this.tToP(tB, df);
                }
                double t1 = mean[1] * 0.01 * (double)n / std[0];
                double p1 = this.tToP(t1, df);
                if (mean[2] != 0.0) {
                    double t1G = mean[2] * 0.01 * (double)n / std[1];
                    p1G = this.tToP(t1G, df);
                    double t1B = mean[3] * 0.01 * (double)n / std[2];
                    p1B = this.tToP(t1B, df);
                }
                std[0] = std[0] / Math.sqrt(n);
                std[1] = std[1] / Math.sqrt(n);
                std[2] = std[2] / Math.sqrt(n);
                ResultsTable rt = Analyzer.getResultsTable();
                if (rt == null) {
                    rt = new ResultsTable();
                    Analyzer.setResultsTable((ResultsTable)rt);
                }
                if (mean[2] != 0.0) {
                    rt.incrementCounter();
                    rt.addLabel("points");
                    rt.addValue("value R", (double)n);
                    rt.addValue("value G", (double)n);
                    rt.addValue("value B", (double)n);
                    rt.addValue("unit", "pixel");
                    rt.incrementCounter();
                    rt.addLabel("mean");
                    rt.addValue("value R", mean[1]);
                    rt.addValue("value G", mean[2]);
                    rt.addValue("value B", mean[3]);
                    rt.addValue("unit", "");
                    rt.incrementCounter();
                    rt.addLabel("std");
                    rt.addValue("value R", std[0]);
                    rt.addValue("value G", std[1]);
                    rt.addValue("value B", std[2]);
                    rt.addValue("unit", "");
                    rt.incrementCounter();
                    rt.addLabel("+-0.5 reliability");
                    rt.addValue("value R", p * 100.0);
                    rt.addValue("value G", pG * 100.0);
                    rt.addValue("value B", pB * 100.0);
                    rt.addValue("unit", "%");
                    rt.incrementCounter();
                    rt.addLabel("+-1% reliability");
                    rt.addValue("value R", p1 * 100.0);
                    rt.addValue("value G", p1G * 100.0);
                    rt.addValue("value B", p1B * 100.0);
                    rt.addValue("unit", "%");
                    rt.incrementCounter();
                    rt.addValue("value R", "");
                    rt.addValue("value G", "");
                    rt.addValue("value B", "");
                    rt.addValue("unit", "");
                } else {
                    rt.incrementCounter();
                    rt.addLabel("points");
                    rt.addValue("value", (double)n);
                    rt.addValue("unit", "pixel");
                    rt.incrementCounter();
                    rt.addLabel("mean");
                    rt.addValue("value", mean[1]);
                    rt.addValue("unit", "");
                    rt.incrementCounter();
                    rt.addLabel("std");
                    rt.addValue("value", std[0]);
                    rt.addValue("unit", "");
                    rt.incrementCounter();
                    rt.addLabel("+-0.5 reliability");
                    rt.addValue("value", p * 100.0);
                    rt.addValue("unit", "%");
                    rt.incrementCounter();
                    rt.addLabel("+-1% reliability");
                    rt.addValue("value", p1 * 100.0);
                    rt.addValue("unit", "%");
                    rt.incrementCounter();
                    rt.addValue("value", "");
                    rt.addValue("unit", "");
                }
                rt.showRowNumbers(false);
                rt.show("Results");
                plotYmax = 0.0;
                ImagePlus img = WindowManager.getCurrentImage();
                float[] minmax = LJPrefs.getMinMax(img);
                float max = minmax[1];
                float min = minmax[0];
                Plot hist = this.plotHistogram(img, min, max);
                int Nvox = img.getWidth() * img.getHeight() * img.getStackSize();
                double[] tmean = new double[]{mean[1], mean[2], mean[3]};
                Plot gauss = this.plotGauss(hist, tmean, std, Nvox, min, max);
                gauss.setAxisYLog(true);
                ImagePlus ansimg = gauss.getImagePlus();
                ImageProcessor ansplot = ansimg.getProcessor();
                double width = ansplot.getWidth();
                int avColor = (int)mean[1];
                avColor = (int)((float)(avColor * 255) / max);
                avColor = ((avColor & 0xFF) << 16) + ((avColor & 0xFF) << 8) + (avColor & 0xFF);
                if (mean[2] != 0.0) {
                    avColor = (((int)mean[1] & 0xFF) << 16) + (((int)mean[2] & 0xFF) << 8) + ((int)mean[3] & 0xFF);
                }
                int i = (int)(width * 0.9);
                while ((double)i < width) {
                    for (int j = 0; j < (int)(width * 0.1); ++j) {
                        ansplot.set(i, j, avColor);
                    }
                    ++i;
                }
                ansimg.show();
            }
        }
    }

    Plot plotHistogram(ImagePlus imp, float min, float max) {
        float[] Xs = new float[256];
        float[] Ys = new float[256];
        float[] YsG = new float[256];
        float[] YsB = new float[256];
        ImageStack stack = imp.getStack();
        int width = imp.getWidth();
        int height = imp.getHeight();
        int n = width * height;
        int images = imp.getStackSize();
        for (int i = 0; i <= 255; ++i) {
            Xs[i] = (float)i * (max - min) / 255.0f + min;
        }
        Plot plot = new Plot("Histogram", "pixel value", "pixel count");
        plot.setLimits((double)min, (double)max, 0.0, (double)n);
        if (imp.getBitDepth() == 24) {
            for (int img = 1; img <= images; ++img) {
                ImageProcessor ip = stack.getProcessor(img);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int[] pixel = new int[3];
                        ip.getPixel(x, y, pixel);
                        int[] box = new int[]{Math.round(((float)pixel[0] - min) * 255.0f / (max - min)), Math.round(((float)pixel[1] - min) * 255.0f / (max - min)), Math.round(((float)pixel[2] - min) * 255.0f / (max - min))};
                        int n2 = box[0];
                        Ys[n2] = Ys[n2] + 1.0f;
                        int n3 = box[1];
                        YsG[n3] = YsG[n3] + 1.0f;
                        int n4 = box[2];
                        YsB[n4] = YsB[n4] + 1.0f;
                        if ((double)Ys[box[0]] > plotYmax) {
                            plotYmax = Ys[box[0]];
                        }
                        if ((double)YsG[box[1]] > plotYmax) {
                            plotYmax = YsG[box[1]];
                        }
                        if (!((double)YsB[box[2]] > plotYmax)) continue;
                        plotYmax = YsB[box[2]];
                    }
                }
            }
            plot.setColor(Color.RED);
            plot.addPoints(Xs, Ys, 2);
            plot.draw();
            plot.setColor(Color.GREEN);
            plot.addPoints(Xs, YsG, 2);
            plot.draw();
            plot.setColor(Color.BLUE);
            plot.addPoints(Xs, YsB, 2);
            plot.draw();
        } else {
            for (int img = 1; img <= images; ++img) {
                ImageProcessor ip = stack.getProcessor(img);
                for (int i = 0; i < n; ++i) {
                    int box;
                    float v = ip.getf(i);
                    int n5 = box = Math.round((v - min) * 255.0f / (max - min));
                    Ys[n5] = Ys[n5] + 1.0f;
                    if (!((double)Ys[box] > plotYmax)) continue;
                    plotYmax = Ys[box];
                }
            }
            plot.addPoints(Xs, Ys, 2);
            plot.setColor(Color.BLACK);
            plot.draw();
        }
        return plot;
    }

    Plot plotGauss(Plot plot, double[] mean, double[] std, int n, float min, float max) {
        float[] Xs = new float[256];
        float[] Ys = new float[256];
        float[] YsG = new float[256];
        float[] YsB = new float[256];
        float yMax = 0.0f;
        float yMaxG = 0.0f;
        float yMaxB = 0.0f;
        float step = (max - min) / 256.0f;
        float F1 = (float)(1.0 / (std[0] * Math.sqrt(Math.PI * 2)));
        float D1 = (float)(2.0 * Math.pow(std[0], 2.0));
        float F2 = (float)(1.0 / (std[1] * Math.sqrt(Math.PI * 2)));
        float D2 = (float)(2.0 * Math.pow(std[1], 2.0));
        float F3 = (float)(1.0 / (std[2] * Math.sqrt(Math.PI * 2)));
        float D3 = (float)(2.0 * Math.pow(std[2], 2.0));
        float x = min;
        if (mean[2] != 0.0) {
            for (int i = 0; i < 256; ++i) {
                Xs[i] = x;
                Ys[i] = (float)(0.66 * (double)step * (double)n * (double)F1 * Math.exp(-1.0 * Math.pow((double)x - mean[0], 2.0) / (double)D1));
                YsG[i] = (float)(0.66 * (double)step * (double)n * (double)F2 * Math.exp(-1.0 * Math.pow((double)x - mean[1], 2.0) / (double)D2));
                YsB[i] = (float)(0.66 * (double)step * (double)n * (double)F3 * Math.exp(-1.0 * Math.pow((double)x - mean[2], 2.0) / (double)D3));
                if (Ys[i] > yMax) {
                    yMax = Ys[i];
                }
                if (YsG[i] > yMaxG) {
                    yMaxG = YsG[i];
                }
                if (YsB[i] > yMaxB) {
                    yMaxB = YsB[i];
                }
                x += step;
            }
            float[] mR = new float[]{(float)mean[0]};
            float[] yR = new float[]{yMax};
            float[] mG = new float[]{(float)mean[1]};
            float[] yG = new float[]{yMaxG};
            float[] mB = new float[]{(float)mean[2]};
            float[] yB = new float[]{yMaxB};
            plot.setColor(Color.RED);
            plot.addPoints(Xs, Ys, 6);
            plot.addPoints(mR, yR, 0);
            plot.setColor(Color.GREEN);
            plot.addPoints(Xs, YsG, 6);
            plot.addPoints(mG, yG, 0);
            plot.setColor(Color.BLUE);
            plot.addPoints(Xs, YsB, 6);
            plot.addPoints(mB, yB, 0);
        } else {
            for (int i = 0; i < 256; ++i) {
                Xs[i] = x;
                Ys[i] = (float)(0.66 * (double)step * (double)n * (double)F1 * Math.exp(-1.0 * Math.pow((double)x - mean[0], 2.0) / (double)D1));
                if (Ys[i] > yMax) {
                    yMax = Ys[i];
                }
                x += step;
            }
            plot.setColor(Color.BLACK);
            plot.addPoints(Xs, Ys, 6);
            float[] mR = new float[]{(float)mean[0]};
            float[] yR = new float[]{yMax};
            plot.addPoints(mR, yR, 4);
        }
        plotYmax = Math.max(plotYmax, (double)yMax);
        plotYmax = Math.max(plotYmax, (double)yMaxG);
        plotYmax = Math.max(plotYmax, (double)yMaxB);
        plot.setLimits((double)min, (double)max, 0.0, plotYmax);
        plot.draw();
        return plot;
    }

    double tToP(double t, int df) {
        double A9 = (double)df - 0.5;
        double B9 = 48.0 * A9 * A9;
        double T9 = t * t / (double)df;
        double Z8 = 0.0;
        Z8 = T9 > 0.04 ? A9 * Math.log(1.0 + T9) : A9 * (((1.0 - T9 * 0.75) * T9 / 3.0 - 0.5) * T9 + 1.0) * T9;
        double P7 = ((0.4 * Z8 + 3.3) * Z8 + 24.0) * Z8 + 85.5;
        double B7 = 0.8 * Z8 * Z8 + 100.0 + B9;
        double z = (1.0 + (-P7 / B7 + Z8 + 3.0) / B9) * Math.sqrt(Z8);
        double a1 = 5.383E-6;
        double a2 = 4.88906E-5;
        double a3 = 3.80036E-5;
        double a4 = 0.0032776263;
        double a5 = 0.0211410061;
        double a6 = 0.049867347;
        double p_2t = Math.pow((((((a1 * z + a2) * z + a3) * z + a4) * z + a5) * z + a6) * z + 1.0, -16.0);
        double p = Math.abs(2.0 - p_2t) - 1.0;
        return p;
    }

    void showCoordinates(PolygonRoi roi) {
        PolygonRoi polygon = roi;
        int[] x = polygon.getXCoordinates();
        int[] y = polygon.getYCoordinates();
        Rectangle bounds = polygon.getBounds();
        for (int i = 0; i < x.length; ++i) {
            IJ.log((String)("point " + i + ": " + (x[i] + bounds.x) + "|" + (y[i] + bounds.y)));
        }
    }

    double[] updateMean(ImageProcessor ip, PointRoi roi, double[] inp) {
        double mean = inp[1];
        double meanG = inp[2];
        double meanB = inp[3];
        int n = (int)inp[0];
        Rectangle bounds = roi.getBounds();
        mean *= (double)n;
        meanG *= (double)n;
        meanB *= (double)n;
        if (ip.getBitDepth() == 24) {
            int[] pixel = new int[3];
            ip.getPixel(bounds.x, bounds.y, pixel);
            ++n;
            mean += (double)pixel[0];
            meanG += (double)pixel[1];
            meanB += (double)pixel[2];
        } else {
            int pixel = ip.get(bounds.x, bounds.y);
            ++n;
            mean += (double)pixel;
        }
        double[] ans = new double[]{n, mean /= (double)n, meanG /= (double)n, meanB /= (double)n};
        return ans;
    }

    double[] updateMean(ImageProcessor ip, Roi roi, double[] inp) {
        int y;
        int n = (int)inp[0];
        double mean = inp[1];
        double meanG = inp[2];
        double meanB = inp[3];
        Rectangle roiRect = roi.getBounds();
        int width = ip.getWidth();
        mean *= (double)n;
        meanG *= (double)n;
        meanB *= (double)n;
        if (ip.getBitDepth() == 24) {
            for (y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                for (int x = roiRect.x; x < roiRect.x + roiRect.width; ++x) {
                    int[] pixel = new int[3];
                    ip.getPixel(x, y, pixel);
                    mean += (double)pixel[0];
                    meanG += (double)pixel[1];
                    meanB += (double)pixel[2];
                    ++n;
                }
            }
        } else {
            for (y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                int x = roiRect.x;
                int p = x + y * width;
                while (x < roiRect.x + roiRect.width) {
                    double pixel = ip.getf(p);
                    mean += pixel;
                    ++n;
                    ++x;
                    ++p;
                }
            }
        }
        double[] ans = new double[]{n, mean /= (double)n, meanG /= (double)n, meanB /= (double)n};
        return ans;
    }

    double[] updateStd(ImageProcessor ip, PointRoi roi, double[] cstd, double[] mn) {
        double[] mean = new double[]{mn[1], mn[2], mn[3]};
        Rectangle bounds = roi.getBounds();
        if (ip.getBitDepth() == 24) {
            int[] pixel = new int[3];
            ip.getPixel(bounds.x, bounds.y, pixel);
            cstd[0] = cstd[0] + (mean[0] - (double)pixel[0]) * (mean[0] - (double)pixel[0]);
            cstd[1] = cstd[1] + (mean[1] - (double)pixel[1]) * (mean[1] - (double)pixel[1]);
            cstd[2] = cstd[2] + (mean[2] - (double)pixel[2]) * (mean[2] - (double)pixel[2]);
        } else {
            int pixel = ip.get(bounds.x, bounds.y);
            cstd[0] = cstd[0] + (mean[0] - (double)pixel) * (mean[0] - (double)pixel);
        }
        return cstd;
    }

    double[] updateStd(ImageProcessor ip, Roi roi, double[] cstd, double[] mn) {
        double[] mean = new double[]{mn[1], mn[2], mn[3]};
        Rectangle roiRect = roi.getBounds();
        int width = ip.getWidth();
        if (ip.getBitDepth() == 24) {
            for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                for (int x = roiRect.x; x < roiRect.x + roiRect.width; ++x) {
                    int[] pixel = new int[3];
                    ip.getPixel(x, y, pixel);
                    cstd[0] = cstd[0] + (mean[0] - (double)pixel[0]) * (mean[0] - (double)pixel[0]);
                    cstd[1] = cstd[1] + (mean[1] - (double)pixel[1]) * (mean[1] - (double)pixel[1]);
                    cstd[2] = cstd[2] + (mean[2] - (double)pixel[2]) * (mean[2] - (double)pixel[2]);
                }
            }
        } else {
            for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                int x = roiRect.x;
                int p = x + y * width;
                while (x < roiRect.x + roiRect.width) {
                    double pixel = ip.getf(p);
                    cstd[0] = cstd[0] + (mean[0] - pixel) * (mean[0] - pixel);
                    ++x;
                    ++p;
                }
            }
        }
        return cstd;
    }
}

