/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.plugin.PlugIn;
import ij.process.ImageStatistics;
import java.io.IOException;
import java.util.Properties;
import lj.LJPrefs;
import lj.process.VirtualBlockStatistics;

public class Block_Histogram
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private static String BC_inDirectory = LJPrefs.LJ_outDirectory;
    private static int maxX = 1;
    private static int maxY = 1;
    private static int maxZ = 1;
    private static int stepX = 1;
    private static int stepY = 1;
    private static int stepZ = 1;
    private static int haloX = 0;
    private static int haloY = 0;
    private static int haloZ = 0;
    private static double globMax = 255.0;
    private static double globMin = 0.0;
    private boolean usePrefs = true;
    private boolean doUpdate = true;
    private int nBins = 256;

    public void run(String command) {
        double min = globMin;
        double max = globMax;
        IJ.showStatus((String)"Getting data...");
        IJ.showProgress((int)0, (int)100);
        GenericDialog gd = new GenericDialog(command + " Histogram of 3D Blocks");
        gd.addStringField("Input directory", BC_inDirectory, 100);
        gd.addNumericField("Bins", (double)this.nBins, 4);
        gd.addCheckbox("Use pixel value range", this.usePrefs);
        gd.addMessage("or use:");
        gd.addNumericField("X_min", min, 4);
        gd.addNumericField("X_max", max, 4);
        gd.addCheckbox("Update Properties.txt", this.doUpdate);
        IJ.showStatus((String)"Waiting for user input...");
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            IJ.showStatus((String)"Plug In cancelled...");
            IJ.showProgress((int)100, (int)100);
            return;
        }
        IJ.showStatus((String)"Getting data...");
        BC_inDirectory = gd.getNextString();
        this.nBins = (int)gd.getNextNumber();
        this.usePrefs = gd.getNextBoolean();
        min = gd.getNextNumber();
        max = gd.getNextNumber();
        this.doUpdate = gd.getNextBoolean();
        Properties prefs = new Properties();
        try {
            prefs = LJPrefs.readProperties(BC_inDirectory + "\\properties.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        maxX = LJPrefs.getPref(prefs, "maxX", maxX);
        maxY = LJPrefs.getPref(prefs, "maxY", maxY);
        maxZ = LJPrefs.getPref(prefs, "maxZ", maxZ);
        stepX = LJPrefs.getPref(prefs, "stepX", stepX);
        stepY = LJPrefs.getPref(prefs, "stepY", stepY);
        stepZ = LJPrefs.getPref(prefs, "stepZ", stepZ);
        haloX = LJPrefs.getPref(prefs, "haloX", haloX);
        haloY = LJPrefs.getPref(prefs, "haloY", haloY);
        haloZ = LJPrefs.getPref(prefs, "haloZ", haloZ);
        globMin = (float)LJPrefs.getPref(prefs, "minVal", globMin);
        globMax = (float)LJPrefs.getPref(prefs, "maxVal", globMax);
        if (this.usePrefs) {
            min = globMin;
            max = globMax;
        }
        IJ.showStatus((String)"Reading blocks...");
        IJ.showProgress((int)0, (int)100);
        VirtualBlockStatistics stats = new VirtualBlockStatistics(BC_inDirectory, this.nBins, min, max);
        if (this.doUpdate) {
            prefs = new Properties();
            prefs.put("maxX", Double.toString(maxX));
            prefs.put("maxY", Double.toString(maxY));
            prefs.put("maxZ", Double.toString(maxZ));
            prefs.put("stepX", Double.toString(stepX));
            prefs.put("stepY", Double.toString(stepY));
            prefs.put("stepZ", Double.toString(stepZ));
            prefs.put("haloX", Double.toString(haloX));
            prefs.put("haloY", Double.toString(haloY));
            prefs.put("haloZ", Double.toString(haloZ));
            prefs.put("minVal", Double.toString(stats.min));
            prefs.put("maxVal", Double.toString(stats.max));
            prefs.put("meanVal", Double.toString(stats.mean));
            prefs.put("StdDev", Double.toString(stats.stdDev));
            try {
                LJPrefs.writeProperties(prefs, BC_inDirectory + "\\properties.txt");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int x = 0;
        int y = 0;
        int z = 0;
        String filein = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, z, y, x);
        ImagePlus imp2 = IJ.openImage((String)filein);
        imp2.show();
        new HistogramWindow("Histogram of " + BC_inDirectory, imp2, (ImageStatistics)stats);
        imp2.close();
        IJ.showStatus((String)"Histogram created");
        IJ.showProgress((int)100, (int)100);
    }
}

