/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Color;
import lj.LJPrefs;

public class Colorize_
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    static Color[] LJColors = LJPrefs.LJ_Colors;

    public void run(String command) {
        ImagePlus image;
        if (IJ.versionLessThan((String)"1.49s")) {
            IJ.showStatus((String)"Plug-In unable to run.");
            return;
        }
        IJ.showStatus((String)"Colorizing Image...");
        String arguments = "";
        if (IJ.isMacro() && Macro.getOptions() != null && !Macro.getOptions().trim().isEmpty()) {
            arguments = Macro.getOptions().trim();
            System.out.println(arguments);
            IJ.log((String)arguments);
        }
        if (WindowManager.getImageCount() <= 0) {
            IJ.error((String)"no image opened to apply filter to");
            IJ.showStatus((String)"Plug-In unable to run.");
            return;
        }
        if (IJ.isMacro()) {
            String title = null;
            title = LJPrefs.retrieveOption(arguments, "image", title);
            image = WindowManager.getImage((String)title);
        } else {
            image = WindowManager.getCurrentImage();
        }
        int tFrames = image.getNFrames();
        Color[] userColor = new Color[tFrames];
        String[] keys = new String[tFrames + 1];
        String[] values = new String[tFrames + 1];
        for (int f = 1; f <= tFrames; ++f) {
            int index = image.getStackIndex(1, 1, f);
            String label = image.getStack().getShortSliceLabel(index);
            if (IJ.isMacro()) {
                System.out.println("I'm a macro\n");
                userColor[f - 1] = LJPrefs.retrieveOption(arguments, "color" + f, userColor[f - 1]);
            }
            if (f < 5 && userColor[f - 1] == null) {
                userColor[f - 1] = LJPrefs.getColor("Choose color for " + label + " ( frame " + f + ")", LJColors[f - 1]);
                Colorize_.LJColors[f - 1] = userColor[f - 1];
            } else if (userColor[f - 1] == null) {
                userColor[f - 1] = LJPrefs.getColor("Choose color for " + label + " ( frame " + f + ")", LJColors[4]);
            }
            keys[f] = "color" + f;
            values[f] = "" + Tools.c2hex((Color)userColor[f - 1]);
        }
        LJPrefs.LJ_Colors = LJColors;
        LJPrefs.savePreferences();
        keys[0] = "image";
        values[0] = image.getTitle();
        int tHeight = image.getHeight();
        int tWidth = image.getWidth();
        int tDepth = image.getNSlices();
        ImagePlus imgout = IJ.createImage((String)"Result", (String)"RGB", (int)tWidth, (int)tHeight, (int)tDepth);
        for (int f = 1; f <= tFrames; ++f) {
            for (int z = 1; z <= tDepth; ++z) {
                int index = image.getStackIndex(1, z, f);
                ImageProcessor imageIP = image.getStack().getProcessor(index).convertToByte(true);
                ImageProcessor outputIP = imgout.getStack().getProcessor(z);
                byte[] iPixels = (byte[])imageIP.getPixels();
                int[] oPixels = (int[])outputIP.getPixels();
                for (int y = 0; y < tHeight; ++y) {
                    int x = 0;
                    int p = x + y * tWidth;
                    while (x < tWidth) {
                        if (iPixels[p] != 0) {
                            int red = (iPixels[p] & 0xFF) / 2 + userColor[f - 1].getRed() / 2;
                            int green = (iPixels[p] & 0xFF) / 2 + userColor[f - 1].getGreen() / 2;
                            int blue = (iPixels[p] & 0xFF) / 2 + userColor[f - 1].getBlue() / 2;
                            oPixels[p] = ((red & 0xFF) << 16) + ((green & 0xFF) << 8) + (blue & 0xFF);
                        }
                        ++x;
                        ++p;
                    }
                }
            }
        }
        imgout.show();
        LJPrefs.recordRun("Colour by Segment ", keys, values);
        IJ.showStatus((String)"Image Colorized.");
    }
}

