/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;

public class Compare_MapMask
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private double POB = 0.0;
    private double PBO = 0.0;
    private double PO = 0.0;
    private double PB = 0.0;

    public void run(String command) {
        if (IJ.versionLessThan((String)"1.48n")) {
            return;
        }
        IJ.showStatus((String)"Applying Mask...");
        int Nimg = WindowManager.getImageCount();
        if (Nimg < 2) {
            IJ.error((String)"At least two images are required - the correct mask and the map to be tested.");
            return;
        }
        String[] lstImages = WindowManager.getImageTitles();
        int[] lstImageIds = WindowManager.getIDList();
        String[] lstMasks = new String[Nimg];
        String[] lstMaps = new String[Nimg];
        int Nmasks = Nimg;
        int Nmaps = Nimg;
        int masksID = -1;
        int mapsID = -1;
        for (int i = 0; i < Nimg; ++i) {
            ImageProcessor temp = WindowManager.getImage((int)lstImageIds[i]).getProcessor();
            if (temp.getMin() == 0.0 && temp.getMax() == 1.0 || temp.isBinary()) {
                lstMaps[i] = lstImages[i];
                lstMasks[i] = lstImages[i];
                if (mapsID == -1) {
                    mapsID = i;
                }
                if (masksID != -1) continue;
                masksID = i;
                continue;
            }
            if (temp.getMin() >= 0.0 && temp.getMax() <= 1.0) {
                lstMaps[i] = lstImages[i];
                lstMasks[i] = "--not a mask--";
                --Nmasks;
                if (mapsID == -1) {
                    mapsID = i;
                }
                IJ.log((String)(String.valueOf(temp.getMin()) + " - " + String.valueOf(temp.getMin())));
                continue;
            }
            lstMaps[i] = "--not a map--";
            lstMasks[i] = "--not a mask--";
            --Nmasks;
            --Nmaps;
        }
        if (Nmasks < 1) {
            IJ.error((String)"Could not find a valid mask. (A mask needs to be binary)");
            return;
        }
        if (Nmaps < 2) {
            IJ.error((String)"Could not find two valid input images. (A mask needs to be binary, and a map only contain values between 0 and 1)");
            return;
        }
        GenericDialog gd = new GenericDialog(command + " Compare Mask");
        gd.addChoice("Actual Mask", lstMasks, lstMasks[masksID]);
        gd.addChoice("Detected Map", lstMaps, lstMaps[mapsID]);
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int AM_srcID = lstImageIds[gd.getNextChoiceIndex()];
        int AM_maskID = lstImageIds[gd.getNextChoiceIndex()];
        ImagePlus image = WindowManager.getImage((int)AM_srcID);
        ImagePlus mask = WindowManager.getImage((int)AM_maskID);
        int tHeight = image.getHeight();
        int tWidth = image.getWidth();
        int tDepth = image.getNSlices();
        int tFrames = mask.getNFrames();
        int tFrames2 = image.getNFrames();
        int tChannels = mask.getNChannels();
        int tChannels2 = image.getNChannels();
        if (tFrames != tFrames2 || tChannels != tChannels2) {
            IJ.error((String)"Images do not have the same size. (Also check number of frames and channels.)");
            return;
        }
        if (tChannels > 1) {
            IJ.error((String)"Can't handle multi-channel images.");
            return;
        }
        ImagePlus imgout = IJ.createHyperStack((String)"Result", (int)tWidth, (int)tHeight, (int)3, (int)tDepth, (int)tFrames, (int)32);
        for (int z = 1; z <= tDepth; ++z) {
            for (int f = 1; f <= tFrames; ++f) {
                int index = mask.getStackIndex(1, z, f);
                int indexi = image.getStackIndex(1, z, f);
                int indexR = imgout.getStackIndex(1, z, f);
                int indexG = imgout.getStackIndex(2, z, f);
                int indexB = imgout.getStackIndex(3, z, f);
                ImageProcessor imageIP = image.getStack().getProcessor(indexi).convertToFloat();
                ImageProcessor maskIP = mask.getStack().getProcessor(index).convertToFloat();
                ImageProcessor outputIPR = imgout.getStack().getProcessor(indexR);
                ImageProcessor outputIPG = imgout.getStack().getProcessor(indexG);
                ImageProcessor outputIPB = imgout.getStack().getProcessor(indexB);
                float[] mPixels = (float[])maskIP.getPixels();
                float[] iPixels = (float[])imageIP.getPixels();
                float[] oPixelsR = (float[])outputIPR.getPixels();
                float[] oPixelsG = (float[])outputIPG.getPixels();
                float[] oPixelsB = (float[])outputIPB.getPixels();
                float tempR = 0.0f;
                float tempG = 0.0f;
                float tempB = 0.0f;
                for (int y = 0; y < tHeight; ++y) {
                    int x = 0;
                    int p = x + y * tWidth;
                    while (x < tWidth) {
                        if (iPixels[p] == 255.0f) {
                            tempR = 1.0f - mPixels[p];
                            tempG = 0.0f;
                            tempB = 1.0f;
                        } else {
                            tempR = iPixels[p] * (1.0f - mPixels[p]);
                            tempG = (1.0f - iPixels[p]) * mPixels[p];
                            tempB = iPixels[p];
                        }
                        this.POB += (double)tempG;
                        this.PBO += (double)tempR;
                        this.PO += (double)tempB;
                        this.PB += (double)(1.0f - tempB);
                        oPixelsR[p] = mPixels[p];
                        oPixelsG[p] = iPixels[p] * mPixels[p];
                        oPixelsB[p] = iPixels[p];
                        ++x;
                        ++p;
                    }
                }
            }
        }
        ResultsTable rt = Analyzer.getResultsTable();
        if (rt == null) {
            rt = new ResultsTable();
            Analyzer.setResultsTable((ResultsTable)rt);
        }
        rt.incrementCounter();
        rt.addLabel("Total");
        rt.addValue("Value", this.PO + this.PB);
        rt.addValue("Unit", "voxel");
        rt.incrementCounter();
        rt.addLabel("foreground");
        rt.addValue("Value", this.PO);
        rt.addValue("Unit", "voxel");
        rt.incrementCounter();
        rt.addLabel("background");
        rt.addValue("Value", this.PB);
        rt.addValue("Unit", "voxel");
        rt.incrementCounter();
        rt.addLabel("");
        rt.addValue("Value", "");
        rt.addValue("Unit", "");
        this.POB /= this.PB;
        this.PBO /= this.PO;
        double total = this.PO + this.PB;
        this.PB /= total;
        this.PO /= total;
        double Perr = this.PB * this.POB + this.PO * this.PBO;
        rt.incrementCounter();
        rt.addLabel("PO");
        rt.addValue("Value", 100.0 * this.PO);
        rt.addValue("Unit", "%");
        rt.incrementCounter();
        rt.addLabel("PB");
        rt.addValue("Value", 100.0 * this.PB);
        rt.addValue("Unit", "%");
        rt.incrementCounter();
        rt.addLabel("POB");
        rt.addValue("Value", 100.0 * this.POB);
        rt.addValue("Unit", "%");
        rt.incrementCounter();
        rt.addLabel("PBO");
        rt.addValue("Value", 100.0 * this.PBO);
        rt.addValue("Unit", "%");
        rt.incrementCounter();
        rt.addLabel("Perr");
        rt.addValue("Value", 100.0 * Perr);
        rt.addValue("Unit", "%");
        rt.showRowNumbers(false);
        imgout.show();
        rt.show("Results");
        IJ.showStatus((String)"Masks Compared.");
    }
}

