/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;

public class Compare_Masks
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private double TP = 0.0;
    private double TN = 0.0;
    private double FP = 0.0;
    private double FN = 0.0;

    public void run(String command) {
        if (IJ.versionLessThan((String)"1.48n")) {
            return;
        }
        IJ.showStatus((String)"Applying Mask...");
        int Nimg = WindowManager.getImageCount();
        if (Nimg < 2) {
            IJ.error((String)"At least two images are required - the correct mask and the mask to be tested.");
            return;
        }
        String[] lstImages = WindowManager.getImageTitles();
        int[] lstImageIds = WindowManager.getIDList();
        String[] lstMasks = new String[Nimg];
        int Nmasks = Nimg;
        for (int i = 0; i < Nimg; ++i) {
            ImageProcessor temp = WindowManager.getImage((int)lstImageIds[i]).getProcessor();
            if (temp.getMin() == 0.0 && temp.getMax() == 1.0 || temp.isBinary()) {
                lstMasks[i] = lstImages[i];
                continue;
            }
            lstMasks[i] = "--not a mask--";
            --Nmasks;
            IJ.log((String)(String.valueOf(temp.getMin()) + " - " + String.valueOf(temp.getMax())));
        }
        if (Nmasks < 2) {
            IJ.error((String)"Could not find two valid masks. (A mask needs to be binary, or only contain values between 0 and 1)");
            return;
        }
        GenericDialog gd = new GenericDialog(command + " Compare Mask");
        gd.addChoice("Actual Mask", lstMasks, lstMasks[0]);
        gd.addChoice("Detected Mask", lstMasks, lstMasks[0]);
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int AM_srcID = lstImageIds[gd.getNextChoiceIndex()];
        int AM_maskID = lstImageIds[gd.getNextChoiceIndex()];
        ImagePlus image = WindowManager.getImage((int)AM_srcID);
        ImagePlus mask = WindowManager.getImage((int)AM_maskID);
        int tHeight = image.getHeight();
        int tWidth = image.getWidth();
        int tDepth = image.getNSlices();
        int tFrames = mask.getNFrames();
        int tChannels = mask.getNChannels();
        if (tChannels > 1) {
            IJ.error((String)"Can't handle multi-channel images.");
            return;
        }
        ImagePlus imgout = IJ.createHyperStack((String)"Result", (int)tWidth, (int)tHeight, (int)3, (int)tDepth, (int)tFrames, (int)8);
        for (int z = 1; z <= tDepth; ++z) {
            for (int f = 1; f <= tFrames; ++f) {
                int index = mask.getStackIndex(1, z, f);
                int indexi = image.getStackIndex(1, z, f);
                int indexR = imgout.getStackIndex(1, z, f);
                int indexG = imgout.getStackIndex(2, z, f);
                int indexB = imgout.getStackIndex(3, z, f);
                ImageProcessor imageIP = image.getStack().getProcessor(indexi).convertToByte(true);
                ImageProcessor maskIP = mask.getStack().getProcessor(index).convertToByte(true);
                ImageProcessor outputIPR = imgout.getStack().getProcessor(indexR);
                ImageProcessor outputIPG = imgout.getStack().getProcessor(indexG);
                ImageProcessor outputIPB = imgout.getStack().getProcessor(indexB);
                byte[] mPixels = (byte[])maskIP.getPixels();
                byte[] iPixels = (byte[])imageIP.getPixels();
                byte[] oPixelsR = (byte[])outputIPR.getPixels();
                byte[] oPixelsG = (byte[])outputIPG.getPixels();
                byte[] oPixelsB = (byte[])outputIPB.getPixels();
                for (int y = 0; y < tHeight; ++y) {
                    int x = 0;
                    int p = x + y * tWidth;
                    while (x < tWidth) {
                        if (mPixels[p] == iPixels[p] && iPixels[p] == 0) {
                            this.TN += 1.0;
                            oPixelsR[p] = 0;
                            oPixelsG[p] = 0;
                            oPixelsB[p] = 0;
                        } else if (mPixels[p] == iPixels[p]) {
                            this.TP += 1.0;
                            oPixelsR[p] = -1;
                            oPixelsG[p] = -1;
                            oPixelsB[p] = -1;
                        } else if (mPixels[p] < iPixels[p]) {
                            this.FP += 1.0;
                            oPixelsR[p] = -1;
                            oPixelsG[p] = 0;
                            oPixelsB[p] = 0;
                        } else if (mPixels[p] > iPixels[p]) {
                            this.FN += 1.0;
                            oPixelsR[p] = 0;
                            oPixelsG[p] = 0;
                            oPixelsB[p] = -1;
                        }
                        ++x;
                        ++p;
                    }
                }
            }
        }
        ResultsTable rt = Analyzer.getResultsTable();
        if (rt == null) {
            rt = new ResultsTable();
            Analyzer.setResultsTable((ResultsTable)rt);
        }
        double po = (this.TP + this.TN) / (this.TN + this.TP + this.FP + this.FN);
        double pc = ((this.TP + this.FP) * (this.TP + this.FN) + (this.TN + this.FP) * (this.TN + this.FN)) / ((this.TN + this.TP + this.FP + this.FN) * (this.TN + this.TP + this.FP + this.FN));
        double kappa = (po - pc) / (1.0 - pc);
        double S = 2.0 * this.TP / (2.0 * this.TP + this.FP + this.FN);
        rt.incrementCounter();
        rt.addLabel("True");
        rt.addValue("Positive", this.TP);
        rt.addValue("Negative", this.TN);
        rt.addValue("Percentage", "");
        rt.incrementCounter();
        rt.addLabel("False");
        rt.addValue("Positive", this.FP);
        rt.addValue("Negative", this.FN);
        rt.addValue("Percentage", "");
        rt.incrementCounter();
        rt.addValue("Positive", "");
        rt.addValue("Negative", "");
        rt.addValue("Percentage", "");
        rt.incrementCounter();
        rt.addLabel("sensitivity");
        rt.addValue("Percentage", 100.0 * this.TP / (this.TP + this.FN));
        rt.addValue("Positive", "");
        rt.addValue("Negative", "");
        rt.incrementCounter();
        rt.addLabel("specificity");
        rt.addValue("Percentage", 100.0 * this.TN / (this.TN + this.FP));
        rt.addValue("Positive", "");
        rt.addValue("Negative", "");
        rt.incrementCounter();
        rt.addLabel("alpha");
        rt.addValue("Percentage", 100.0 * this.FP / (this.TN + this.FP));
        rt.addValue("Positive", "");
        rt.addValue("Negative", "");
        rt.incrementCounter();
        rt.addLabel("beta");
        rt.addValue("Percentage", 100.0 * this.FN / (this.TP + this.FN));
        rt.addValue("Positive", "");
        rt.addValue("Negative", "");
        rt.incrementCounter();
        rt.addLabel("accuracy");
        rt.addValue("Percentage", 100.0 * (this.TP + this.TN) / (this.TN + this.TP + this.FP + this.FN));
        rt.addValue("Positive", "");
        rt.addValue("Negative", "");
        rt.incrementCounter();
        rt.addLabel("kappa");
        rt.addValue("Percentage", 100.0 * kappa);
        rt.addValue("Positive", "");
        rt.addValue("Negative", "");
        rt.incrementCounter();
        rt.addLabel("similarity index");
        rt.addValue("Percentage", 100.0 * S);
        rt.addValue("Positive", "");
        rt.addValue("Negative", "");
        rt.showRowNumbers(false);
        imgout.show();
        rt.show("Results");
        IJ.showStatus((String)"Masks Compared.");
    }
}

