/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.IOException;
import java.util.Properties;
import lj.LJPrefs;

public class Concatenate_3D
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private static String BC_inDirectory = LJPrefs.LJ_outDirectory;
    private static int maxX = 1;
    private static int maxY = 1;
    private static int maxZ = 1;
    private static int stepX = 1;
    private static int stepY = 1;
    private static int stepZ = 1;
    private static int haloX = 0;
    private static int haloY = 0;
    private static int haloZ = 0;
    private static double globMax = 1.0;
    private static double globMin = 0.0;

    public void run(String command) {
        IJ.showStatus((String)"Getting data...");
        IJ.showProgress((int)0, (int)100);
        GenericDialog gd = new GenericDialog(command + " Concatenate imageblocks created by subdivide");
        gd.addStringField("Input directory", BC_inDirectory, 100);
        IJ.showStatus((String)"Waiting for user input...");
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            IJ.showStatus((String)"Plug In cancelled...");
            IJ.showProgress((int)100, (int)100);
            return;
        }
        IJ.showStatus((String)"Getting data...");
        BC_inDirectory = gd.getNextString();
        Properties prefs = new Properties();
        try {
            prefs = LJPrefs.readProperties(BC_inDirectory + "\\properties.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        maxX = LJPrefs.getPref(prefs, "maxX", maxX);
        maxY = LJPrefs.getPref(prefs, "maxY", maxY);
        maxZ = LJPrefs.getPref(prefs, "maxZ", maxZ);
        stepX = LJPrefs.getPref(prefs, "stepX", stepX);
        stepY = LJPrefs.getPref(prefs, "stepY", stepY);
        stepZ = LJPrefs.getPref(prefs, "stepZ", stepZ);
        haloX = LJPrefs.getPref(prefs, "haloX", haloX);
        haloY = LJPrefs.getPref(prefs, "haloY", haloY);
        haloZ = LJPrefs.getPref(prefs, "haloZ", haloZ);
        globMin = (float)LJPrefs.getPref(prefs, "minVal", globMin);
        globMax = (float)LJPrefs.getPref(prefs, "maxVal", globMax);
        ImagePlus imgout = null;
        IJ.showStatus((String)"Concatenating blocks...");
        IJ.showProgress((int)0, (int)100);
        int prog = 0;
        int diffz = (int)Math.round((double)(maxZ / stepZ) + 0.5);
        int diffx = (int)Math.round((double)(maxX / stepX) + 0.5);
        int diffy = (int)Math.round((double)(maxY / stepY) + 0.5);
        int maxProg = diffy * diffx * diffz * 100 / 99;
        for (int z = 0; z < maxZ; z += stepZ) {
            for (int x = 0; x < maxX; x += stepX) {
                for (int y = 0; y < maxY; y += stepY) {
                    String filein = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, z, y, x);
                    ImagePlus imgblock = IJ.openImage((String)filein);
                    int bWidth = imgblock.getWidth();
                    int bHeight = imgblock.getHeight();
                    int bDepth = imgblock.getNSlices();
                    int xs = stepX + 2 * haloX;
                    int ys = stepY + 2 * haloY;
                    int zs = stepZ + 2 * haloZ;
                    int x1 = haloX;
                    if (x - haloX < 0) {
                        x1 = 0;
                        xs -= haloX;
                    }
                    int y1 = haloY;
                    if (y - haloY < 0) {
                        y1 = 0;
                        ys -= haloY;
                    }
                    int z1 = haloZ;
                    if (z - haloZ < 0) {
                        z1 = 0;
                        zs -= haloZ;
                    }
                    int x2 = bWidth - haloX;
                    if (x + xs > maxX) {
                        x2 = bWidth;
                    }
                    int y2 = bHeight - haloY;
                    if (y + ys > maxY) {
                        y2 = bHeight;
                    }
                    int z2 = bDepth - haloZ;
                    if (z + zs > maxZ) {
                        z2 = bDepth;
                    }
                    if (imgout == null) {
                        int bd = imgblock.getProcessor().getBitDepth();
                        imgout = IJ.createImage((String)"Result", (int)maxX, (int)maxY, (int)maxZ, (int)bd);
                    }
                    if (imgout == null) {
                        IJ.log((String)("ERROR " + filein));
                    } else {
                        imgout = this.paste(imgblock, imgout, x, y, z, x1, x2, y1, y2, z1, z2);
                        IJ.log((String)("added " + filein));
                    }
                    IJ.showStatus((String)"Concatenating blocks...");
                    IJ.showProgress((int)(++prog), (int)maxProg);
                    IJ.log((String)(prog + "/" + maxProg));
                    imgblock = null;
                }
            }
        }
        IJ.showProgress((int)90, (int)100);
        imgout.show();
        IJ.setMinAndMax((double)globMin, (double)globMax);
        IJ.showStatus((String)"Concatenated blocks");
        IJ.showProgress((int)100, (int)100);
    }

    private ImagePlus paste(ImagePlus img, ImagePlus destimg, int px, int py, int pz) {
        block10: {
            int iDepth;
            int iWidth;
            int iHeight;
            int oWidth;
            ImageProcessor ipo;
            block11: {
                block9: {
                    ipo = destimg.getProcessor();
                    oWidth = destimg.getWidth();
                    iHeight = img.getHeight();
                    iWidth = img.getWidth();
                    iDepth = img.getNSlices();
                    if (ipo.getBitDepth() != 32) break block9;
                    for (int z = pz; z < pz + iDepth; ++z) {
                        float[] oPixels = (float[])destimg.getStack().getProcessor(z + 1).getPixels();
                        float[] iPixels = (float[])img.getStack().getProcessor(z - pz + 1).getPixels();
                        for (int y = py; y < py + iHeight; ++y) {
                            for (int x = px; x < px + iWidth; ++x) {
                                int po = x + y * oWidth;
                                int pi = x - px + (y - py) * iWidth;
                                oPixels[po] = iPixels[pi];
                            }
                        }
                    }
                    break block10;
                }
                if (ipo.getBitDepth() != 16) break block11;
                for (int z = pz; z < pz + iDepth; ++z) {
                    short[] oPixels = (short[])destimg.getStack().getProcessor(z + 1).getPixels();
                    short[] iPixels = (short[])img.getStack().getProcessor(z - pz + 1).getPixels();
                    for (int y = py; y < py + iHeight; ++y) {
                        for (int x = px; x < px + iWidth; ++x) {
                            int po = x + y * oWidth;
                            int pi = x - px + (y - py) * iWidth;
                            oPixels[po] = iPixels[pi];
                        }
                    }
                }
                break block10;
            }
            if (ipo.getBitDepth() != 8) break block10;
            for (int z = pz; z < pz + iDepth; ++z) {
                byte[] oPixels = (byte[])destimg.getStack().getProcessor(z + 1).getPixels();
                byte[] iPixels = (byte[])img.getStack().getProcessor(z - pz + 1).getPixels();
                for (int y = py; y < py + iHeight; ++y) {
                    for (int x = px; x < px + iWidth; ++x) {
                        int po = x + y * oWidth;
                        int pi = x - px + (y - py) * iWidth;
                        oPixels[po] = iPixels[pi];
                    }
                }
            }
        }
        return destimg;
    }

    private ImagePlus paste(ImagePlus img, ImagePlus destimg, int px, int py, int pz, int sx1, int sx2, int sy1, int sy2, int sz1, int sz2) {
        block10: {
            int bWidth;
            int iDepth;
            int iWidth;
            int iHeight;
            int oWidth;
            ImageProcessor ipo;
            block11: {
                block9: {
                    ipo = destimg.getProcessor();
                    oWidth = destimg.getWidth();
                    iHeight = sy2 - sy1;
                    iWidth = sx2 - sx1;
                    iDepth = sz2 - sz1;
                    bWidth = img.getWidth();
                    if (ipo.getBitDepth() != 32) break block9;
                    for (int z = pz; z < pz + iDepth; ++z) {
                        float[] oPixels = (float[])destimg.getStack().getProcessor(z + 1).getPixels();
                        float[] iPixels = (float[])img.getStack().getProcessor(z - pz + sz1 + 1).getPixels();
                        for (int y = py; y < py + iHeight; ++y) {
                            for (int x = px; x < px + iWidth; ++x) {
                                int po = x + y * oWidth;
                                int pi = x + sx1 - px + (y + sy1 - py) * bWidth;
                                oPixels[po] = iPixels[pi];
                            }
                        }
                    }
                    break block10;
                }
                if (ipo.getBitDepth() != 16) break block11;
                for (int z = pz; z < pz + iDepth; ++z) {
                    short[] oPixels = (short[])destimg.getStack().getProcessor(z + 1).getPixels();
                    short[] iPixels = (short[])img.getStack().getProcessor(z - pz + sz1 + 1).getPixels();
                    for (int y = py; y < py + iHeight; ++y) {
                        for (int x = px; x < px + iWidth; ++x) {
                            int po = x + y * oWidth;
                            int pi = x + sx1 - px + (y + sy1 - py) * bWidth;
                            oPixels[po] = iPixels[pi];
                        }
                    }
                }
                break block10;
            }
            if (ipo.getBitDepth() != 8) break block10;
            for (int z = pz; z < pz + iDepth; ++z) {
                byte[] oPixels = (byte[])destimg.getStack().getProcessor(z + 1).getPixels();
                byte[] iPixels = (byte[])img.getStack().getProcessor(z - pz + sz1 + 1).getPixels();
                for (int y = py; y < py + iHeight; ++y) {
                    for (int x = px; x < px + iWidth; ++x) {
                        int po = x + y * oWidth;
                        int pi = x + sx1 - px + (y + sy1 - py) * bWidth;
                        oPixels[po] = iPixels[pi];
                    }
                }
            }
        }
        return destimg;
    }
}

