/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import lj.LJPrefs;

public class Create_MCTV_Tiles
implements PlugIn,
ActionListener {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://dx.doi.org/10.5258/SOTON/400332";
    private static String BC_outDirectory = LJPrefs.LJ_inpDirectory;
    private static int stepX = 256;
    private static int stepY = 256;
    private static int stepZ = 1;
    private static int z_offset = 0;
    private static boolean saveProp = true;
    JButton filebtn;
    JTextField outdirtxt;
    GenericDialog gd;

    private String getDICOMtag(String tagname, String imginfo, String ans) {
        int a;
        int b = a = imginfo.indexOf(tagname);
        if (a > 0) {
            a = imginfo.indexOf("=", a) + 2;
            b = imginfo.indexOf("\n", a);
            ans = imginfo.substring(a, b);
            return ans;
        }
        return ans;
    }

    private Double getDICOMtag(String tagname, String imginfo, Double ans) {
        int a;
        int b = a = imginfo.indexOf(tagname);
        if (a > 0) {
            a = imginfo.indexOf("=", a) + 2;
            b = imginfo.indexOf("\n", a);
            ans = Double.parseDouble(imginfo.substring(a, b));
            return ans;
        }
        return ans;
    }

    public void run(String command) {
        String temp;
        IJ.showStatus((String)"Creating tiles...");
        IJ.showProgress((int)0, (int)100);
        ImagePlus image = WindowManager.getCurrentImage();
        int[] properties = image.getDimensions();
        int maxX = properties[0];
        int maxY = properties[1];
        int maxZ = properties[3];
        Calibration cal = image.getCalibration();
        Double xres = cal.pixelWidth;
        Double yres = cal.pixelHeight;
        Double zres = cal.pixelDepth;
        int tWidth = maxX;
        int tHeight = maxY;
        int tSlices = maxZ;
        Double rescaleM = 1.0;
        Double rescaleB = 0.0;
        int a = 0;
        int b = 0;
        String unit = "";
        String dimstr = "";
        Object prop = image.getProperty("Info");
        String imginfo = (String)prop;
        a = imginfo.indexOf("DICOM");
        if (a > 0) {
            IJ.log((String)"DICOM info found");
            temp = null;
            temp = this.getDICOMtag("Pixel Spacing", imginfo, temp);
            if (temp != null) {
                a = 1;
                b = temp.indexOf("\\", a);
                xres = Double.parseDouble(temp.substring(a, b));
                a = b + 1;
                b = temp.length();
                yres = Double.parseDouble(temp.substring(a, b));
            }
            zres = this.getDICOMtag("Spacing Between Slices", imginfo, zres);
            if ((unit = this.getDICOMtag("0054,1001", imginfo, unit)) == "") {
                unit = "mm";
            }
            dimstr = " (" + (double)tWidth * xres + "x" + (double)tHeight * yres + "x" + (double)tSlices * zres + " " + unit + ")";
        } else if (imginfo.indexOf("0028,0030") > 0) {
            IJ.log((String)"This is not a DICOM-file but DICOM tags were found.");
            temp = null;
            temp = this.getDICOMtag("Pixel Spacing", imginfo, temp);
            if (temp != null) {
                a = 1;
                b = temp.indexOf("\\", a);
                xres = Double.parseDouble(temp.substring(a, b));
                a = b + 1;
                b = temp.length();
                yres = Double.parseDouble(temp.substring(a, b));
            }
            zres = this.getDICOMtag("Spacing Between Slices", imginfo, zres);
            rescaleM = this.getDICOMtag("0028,1053", imginfo, rescaleM);
            rescaleB = this.getDICOMtag("0028,1052", imginfo, rescaleB);
            if ((unit = this.getDICOMtag("0054,1001", imginfo, unit)) == "") {
                unit = "mm";
            }
            dimstr = " (" + (double)tWidth * xres + "x" + (double)tHeight * yres + "x" + (double)tSlices * zres + " " + unit + ")";
        } else {
            IJ.log((String)"not a DICOM");
            IJ.log((String)imginfo);
            a = imginfo.indexOf("\nUnit ");
            if (a > 0) {
                a = imginfo.indexOf("=", a) + 2;
                b = imginfo.indexOf("\n", a);
                unit = imginfo.substring(a, b);
                dimstr = " (" + (double)tWidth * xres + "x" + (double)tHeight * yres + "x" + (double)tSlices * zres + " " + unit + ")";
            }
        }
        dimstr = "  Physical dimensions:" + dimstr;
        float[] minmax = new float[2];
        minmax = LJPrefs.getMinMax(image);
        float globMin = minmax[0];
        float globMax = minmax[1];
        double densmin = (double)globMin * rescaleM + rescaleB;
        double densmax = (double)globMax * rescaleM + rescaleB;
        String HUrange = "  Density in [" + densmin + "," + densmax + "] HU";
        this.gd = new GenericDialog(command + " Create image tiles compatible with Multiresolution CT Viewer");
        Font gdFont = this.gd.getFont();
        JLabel outdirlbl = new JLabel("Output directory  ", 4);
        outdirlbl.setFont(gdFont);
        this.outdirtxt = new JTextField(BC_outDirectory, 80);
        this.outdirtxt.setFont(gdFont);
        this.filebtn = new JButton("...");
        this.filebtn.addActionListener(this);
        this.gd.add((Component)outdirlbl, -1);
        this.gd.add((Component)this.outdirtxt, -1);
        this.gd.add((Component)this.filebtn, -1);
        this.gd.addMessage("     ");
        this.gd.addMessage("Block Properties:");
        this.gd.addMessage(dimstr);
        this.gd.addMessage(HUrange);
        this.gd.addMessage("Settings:");
        this.gd.addNumericField("z-offset", (double)z_offset, 0, 4, "(affects filename only)");
        this.gd.addCheckbox("save MCTV header", saveProp);
        IJ.showStatus((String)"Waiting for User Input...");
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            this.gd.addHelp(PLUGIN_HELP_URL);
        }
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            IJ.showStatus((String)"Plug-In aborted...");
            IJ.showProgress((int)100, (int)100);
            return;
        }
        IJ.showStatus((String)"Creating tiles...");
        IJ.showProgress((int)1, (int)100);
        BC_outDirectory = this.outdirtxt.getText();
        Recorder.recordOption((String)"directory", (String)BC_outDirectory);
        z_offset = (int)this.gd.getNextNumber();
        saveProp = this.gd.getNextBoolean();
        int x1 = 0;
        int y1 = 0;
        int z1 = 0;
        int xs = stepX;
        int ys = stepY;
        int zs = stepZ;
        int x2 = x1 + xs;
        int y2 = y1 + ys;
        int z2 = z1 + zs;
        int maxZoomlevel = (int)Math.ceil(Math.log(Math.max((double)maxX / (double)xs, (double)maxY / (double)ys)) / Math.log(2.0));
        ImagePlus scaledimage = new Duplicator().run(image, z1 + 1, maxZ);
        ImageProcessor ip_scaledimage = scaledimage.getProcessor();
        scaledimage.show();
        String JSONStr = "{\n";
        JSONStr = JSONStr + String.format("\"%1$s\":%2$d,\n", "height", tHeight);
        JSONStr = JSONStr + String.format("\"%1$s\":%2$d,\n", "width", tWidth);
        JSONStr = JSONStr + String.format("\"%1$s\":%2$d,\n", "Slices", tSlices);
        JSONStr = JSONStr + String.format("\"%1$s\":\"%2$s\",\n", "Units", unit);
        JSONStr = JSONStr + String.format("\"%1$s\":%2$g,\n", "PixelSpacing", xres);
        JSONStr = JSONStr + String.format("\"%1$s\":%2$g,\n", "SpacingBetweenSlices", zres);
        JSONStr = JSONStr + String.format("\"%1$s\":%2$g,\n", "densmin", densmin);
        JSONStr = JSONStr + String.format("\"%1$s\":%2$g,\n", "densmax", densmax);
        JSONStr = JSONStr + "\"slides\": [\n";
        ImageProcessor ip_crossimg = ip_scaledimage.resize(maxX, maxZ);
        ImagePlus crossimg = new ImagePlus("cross-section", ip_crossimg);
        for (int zoomlevel = maxZoomlevel; zoomlevel >= 0; --zoomlevel) {
            IJ.showProgress((int)(maxZoomlevel - zoomlevel + 1), (int)(maxZoomlevel + 3));
            ip_scaledimage.resetRoi();
            scaledimage.setRoi(1, 1, maxX, maxY);
            if (zoomlevel != maxZoomlevel) {
                IJ.run((ImagePlus)scaledimage, (String)"Size...", (String)("width=" + maxX / 2 + " height=" + maxY / 2 + " depth=" + maxZ + " constrain average interpolation=Bilinear"));
            }
            properties = scaledimage.getDimensions();
            maxX = properties[0];
            maxY = properties[1];
            maxZ = properties[3];
            for (int z = 0; z < maxZ; z += stepZ) {
                ip_scaledimage.setSliceNumber(z);
                if (zoomlevel == maxZoomlevel) {
                    JSONStr = JSONStr + "{\"path\": \"";
                    JSONStr = JSONStr + String.format("./%1$d/", z + z_offset);
                    JSONStr = JSONStr + "\", \"height\": ";
                    JSONStr = JSONStr + String.format("%1$d", maxY);
                    JSONStr = JSONStr + ", \"width\": ";
                    JSONStr = JSONStr + String.format("%1$d", maxX);
                    JSONStr = JSONStr + "},\n";
                    IJ.log((String)String.format("SliceNumber=%1$d, z=%2d", ip_scaledimage.getSliceNumber(), z));
                    for (int cx = 0; cx < maxX; ++cx) {
                        ImageProcessor proc1 = scaledimage.getStack().getProcessor(z + 1);
                        ip_crossimg.setf(cx, z, proc1.getf(cx, maxY / 2));
                    }
                }
                for (int x = 0; x < maxX; x += stepX) {
                    for (int y = 0; y < maxY; y += stepY) {
                        xs = stepX;
                        ys = stepY;
                        zs = stepZ;
                        x1 = x;
                        y1 = y;
                        z1 = z;
                        x2 = x1 + xs;
                        if (x2 > maxX) {
                            xs = maxX - x1;
                        }
                        if ((y2 = y1 + ys) > maxY) {
                            ys = maxY - y1;
                        }
                        if ((z2 = z1 + zs) > maxZ) {
                            zs = maxZ - z1;
                        }
                        Roi tempRoi = new Roi(x1, y1, xs, ys);
                        scaledimage.setRoi(tempRoi);
                        ip_scaledimage.setRoi(tempRoi);
                        ImagePlus imgblock = new Duplicator().run(scaledimage, z1 + 1, z1 + zs);
                        String directoryout = String.format("%1$s\\%2$d", BC_outDirectory, z + z_offset);
                        String fileout = String.format("%1$s\\%2$d\\%3$d-%5$d-%4$d.jpg", BC_outDirectory, z + z_offset, zoomlevel, y / ys, x / xs);
                        File file = new File(directoryout);
                        if (!file.exists() && !file.mkdirs()) {
                            System.out.println("Failed to create directory!");
                        }
                        IJ.saveAs((ImagePlus)imgblock, (String)"jpg", (String)fileout);
                        IJ.showStatus((String)"Creating tiles...");
                        IJ.showProgress((int)(maxZoomlevel - zoomlevel + 1), (int)(maxZoomlevel + 3));
                        IJ.log((String)("saved " + fileout));
                        imgblock = null;
                    }
                }
            }
        }
        scaledimage.changes = false;
        scaledimage.close();
        JSONStr = JSONStr + "]\n";
        ip_crossimg = ip_crossimg.resize((int)((double)tWidth / Math.pow(2.0, maxZoomlevel)), (int)((double)maxZ / Math.pow(2.0, maxZoomlevel)));
        crossimg = new ImagePlus("cross-section", ip_crossimg);
        IJ.saveAs((ImagePlus)crossimg, (String)"jpg", (String)(BC_outDirectory + "\\tc.jpg"));
        if (saveProp) {
            JSONStr = JSONStr + "}";
            try {
                PrintWriter out = new PrintWriter(BC_outDirectory + "\\infoJSON.txt");
                out.println(JSONStr);
                out.close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        IJ.showStatus((String)"Blocks have been saved!");
        IJ.showProgress((int)100, (int)100);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.filebtn) {
            JFileChooser chooser = new JFileChooser(LJPrefs.LJ_clsDirectory);
            chooser.setFileSelectionMode(1);
            chooser.setSelectedFile(new File(BC_outDirectory));
            int returnVal = chooser.showDialog((Component)this.gd, "Choose Output");
            if (returnVal == 0) {
                this.outdirtxt.setText(chooser.getSelectedFile().getPath());
            }
        }
    }
}

