/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import lj.LJPrefs;

public class Create_Threshold_Mask
implements ExtendedPlugInFilter,
DialogListener {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private static double LJ_threshold = LJPrefs.LJ_threshold;
    private boolean previewing = false;
    private FloatProcessor previewEdm;
    private double globMin = 0.0;
    private double globMax = 1.0;
    private static final byte BYTE_ZERO = 0;
    private static final byte BYTE_ONE = 1;
    private static final short SHORT_ZERO = Short.MIN_VALUE;
    private static final short SHORT_ONE = -32767;
    private static final float FLOAT_ZERO = 0.0f;
    private static final float FLOAT_ONE = 1.0f;
    private int flags = 98381;
    ImagePlus gimp;

    public int setup(String arg, ImagePlus imp) {
        if (IJ.versionLessThan((String)"1.48n")) {
            return 4096;
        }
        if (arg == "final") {
            if (this.previewing) {
                if (imp.getProcessor().getBitDepth() == 8) {
                    ImageProcessor ip = imp.getProcessor();
                    Rectangle roiRect = ip.getRoi();
                    int width = ip.getWidth();
                    byte[] bPixels = (byte[])ip.getPixels();
                    for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                        int x = roiRect.x;
                        int p = x + y * width;
                        while (x < roiRect.x + roiRect.width) {
                            if (bPixels[p] == -1) {
                                bPixels[p] = 1;
                            }
                            ++x;
                            ++p;
                        }
                    }
                } else if (imp.getProcessor().getBitDepth() == 16) {
                    ImageProcessor ip = imp.getProcessor();
                    Rectangle roiRect = ip.getRoi();
                    int width = ip.getWidth();
                    short[] bPixels = (short[])ip.getPixels();
                    for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                        int x = roiRect.x;
                        int p = x + y * width;
                        while (x < roiRect.x + roiRect.width) {
                            bPixels[p] = bPixels[p] == (short)this.globMax ? -32767 : Short.MIN_VALUE;
                            ++x;
                            ++p;
                        }
                    }
                } else if (imp.getProcessor().getBitDepth() == 32) {
                    ImageProcessor ip = imp.getProcessor();
                    Rectangle roiRect = ip.getRoi();
                    int width = ip.getWidth();
                    float[] bPixels = (float[])ip.getPixels();
                    for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                        int x = roiRect.x;
                        int p = x + y * width;
                        while (x < roiRect.x + roiRect.width) {
                            bPixels[p] = bPixels[p] == (float)this.globMax ? 1.0f : 0.0f;
                            ++x;
                            ++p;
                        }
                    }
                }
            }
            IJ.setMinAndMax((double)0.0, (double)1.0);
            IJ.setThreshold((double)0.0, (double)0.5, (String)"BLACK_AND_WHITE_LUT");
        }
        this.gimp = imp;
        return this.flags;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        float[] minmax = new float[2];
        minmax = LJPrefs.getMinMax(imp);
        this.globMin = minmax[0];
        this.globMax = minmax[1];
        GenericDialog gd = new GenericDialog(command + "...");
        gd.addSlider("Threshold (in %)", 0.0, 100.0, LJ_threshold * 100.0);
        gd.addNumericField("minimum Value", this.globMin, 4);
        gd.addNumericField("maximum Value", this.globMax, 4);
        gd.addPreviewCheckbox(pfr);
        gd.addDialogListener((DialogListener)this);
        this.previewing = true;
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        this.previewing = false;
        if (gd.wasCanceled()) {
            return 4096;
        }
        IJ.register(this.getClass());
        return IJ.setupDialog((ImagePlus)imp, (int)this.flags);
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        LJ_threshold = gd.getNextNumber() / 100.0;
        this.globMin = gd.getNextNumber();
        this.globMax = gd.getNextNumber();
        return !gd.invalidNumber() && LJ_threshold >= 0.0 && LJ_threshold <= 1.0;
    }

    public void run(ImageProcessor ip) {
        FloatProcessor floatIP;
        int width = ip.getWidth();
        int height = ip.getHeight();
        if (this.previewing && this.previewEdm != null) {
            floatIP = this.previewEdm;
        } else {
            this.previewEdm = floatIP = new FloatProcessor(width, height, (float[])ip.convertToFloat().getPixels());
        }
        float[] fPixels = (float[])floatIP.getPixels();
        Rectangle roiRect = ip.getRoi();
        if (ip.getBitDepth() == 8) {
            byte[] bPixels = (byte[])ip.getPixels();
            bPixels = this.threshold(bPixels, fPixels, roiRect, width);
        } else if (ip.getBitDepth() == 16) {
            short[] bPixels = (short[])ip.getPixels();
            bPixels = this.threshold(bPixels, fPixels, roiRect, width);
        } else if (ip.getBitDepth() == 32) {
            float[] bPixels = (float[])ip.getPixels();
            bPixels = this.threshold(bPixels, fPixels, roiRect, width);
        }
    }

    public void setNPasses(int nPasses) {
    }

    private byte[] threshold(byte[] bPixels, float[] fPixels, Rectangle roiRect, int width) {
        for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
            int x = roiRect.x;
            int p = x + y * width;
            while (x < roiRect.x + roiRect.width) {
                bPixels[p] = fPixels[p] <= (float)(255.0 * LJ_threshold) ? 0 : (this.previewing ? -1 : 1);
                ++x;
                ++p;
            }
        }
        return bPixels;
    }

    private short[] threshold(short[] bPixels, float[] fPixels, Rectangle roiRect, int width) {
        double tmin = this.globMin;
        double tmax = this.globMax;
        float bound = (float)(tmin + (tmax - tmin) * LJ_threshold);
        for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
            int x = roiRect.x;
            int p = x + y * width;
            while (x < roiRect.x + roiRect.width) {
                bPixels[p] = fPixels[p] <= bound && this.previewing ? (int)((int)(1.0 + tmin + 32767.0)) : (fPixels[p] <= bound ? Short.MIN_VALUE : (this.previewing ? (int)((int)(1.0 + tmax + 32767.0)) : -32767));
                ++x;
                ++p;
            }
        }
        return bPixels;
    }

    private float[] threshold(float[] bPixels, float[] fPixels, Rectangle roiRect, int width) {
        double tmin = this.globMin;
        double tmax = this.globMax;
        float bound = (float)(tmin + (tmax - tmin) * LJ_threshold);
        for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
            int x = roiRect.x;
            int p = x + y * width;
            while (x < roiRect.x + roiRect.width) {
                bPixels[p] = fPixels[p] <= bound && this.previewing ? (float)tmin : (fPixels[p] <= bound ? 0.0f : (this.previewing ? (float)tmax : 1.0f));
                ++x;
                ++p;
            }
        }
        return bPixels;
    }
}

