/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import lj.LJPrefs;

public class Fill_Holes_Manual_3D
implements PlugInFilter {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    private boolean previewing = false;
    private FloatProcessor previewEdm;
    private double globMin = 0.0;
    private double globMax = 1.0;
    private int flags = 98349;

    public int setup(String arg, ImagePlus imp) {
        if (IJ.versionLessThan((String)"1.48n")) {
            return 4096;
        }
        if (imp == null) {
            return 4096;
        }
        if (arg != "final") {
            float[] minmax = new float[2];
            minmax = LJPrefs.getMinMax(imp);
            this.globMin = minmax[0];
            this.globMax = minmax[1];
        }
        return this.flags;
    }

    public void run(ImageProcessor ip) {
        block9: {
            Rectangle roiRect;
            float[] fPixels;
            int width;
            block10: {
                block8: {
                    FloatProcessor floatIP;
                    width = ip.getWidth();
                    int height = ip.getHeight();
                    if (this.previewing && this.previewEdm != null) {
                        floatIP = this.previewEdm;
                    } else {
                        this.previewEdm = floatIP = new FloatProcessor(width, height, (float[])ip.convertToFloat().getPixels());
                    }
                    fPixels = (float[])floatIP.getPixels();
                    roiRect = ip.getRoi();
                    if (ip.getBitDepth() != 8) break block8;
                    byte[] bPixels = (byte[])ip.getPixels();
                    for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                        int x = roiRect.x;
                        int p = x + y * width;
                        while (x < roiRect.x + roiRect.width) {
                            bPixels[p] = fPixels[p] == 255.0f ? -1 : (fPixels[p] == 0.0f ? -1 : 0);
                            ++x;
                            ++p;
                        }
                    }
                    break block9;
                }
                if (ip.getBitDepth() != 16) break block10;
                short[] bPixels = (short[])ip.getPixels();
                double tmin = this.globMin;
                double tmax = this.globMax;
                for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                    int x = roiRect.x;
                    int p = x + y * width;
                    while (x < roiRect.x + roiRect.width) {
                        bPixels[p] = fPixels[p] == (float)tmax ? (short)tmax : (fPixels[p] == (float)tmin ? (short)tmax : (short)tmin);
                        ++x;
                        ++p;
                    }
                }
                break block9;
            }
            if (ip.getBitDepth() != 32) break block9;
            float[] bPixels = (float[])ip.getPixels();
            double tmin = this.globMin;
            double tmax = this.globMax;
            for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                int x = roiRect.x;
                int p = x + y * width;
                while (x < roiRect.x + roiRect.width) {
                    bPixels[p] = fPixels[p] == (float)tmax ? (float)tmax : (fPixels[p] == (float)tmin ? (float)tmax : (float)tmin);
                    ++x;
                    ++p;
                }
            }
        }
    }

    public void setNPasses(int nPasses) {
    }
}

