/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.IOException;
import java.util.Properties;
import lj.LJPrefs;

public class Halo_Exchange
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private static String BC_inDirectory = LJPrefs.LJ_inpDirectory;
    private static String BC_outDirectory = LJPrefs.LJ_outDirectory;
    private static int maxX = 1;
    private static int maxY = 1;
    private static int maxZ = 1;
    private static int stepX = 1;
    private static int stepY = 1;
    private static int stepZ = 1;
    private static int haloX = 0;
    private static int haloY = 0;
    private static int haloZ = 0;
    private static float globMaxIn = -3.4028235E38f;
    private static float globMinIn = Float.MAX_VALUE;
    private static int moveX = 1;
    private static int moveY = 1;
    private static int moveZ = 1;
    private static int tempX1 = 0;
    private static int tempX2 = 0;
    private static int tempY1 = 0;
    private static int tempY2 = 0;
    private static int tempZ1 = 0;
    private static int tempZ2 = 0;
    private static int xs1 = 0;
    private static int xs2 = stepX;
    private static int ys1 = 0;
    private static int ys2 = stepY;
    private static int zs1 = 0;
    private static int zs2 = stepZ;
    private static int[] configuration = new int[]{0, 0, 0};
    private static String filein111 = "";
    private static String fileout111 = "";
    private static ImagePlus img111 = null;
    private static String filein112 = "";
    private static String fileout112 = "";
    private static ImagePlus img112 = null;
    private static String filein121 = "";
    private static String fileout121 = "";
    private static ImagePlus img121 = null;
    private static String filein122 = "";
    private static String fileout122 = "";
    private static ImagePlus img122 = null;
    private static String filein211 = "";
    private static String fileout211 = "";
    private static ImagePlus img211 = null;
    private static String filein212 = "";
    private static String fileout212 = "";
    private static ImagePlus img212 = null;
    private static String filein221 = "";
    private static String fileout221 = "";
    private static ImagePlus img221 = null;
    private static String filein222 = "";
    private static String fileout222 = "";
    private static ImagePlus img222 = null;
    private static Boolean[] requireClean = new Boolean[]{false, false, false};

    public void run(String command) {
        GenericDialog gd = new GenericDialog(command + " exchange halos");
        gd.addStringField("Input directory", BC_inDirectory, 100);
        gd.addStringField("Output directory", BC_outDirectory, 100);
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        BC_inDirectory = gd.getNextString();
        BC_outDirectory = gd.getNextString();
        LJPrefs.LJ_inpDirectory = BC_inDirectory;
        LJPrefs.LJ_outDirectory = BC_outDirectory;
        LJPrefs.savePreferences();
        Properties prefs = new Properties();
        try {
            prefs = LJPrefs.readProperties(BC_inDirectory + "\\properties.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        maxX = LJPrefs.getPref(prefs, "maxX", maxX);
        maxY = LJPrefs.getPref(prefs, "maxY", maxY);
        maxZ = LJPrefs.getPref(prefs, "maxZ", maxZ);
        stepX = LJPrefs.getPref(prefs, "stepX", stepX);
        stepY = LJPrefs.getPref(prefs, "stepY", stepY);
        stepZ = LJPrefs.getPref(prefs, "stepZ", stepZ);
        haloX = LJPrefs.getPref(prefs, "haloX", haloX);
        haloY = LJPrefs.getPref(prefs, "haloY", haloY);
        haloZ = LJPrefs.getPref(prefs, "haloZ", haloZ);
        globMinIn = (float)LJPrefs.getPref(prefs, "minVal", globMinIn);
        globMaxIn = (float)LJPrefs.getPref(prefs, "maxVal", globMaxIn);
        xs1 = 0;
        xs2 = stepX;
        ys1 = 0;
        ys2 = stepY;
        zs1 = 0;
        zs2 = stepZ;
        filein111 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys1, xs1);
        fileout111 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys1, xs1);
        img111 = IJ.openImage((String)filein111);
        filein112 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys1, xs2);
        fileout112 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys1, xs2);
        img112 = IJ.openImage((String)filein112);
        filein121 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys2, xs1);
        fileout121 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys2, xs1);
        img121 = IJ.openImage((String)filein121);
        filein122 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys2, xs2);
        fileout122 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys2, xs2);
        img122 = IJ.openImage((String)filein122);
        filein211 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys1, xs1);
        fileout211 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys1, xs1);
        img211 = IJ.openImage((String)filein211);
        filein212 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys1, xs2);
        fileout212 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys1, xs2);
        img212 = IJ.openImage((String)filein212);
        filein221 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys2, xs1);
        fileout221 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys2, xs1);
        img221 = IJ.openImage((String)filein221);
        filein222 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys2, xs2);
        fileout222 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys2, xs2);
        img222 = IJ.openImage((String)filein222);
        this.doexchangetype000();
        moveX = 1;
        moveY = 1;
        moveZ = 1;
        while (moveZ == 1) {
            if (xs1 + moveX * stepX < maxX && xs2 + moveX * stepX < maxX && xs1 + moveX * stepX >= 0 && xs2 + moveX * stepX >= 0) {
                this.docleanexchange();
                this.move(2);
                this.doexchange();
                if (xs1 + moveX * stepX >= maxX || xs2 + moveX * stepX >= maxX) {
                    Halo_Exchange.requireClean[2] = true;
                    continue;
                }
                Halo_Exchange.requireClean[2] = false;
                continue;
            }
            if (ys1 + moveY * stepY < maxY && ys2 + moveY * stepY < maxY && ys1 + moveY * stepY >= 0 && ys2 + moveY * stepY >= 0) {
                this.docleanexchange();
                this.move(1);
                this.doexchange();
                Halo_Exchange.requireClean[1] = ys1 + moveY * stepY >= maxY || ys2 + moveY * stepY >= maxY ? Boolean.valueOf(true) : Boolean.valueOf(false);
            } else {
                if (zs1 + stepZ < maxZ && zs2 + stepZ < maxZ) {
                    this.docleanexchange();
                    this.move(0);
                    this.doexchange();
                    Halo_Exchange.requireClean[0] = zs1 + stepZ >= maxZ || zs2 + stepZ >= maxZ ? Boolean.valueOf(true) : Boolean.valueOf(false);
                } else {
                    this.docleanexchange();
                    moveZ *= -1;
                }
                moveY *= -1;
            }
            moveX *= -1;
        }
        IJ.saveAsTiff((ImagePlus)img111, (String)fileout111);
        IJ.saveAsTiff((ImagePlus)img112, (String)fileout112);
        IJ.saveAsTiff((ImagePlus)img121, (String)fileout121);
        IJ.saveAsTiff((ImagePlus)img122, (String)fileout122);
        IJ.saveAsTiff((ImagePlus)img211, (String)fileout211);
        IJ.saveAsTiff((ImagePlus)img212, (String)fileout212);
        IJ.saveAsTiff((ImagePlus)img221, (String)fileout221);
        IJ.saveAsTiff((ImagePlus)img222, (String)fileout222);
        img111 = null;
        img112 = null;
        img121 = null;
        img122 = null;
        img211 = null;
        img212 = null;
        img221 = null;
        img222 = null;
        IJ.showProgress((int)100, (int)100);
    }

    private void move(int axis) {
        int inverted = configuration[axis];
        if (axis == 2) {
            if (inverted == 0 && moveX == 1 || inverted == 1 && moveX == -1) {
                xs1 += moveX * 2 * stepX;
                IJ.saveAsTiff((ImagePlus)img111, (String)fileout111);
                IJ.saveAsTiff((ImagePlus)img121, (String)fileout121);
                IJ.saveAsTiff((ImagePlus)img211, (String)fileout211);
                IJ.saveAsTiff((ImagePlus)img221, (String)fileout221);
                filein111 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys1, xs1);
                fileout111 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys1, xs1);
                img111 = IJ.openImage((String)filein111);
                filein121 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys2, xs1);
                fileout121 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys2, xs1);
                img121 = IJ.openImage((String)filein121);
                filein211 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys1, xs1);
                fileout211 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys1, xs1);
                img211 = IJ.openImage((String)filein211);
                filein221 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys2, xs1);
                fileout221 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys2, xs1);
                img221 = IJ.openImage((String)filein221);
            } else {
                xs2 += moveX * 2 * stepX;
                IJ.saveAsTiff((ImagePlus)img112, (String)fileout112);
                IJ.saveAsTiff((ImagePlus)img122, (String)fileout122);
                IJ.saveAsTiff((ImagePlus)img212, (String)fileout212);
                IJ.saveAsTiff((ImagePlus)img222, (String)fileout222);
                filein112 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys1, xs2);
                fileout112 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys1, xs2);
                img112 = IJ.openImage((String)filein112);
                filein122 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys2, xs2);
                fileout122 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys2, xs2);
                img122 = IJ.openImage((String)filein122);
                filein212 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys1, xs2);
                fileout212 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys1, xs2);
                img212 = IJ.openImage((String)filein212);
                filein222 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys2, xs2);
                fileout222 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys2, xs2);
                img222 = IJ.openImage((String)filein222);
            }
        } else if (axis == 1) {
            if (inverted == 0 && moveY == 1 || inverted == 1 && moveY == -1) {
                ys1 += moveY * 2 * stepY;
                IJ.saveAsTiff((ImagePlus)img111, (String)fileout111);
                IJ.saveAsTiff((ImagePlus)img112, (String)fileout112);
                IJ.saveAsTiff((ImagePlus)img211, (String)fileout211);
                IJ.saveAsTiff((ImagePlus)img212, (String)fileout212);
                filein111 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys1, xs1);
                fileout111 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys1, xs1);
                img111 = IJ.openImage((String)filein111);
                filein112 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys1, xs2);
                fileout112 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys1, xs2);
                img112 = IJ.openImage((String)filein112);
                filein211 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys1, xs1);
                fileout211 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys1, xs1);
                img211 = IJ.openImage((String)filein211);
                filein212 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys1, xs2);
                fileout212 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys1, xs2);
                img212 = IJ.openImage((String)filein212);
            } else {
                ys2 += moveY * 2 * stepY;
                IJ.saveAsTiff((ImagePlus)img121, (String)fileout121);
                IJ.saveAsTiff((ImagePlus)img122, (String)fileout122);
                IJ.saveAsTiff((ImagePlus)img221, (String)fileout221);
                IJ.saveAsTiff((ImagePlus)img222, (String)fileout222);
                filein121 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys2, xs1);
                fileout121 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys2, xs1);
                img121 = IJ.openImage((String)filein121);
                filein122 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys2, xs2);
                fileout122 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys2, xs2);
                img122 = IJ.openImage((String)filein122);
                filein221 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys2, xs1);
                fileout221 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys2, xs1);
                img221 = IJ.openImage((String)filein221);
                filein222 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys2, xs2);
                fileout222 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys2, xs2);
                img222 = IJ.openImage((String)filein222);
            }
        } else if (inverted == 0) {
            zs1 += moveZ * 2 * stepZ;
            IJ.saveAsTiff((ImagePlus)img111, (String)fileout111);
            IJ.saveAsTiff((ImagePlus)img112, (String)fileout112);
            IJ.saveAsTiff((ImagePlus)img121, (String)fileout121);
            IJ.saveAsTiff((ImagePlus)img122, (String)fileout122);
            filein111 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys1, xs1);
            fileout111 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys1, xs1);
            img111 = IJ.openImage((String)filein111);
            filein112 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys1, xs2);
            fileout112 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys1, xs2);
            img112 = IJ.openImage((String)filein112);
            filein121 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys2, xs1);
            fileout121 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys2, xs1);
            img121 = IJ.openImage((String)filein121);
            filein122 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs1, ys2, xs2);
            fileout122 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs1, ys2, xs2);
            img122 = IJ.openImage((String)filein122);
        } else {
            zs2 += moveZ * 2 * stepZ;
            IJ.saveAsTiff((ImagePlus)img211, (String)fileout211);
            IJ.saveAsTiff((ImagePlus)img212, (String)fileout212);
            IJ.saveAsTiff((ImagePlus)img221, (String)fileout221);
            IJ.saveAsTiff((ImagePlus)img222, (String)fileout222);
            filein211 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys1, xs1);
            fileout211 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys1, xs1);
            img211 = IJ.openImage((String)filein211);
            filein212 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys1, xs2);
            fileout212 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys1, xs2);
            img212 = IJ.openImage((String)filein212);
            filein221 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys2, xs1);
            fileout221 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys2, xs1);
            img221 = IJ.openImage((String)filein221);
            filein222 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, zs2, ys2, xs2);
            fileout222 = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, zs2, ys2, xs2);
            img222 = IJ.openImage((String)filein222);
        }
        Halo_Exchange.configuration[axis] = 1 - inverted;
    }

    private void doexchange() {
        IJ.log((String)(String.valueOf(configuration[0]) + String.valueOf(configuration[1]) + String.valueOf(configuration[2])));
        if (configuration[0] == 0) {
            if (configuration[1] == 0) {
                if (configuration[2] == 0) {
                    this.doexchangetype000();
                } else {
                    this.doexchangetype001();
                }
            } else if (configuration[2] == 0) {
                this.doexchangetype010();
            } else {
                this.doexchangetype011();
            }
        } else if (configuration[1] == 0) {
            if (configuration[2] == 0) {
                this.doexchangetype100();
            } else {
                this.doexchangetype101();
            }
        } else if (configuration[2] == 0) {
            this.doexchangetype110();
        } else {
            this.doexchangetype111();
        }
    }

    private void doexchangetype000() {
        int yb;
        int ybo;
        int yao;
        int y;
        int xb;
        int xbo;
        int xao;
        int x;
        int yb2;
        int ybo2;
        int yao2;
        int y2;
        int xb2;
        int xbo2;
        int xao2;
        int x2;
        int y3;
        int x3;
        ImageProcessor proc1;
        int y4;
        int x4;
        ImageProcessor proc2;
        int z;
        IJ.log((String)"---000--------------");
        IJ.log((String)(filein111 + "|" + filein112));
        IJ.log((String)(filein121 + "|" + filein122));
        IJ.log((String)"--------------------");
        tempX1 = img111.getWidth() - 2 * haloX;
        tempX2 = img111.getWidth() - haloX;
        tempY1 = img111.getHeight() - haloY - stepY;
        tempY2 = img111.getHeight() - haloY;
        tempZ1 = img111.getStackSize() - haloZ - stepZ;
        tempZ2 = img111.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            ImageProcessor proc12 = img111.getStack().getProcessor(z);
            proc2 = img112.getStack().getProcessor(z);
            x4 = tempX1;
            int xao3 = 0;
            int xbo3 = haloX;
            int xb3 = tempX2;
            while (x4 < tempX2) {
                for (y4 = tempY1; y4 < tempY2; ++y4) {
                    proc2.set(xao3, y4, proc12.get(x4, y4));
                    proc12.set(xb3, y4, proc2.get(xbo3, y4));
                }
                ++x4;
                ++xb3;
                ++xao3;
                ++xbo3;
            }
        }
        tempX1 = img111.getWidth() - haloX - stepX;
        tempX2 = img111.getWidth() - haloX;
        tempY1 = img111.getHeight() - 2 * haloY;
        tempY2 = img111.getHeight() - haloY;
        tempZ1 = img111.getStackSize() - haloZ - stepZ;
        tempZ2 = img111.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            ImageProcessor proc11 = img111.getStack().getProcessor(z);
            ImageProcessor proc21 = img121.getStack().getProcessor(z);
            for (x4 = tempX1; x4 < tempX2; ++x4) {
                int y5 = tempY1;
                int yao3 = 0;
                int ybo3 = haloY;
                int yb3 = tempY2;
                while (y5 < tempY2) {
                    proc21.set(x4, yao3, proc11.get(x4, y5));
                    proc11.set(x4, yb3, proc21.get(x4, ybo3));
                    ++y5;
                    ++yb3;
                    ++yao3;
                    ++ybo3;
                }
            }
        }
        tempX1 = img111.getWidth() - haloX - stepX;
        tempX2 = img111.getWidth() - haloX;
        tempY1 = img111.getHeight() - haloY - stepY;
        tempY2 = img111.getHeight() - haloY;
        tempZ1 = img111.getStackSize() - 2 * haloZ;
        tempZ2 = img111.getStackSize() - haloZ;
        z = tempZ1 + 1;
        int zao = 1;
        while (z <= tempZ2) {
            proc1 = img111.getStack().getProcessor(z);
            ImageProcessor proc22 = img211.getStack().getProcessor(zao);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc22.set(x3, y3, proc1.get(x3, y3));
                }
            }
            ++z;
            ++zao;
        }
        int zb = tempZ2 + 1;
        int zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img111.getStack().getProcessor(zb);
            ImageProcessor proc23 = img211.getStack().getProcessor(zbo);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc1.set(x3, y3, proc23.get(x3, y3));
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img111.getWidth() - 2 * haloX;
        tempX2 = img111.getWidth() - haloX;
        tempY1 = img111.getHeight() - 2 * haloY;
        tempY2 = img111.getHeight() - haloY;
        tempZ1 = img111.getStackSize() - haloZ - stepZ;
        tempZ2 = img111.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            ImageProcessor proc13 = img111.getStack().getProcessor(z);
            proc2 = img122.getStack().getProcessor(z);
            ImageProcessor proc1v = img112.getStack().getProcessor(z);
            ImageProcessor proc2v = img121.getStack().getProcessor(z);
            int x5 = tempX1;
            int xao4 = 0;
            int xbo4 = haloX;
            int xb4 = tempX2;
            while (x5 < tempX2) {
                int y6 = tempY1;
                int yao4 = 0;
                int ybo4 = haloY;
                int yb4 = tempY2;
                while (y6 < tempY2) {
                    proc2.set(xao4, yao4, proc13.get(x5, y6));
                    proc13.set(xb4, yb4, proc2.get(xbo4, ybo4));
                    proc2v.set(xb4, yao4, proc1v.get(xbo4, y6));
                    proc1v.set(xao4, yb4, proc2v.get(x5, ybo4));
                    ++y6;
                    ++yb4;
                    ++yao4;
                    ++ybo4;
                }
                ++x5;
                ++xb4;
                ++xao4;
                ++xbo4;
            }
        }
        tempX1 = img111.getWidth() - 2 * haloX;
        tempX2 = img111.getWidth() - haloX;
        tempY1 = img111.getHeight() - haloY - stepY;
        tempY2 = img111.getHeight() - haloY;
        tempZ1 = img111.getStackSize() - 2 * haloZ;
        tempZ2 = img111.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img111.getStack().getProcessor(z);
            ImageProcessor proc24 = img212.getStack().getProcessor(zao);
            ImageProcessor proc1v = img112.getStack().getProcessor(z);
            ImageProcessor proc2v = img211.getStack().getProcessor(zao);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc24.set(xao2, y2, proc1.get(x2, y2));
                    proc2v.set(xb2, y2, proc1v.get(xbo2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img111.getStack().getProcessor(zb);
            ImageProcessor proc25 = img212.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img112.getStack().getProcessor(zb);
            ImageProcessor proc2v = img211.getStack().getProcessor(zbo);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc1.set(xb2, y2, proc25.get(xbo2, y2));
                    proc1v.set(xao2, y2, proc2v.get(x2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img111.getWidth() - haloX - stepX;
        tempX2 = img111.getWidth() - haloX;
        tempY1 = img111.getHeight() - 2 * haloY;
        tempY2 = img111.getHeight() - haloY;
        tempZ1 = img111.getStackSize() - 2 * haloZ;
        tempZ2 = img111.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img111.getStack().getProcessor(z);
            ImageProcessor proc26 = img221.getStack().getProcessor(zao);
            ImageProcessor proc1v = img121.getStack().getProcessor(z);
            ImageProcessor proc2v = img211.getStack().getProcessor(zao);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc26.set(x2, yao2, proc1.get(x2, y4));
                    proc2v.set(x2, yb2, proc1v.get(x2, ybo2));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img111.getStack().getProcessor(zb);
            ImageProcessor proc27 = img221.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img121.getStack().getProcessor(zb);
            ImageProcessor proc2v = img211.getStack().getProcessor(zbo);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc1.set(x2, yb2, proc27.get(x2, ybo2));
                    proc1v.set(x2, yao2, proc2v.get(x2, y4));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img111.getWidth() - 2 * haloX;
        tempX2 = img111.getWidth() - haloX;
        tempY1 = img111.getHeight() - 2 * haloY;
        tempY2 = img111.getHeight() - haloY;
        tempZ1 = img111.getStackSize() - 2 * haloZ;
        tempZ2 = img111.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        int zb2 = tempZ2 + 1;
        int zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc14 = img111.getStack().getProcessor(z);
            ImageProcessor proc28 = img222.getStack().getProcessor(zao);
            ImageProcessor proc1v1 = img112.getStack().getProcessor(z);
            ImageProcessor proc2v1 = img221.getStack().getProcessor(zao);
            ImageProcessor proc1v2 = img121.getStack().getProcessor(z);
            ImageProcessor proc2v2 = img212.getStack().getProcessor(zao);
            ImageProcessor proc1v3 = img122.getStack().getProcessor(z);
            ImageProcessor proc2v3 = img211.getStack().getProcessor(zao);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc28.set(xao, yao, proc14.get(x, y));
                    proc2v1.set(xb, yao, proc1v1.get(xbo, y));
                    proc2v2.set(xao, yb, proc1v2.get(x, ybo));
                    proc2v3.set(xb, yb, proc1v3.get(xbo, ybo));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
        z = tempZ1 + 1;
        zao = 1;
        zb2 = tempZ2 + 1;
        zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc15 = img111.getStack().getProcessor(zb2);
            ImageProcessor proc29 = img222.getStack().getProcessor(zbo2);
            ImageProcessor proc1v1 = img112.getStack().getProcessor(zb2);
            ImageProcessor proc2v1 = img221.getStack().getProcessor(zbo2);
            ImageProcessor proc1v2 = img121.getStack().getProcessor(zb2);
            ImageProcessor proc2v2 = img212.getStack().getProcessor(zbo2);
            ImageProcessor proc1v3 = img122.getStack().getProcessor(zb2);
            ImageProcessor proc2v3 = img211.getStack().getProcessor(zbo2);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc15.set(xb, yb, proc29.get(xbo, ybo));
                    proc1v1.set(xao, yb, proc2v1.get(x, ybo));
                    proc1v2.set(xb, yao, proc2v2.get(xbo, y));
                    proc1v3.set(xao, yao, proc2v3.get(x, y));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
    }

    private void doexchangetype001() {
        int yb;
        int ybo;
        int yao;
        int y;
        int xb;
        int xbo;
        int xao;
        int x;
        int yb2;
        int ybo2;
        int yao2;
        int y2;
        int xb2;
        int xbo2;
        int xao2;
        int x2;
        int y3;
        int x3;
        ImageProcessor proc1;
        int y4;
        int x4;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int z;
        IJ.log((String)"---001--------------");
        IJ.log((String)(filein112 + "|" + filein111));
        IJ.log((String)(filein122 + "|" + filein121));
        IJ.log((String)"--------------------");
        tempX1 = img112.getWidth() - 2 * haloX;
        tempX2 = img112.getWidth() - haloX;
        tempY1 = img112.getHeight() - haloY - stepY;
        tempY2 = img112.getHeight() - haloY;
        tempZ1 = img112.getStackSize() - haloZ - stepZ;
        tempZ2 = img112.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img112.getStack().getProcessor(z);
            proc2 = img111.getStack().getProcessor(z);
            x4 = tempX1;
            int xao3 = 0;
            int xbo3 = haloX;
            int xb3 = tempX2;
            while (x4 < tempX2) {
                for (y4 = tempY1; y4 < tempY2; ++y4) {
                    proc2.set(xao3, y4, proc12.get(x4, y4));
                    proc12.set(xb3, y4, proc2.get(xbo3, y4));
                }
                ++x4;
                ++xb3;
                ++xao3;
                ++xbo3;
            }
        }
        tempX1 = img112.getWidth() - haloX - stepX;
        tempX2 = img112.getWidth() - haloX;
        tempY1 = img112.getHeight() - 2 * haloY;
        tempY2 = img112.getHeight() - haloY;
        tempZ1 = img112.getStackSize() - haloZ - stepZ;
        tempZ2 = img112.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img112.getStack().getProcessor(z);
            proc2 = img122.getStack().getProcessor(z);
            for (x4 = tempX1; x4 < tempX2; ++x4) {
                int y5 = tempY1;
                int yao3 = 0;
                int ybo3 = haloY;
                int yb3 = tempY2;
                while (y5 < tempY2) {
                    proc2.set(x4, yao3, proc12.get(x4, y5));
                    proc12.set(x4, yb3, proc2.get(x4, ybo3));
                    ++y5;
                    ++yb3;
                    ++yao3;
                    ++ybo3;
                }
            }
        }
        tempX1 = img112.getWidth() - haloX - stepX;
        tempX2 = img112.getWidth() - haloX;
        tempY1 = img112.getHeight() - haloY - stepY;
        tempY2 = img112.getHeight() - haloY;
        tempZ1 = img112.getStackSize() - 2 * haloZ;
        tempZ2 = img112.getStackSize() - haloZ;
        z = tempZ1 + 1;
        int zao = 1;
        while (z <= tempZ2) {
            proc1 = img112.getStack().getProcessor(z);
            ImageProcessor proc22 = img212.getStack().getProcessor(zao);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc22.set(x3, y3, proc1.get(x3, y3));
                }
            }
            ++z;
            ++zao;
        }
        int zb = tempZ2 + 1;
        int zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img112.getStack().getProcessor(zb);
            ImageProcessor proc23 = img212.getStack().getProcessor(zbo);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc1.set(x3, y3, proc23.get(x3, y3));
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img112.getWidth() - 2 * haloX;
        tempX2 = img112.getWidth() - haloX;
        tempY1 = img112.getHeight() - 2 * haloY;
        tempY2 = img112.getHeight() - haloY;
        tempZ1 = img112.getStackSize() - haloZ - stepZ;
        tempZ2 = img112.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            ImageProcessor proc13 = img112.getStack().getProcessor(z);
            proc2 = img121.getStack().getProcessor(z);
            ImageProcessor proc1v = img111.getStack().getProcessor(z);
            ImageProcessor proc2v = img122.getStack().getProcessor(z);
            int x5 = tempX1;
            int xao4 = 0;
            int xbo4 = haloX;
            int xb4 = tempX2;
            while (x5 < tempX2) {
                int y6 = tempY1;
                int yao4 = 0;
                int ybo4 = haloY;
                int yb4 = tempY2;
                while (y6 < tempY2) {
                    proc2.set(xao4, yao4, proc13.get(x5, y6));
                    proc13.set(xb4, yb4, proc2.get(xbo4, ybo4));
                    proc2v.set(xb4, yao4, proc1v.get(xbo4, y6));
                    proc1v.set(xao4, yb4, proc2v.get(x5, ybo4));
                    ++y6;
                    ++yb4;
                    ++yao4;
                    ++ybo4;
                }
                ++x5;
                ++xb4;
                ++xao4;
                ++xbo4;
            }
        }
        tempX1 = img112.getWidth() - 2 * haloX;
        tempX2 = img112.getWidth() - haloX;
        tempY1 = img112.getHeight() - haloY - stepY;
        tempY2 = img112.getHeight() - haloY;
        tempZ1 = img112.getStackSize() - 2 * haloZ;
        tempZ2 = img112.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img112.getStack().getProcessor(z);
            ImageProcessor proc24 = img211.getStack().getProcessor(zao);
            ImageProcessor proc1v = img111.getStack().getProcessor(z);
            ImageProcessor proc2v = img212.getStack().getProcessor(zao);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc24.set(xao2, y2, proc1.get(x2, y2));
                    proc2v.set(xb2, y2, proc1v.get(xbo2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img112.getStack().getProcessor(zb);
            ImageProcessor proc25 = img211.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img111.getStack().getProcessor(zb);
            ImageProcessor proc2v = img212.getStack().getProcessor(zbo);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc1.set(xb2, y2, proc25.get(xbo2, y2));
                    proc1v.set(xao2, y2, proc2v.get(x2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img112.getWidth() - haloX - stepX;
        tempX2 = img112.getWidth() - haloX;
        tempY1 = img112.getHeight() - 2 * haloY;
        tempY2 = img112.getHeight() - haloY;
        tempZ1 = img112.getStackSize() - 2 * haloZ;
        tempZ2 = img112.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img112.getStack().getProcessor(z);
            ImageProcessor proc26 = img222.getStack().getProcessor(zao);
            ImageProcessor proc1v = img122.getStack().getProcessor(z);
            ImageProcessor proc2v = img212.getStack().getProcessor(zao);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc26.set(x2, yao2, proc1.get(x2, y4));
                    proc2v.set(x2, yb2, proc1v.get(x2, ybo2));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img112.getStack().getProcessor(zb);
            ImageProcessor proc27 = img222.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img122.getStack().getProcessor(zb);
            ImageProcessor proc2v = img212.getStack().getProcessor(zbo);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc1.set(x2, yb2, proc27.get(x2, ybo2));
                    proc1v.set(x2, yao2, proc2v.get(x2, y4));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img112.getWidth() - 2 * haloX;
        tempX2 = img112.getWidth() - haloX;
        tempY1 = img112.getHeight() - 2 * haloY;
        tempY2 = img112.getHeight() - haloY;
        tempZ1 = img112.getStackSize() - 2 * haloZ;
        tempZ2 = img112.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        int zb2 = tempZ2 + 1;
        int zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc14 = img112.getStack().getProcessor(z);
            ImageProcessor proc28 = img221.getStack().getProcessor(zao);
            ImageProcessor proc1v1 = img111.getStack().getProcessor(z);
            ImageProcessor proc2v1 = img222.getStack().getProcessor(zao);
            ImageProcessor proc1v2 = img122.getStack().getProcessor(z);
            ImageProcessor proc2v2 = img211.getStack().getProcessor(zao);
            ImageProcessor proc1v3 = img121.getStack().getProcessor(z);
            ImageProcessor proc2v3 = img212.getStack().getProcessor(zao);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc28.set(xao, yao, proc14.get(x, y));
                    proc2v1.set(xb, yao, proc1v1.get(xbo, y));
                    proc2v2.set(xao, yb, proc1v2.get(x, ybo));
                    proc2v3.set(xb, yb, proc1v3.get(xbo, ybo));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
        z = tempZ1 + 1;
        zao = 1;
        zb2 = tempZ2 + 1;
        zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc15 = img112.getStack().getProcessor(zb2);
            ImageProcessor proc29 = img221.getStack().getProcessor(zbo2);
            ImageProcessor proc1v1 = img111.getStack().getProcessor(zb2);
            ImageProcessor proc2v1 = img222.getStack().getProcessor(zbo2);
            ImageProcessor proc1v2 = img122.getStack().getProcessor(zb2);
            ImageProcessor proc2v2 = img211.getStack().getProcessor(zbo2);
            ImageProcessor proc1v3 = img121.getStack().getProcessor(zb2);
            ImageProcessor proc2v3 = img212.getStack().getProcessor(zbo2);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc15.set(xb, yb, proc29.get(xbo, ybo));
                    proc1v1.set(xao, yb, proc2v1.get(x, ybo));
                    proc1v2.set(xb, yao, proc2v2.get(xbo, y));
                    proc1v3.set(xao, yao, proc2v3.get(x, y));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
    }

    private void doexchangetype010() {
        int yb;
        int ybo;
        int yao;
        int y;
        int xb;
        int xbo;
        int xao;
        int x;
        int yb2;
        int ybo2;
        int yao2;
        int y2;
        int xb2;
        int xbo2;
        int xao2;
        int x2;
        int y3;
        int x3;
        ImageProcessor proc1;
        int y4;
        int x4;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int z;
        IJ.log((String)"---010--------------");
        IJ.log((String)(filein121 + "|" + filein122));
        IJ.log((String)(filein111 + "|" + filein112));
        IJ.log((String)"--------------------");
        tempX1 = img121.getWidth() - 2 * haloX;
        tempX2 = img121.getWidth() - haloX;
        tempY1 = img121.getHeight() - haloY - stepY;
        tempY2 = img121.getHeight() - haloY;
        tempZ1 = img121.getStackSize() - haloZ - stepZ;
        tempZ2 = img121.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img121.getStack().getProcessor(z);
            proc2 = img122.getStack().getProcessor(z);
            x4 = tempX1;
            int xao3 = 0;
            int xbo3 = haloX;
            int xb3 = tempX2;
            while (x4 < tempX2) {
                for (y4 = tempY1; y4 < tempY2; ++y4) {
                    proc2.set(xao3, y4, proc12.get(x4, y4));
                    proc12.set(xb3, y4, proc2.get(xbo3, y4));
                }
                ++x4;
                ++xb3;
                ++xao3;
                ++xbo3;
            }
        }
        tempX1 = img121.getWidth() - haloX - stepX;
        tempX2 = img121.getWidth() - haloX;
        tempY1 = img121.getHeight() - 2 * haloY;
        tempY2 = img121.getHeight() - haloY;
        tempZ1 = img121.getStackSize() - haloZ - stepZ;
        tempZ2 = img121.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img121.getStack().getProcessor(z);
            proc2 = img111.getStack().getProcessor(z);
            for (x4 = tempX1; x4 < tempX2; ++x4) {
                int y5 = tempY1;
                int yao3 = 0;
                int ybo3 = haloY;
                int yb3 = tempY2;
                while (y5 < tempY2) {
                    proc2.set(x4, yao3, proc12.get(x4, y5));
                    proc12.set(x4, yb3, proc2.get(x4, ybo3));
                    ++y5;
                    ++yb3;
                    ++yao3;
                    ++ybo3;
                }
            }
        }
        tempX1 = img121.getWidth() - haloX - stepX;
        tempX2 = img121.getWidth() - haloX;
        tempY1 = img121.getHeight() - haloY - stepY;
        tempY2 = img121.getHeight() - haloY;
        tempZ1 = img121.getStackSize() - 2 * haloZ;
        tempZ2 = img121.getStackSize() - haloZ;
        z = tempZ1 + 1;
        int zao = 1;
        while (z <= tempZ2) {
            proc1 = img121.getStack().getProcessor(z);
            ImageProcessor proc22 = img221.getStack().getProcessor(zao);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc22.set(x3, y3, proc1.get(x3, y3));
                }
            }
            ++z;
            ++zao;
        }
        int zb = tempZ2 + 1;
        int zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img121.getStack().getProcessor(zb);
            ImageProcessor proc23 = img221.getStack().getProcessor(zbo);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc1.set(x3, y3, proc23.get(x3, y3));
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img121.getWidth() - 2 * haloX;
        tempX2 = img121.getWidth() - haloX;
        tempY1 = img121.getHeight() - 2 * haloY;
        tempY2 = img121.getHeight() - haloY;
        tempZ1 = img121.getStackSize() - haloZ - stepZ;
        tempZ2 = img121.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            ImageProcessor proc13 = img121.getStack().getProcessor(z);
            proc2 = img112.getStack().getProcessor(z);
            ImageProcessor proc1v = img122.getStack().getProcessor(z);
            ImageProcessor proc2v = img111.getStack().getProcessor(z);
            int x5 = tempX1;
            int xao4 = 0;
            int xbo4 = haloX;
            int xb4 = tempX2;
            while (x5 < tempX2) {
                int y6 = tempY1;
                int yao4 = 0;
                int ybo4 = haloY;
                int yb4 = tempY2;
                while (y6 < tempY2) {
                    proc2.set(xao4, yao4, proc13.get(x5, y6));
                    proc13.set(xb4, yb4, proc2.get(xbo4, ybo4));
                    proc2v.set(xb4, yao4, proc1v.get(xbo4, y6));
                    proc1v.set(xao4, yb4, proc2v.get(x5, ybo4));
                    ++y6;
                    ++yb4;
                    ++yao4;
                    ++ybo4;
                }
                ++x5;
                ++xb4;
                ++xao4;
                ++xbo4;
            }
        }
        tempX1 = img121.getWidth() - 2 * haloX;
        tempX2 = img121.getWidth() - haloX;
        tempY1 = img121.getHeight() - haloY - stepY;
        tempY2 = img121.getHeight() - haloY;
        tempZ1 = img121.getStackSize() - 2 * haloZ;
        tempZ2 = img121.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img121.getStack().getProcessor(z);
            ImageProcessor proc24 = img222.getStack().getProcessor(zao);
            ImageProcessor proc1v = img122.getStack().getProcessor(z);
            ImageProcessor proc2v = img221.getStack().getProcessor(zao);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc24.set(xao2, y2, proc1.get(x2, y2));
                    proc2v.set(xb2, y2, proc1v.get(xbo2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img121.getStack().getProcessor(zb);
            ImageProcessor proc25 = img222.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img122.getStack().getProcessor(zb);
            ImageProcessor proc2v = img221.getStack().getProcessor(zbo);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc1.set(xb2, y2, proc25.get(xbo2, y2));
                    proc1v.set(xao2, y2, proc2v.get(x2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img121.getWidth() - haloX - stepX;
        tempX2 = img121.getWidth() - haloX;
        tempY1 = img121.getHeight() - 2 * haloY;
        tempY2 = img121.getHeight() - haloY;
        tempZ1 = img121.getStackSize() - 2 * haloZ;
        tempZ2 = img121.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img121.getStack().getProcessor(z);
            ImageProcessor proc26 = img211.getStack().getProcessor(zao);
            ImageProcessor proc1v = img111.getStack().getProcessor(z);
            ImageProcessor proc2v = img221.getStack().getProcessor(zao);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc26.set(x2, yao2, proc1.get(x2, y4));
                    proc2v.set(x2, yb2, proc1v.get(x2, ybo2));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img121.getStack().getProcessor(zb);
            ImageProcessor proc27 = img211.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img111.getStack().getProcessor(zb);
            ImageProcessor proc2v = img221.getStack().getProcessor(zbo);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc1.set(x2, yb2, proc27.get(x2, ybo2));
                    proc1v.set(x2, yao2, proc2v.get(x2, y4));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img121.getWidth() - 2 * haloX;
        tempX2 = img121.getWidth() - haloX;
        tempY1 = img121.getHeight() - 2 * haloY;
        tempY2 = img121.getHeight() - haloY;
        tempZ1 = img121.getStackSize() - 2 * haloZ;
        tempZ2 = img121.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        int zb2 = tempZ2 + 1;
        int zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc14 = img121.getStack().getProcessor(z);
            ImageProcessor proc28 = img212.getStack().getProcessor(zao);
            ImageProcessor proc1v1 = img122.getStack().getProcessor(z);
            ImageProcessor proc2v1 = img211.getStack().getProcessor(zao);
            ImageProcessor proc1v2 = img111.getStack().getProcessor(z);
            ImageProcessor proc2v2 = img222.getStack().getProcessor(zao);
            ImageProcessor proc1v3 = img112.getStack().getProcessor(z);
            ImageProcessor proc2v3 = img221.getStack().getProcessor(zao);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc28.set(xao, yao, proc14.get(x, y));
                    proc2v1.set(xb, yao, proc1v1.get(xbo, y));
                    proc2v2.set(xao, yb, proc1v2.get(x, ybo));
                    proc2v3.set(xb, yb, proc1v3.get(xbo, ybo));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
        z = tempZ1 + 1;
        zao = 1;
        zb2 = tempZ2 + 1;
        zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc15 = img121.getStack().getProcessor(zb2);
            ImageProcessor proc29 = img212.getStack().getProcessor(zbo2);
            ImageProcessor proc1v1 = img122.getStack().getProcessor(zb2);
            ImageProcessor proc2v1 = img211.getStack().getProcessor(zbo2);
            ImageProcessor proc1v2 = img111.getStack().getProcessor(zb2);
            ImageProcessor proc2v2 = img222.getStack().getProcessor(zbo2);
            ImageProcessor proc1v3 = img112.getStack().getProcessor(zb2);
            ImageProcessor proc2v3 = img221.getStack().getProcessor(zbo2);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc15.set(xb, yb, proc29.get(xbo, ybo));
                    proc1v1.set(xao, yb, proc2v1.get(x, ybo));
                    proc1v2.set(xb, yao, proc2v2.get(xbo, y));
                    proc1v3.set(xao, yao, proc2v3.get(x, y));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
    }

    private void doexchangetype011() {
        int yb;
        int ybo;
        int yao;
        int y;
        int xb;
        int xbo;
        int xao;
        int x;
        int yb2;
        int ybo2;
        int yao2;
        int y2;
        int xb2;
        int xbo2;
        int xao2;
        int x2;
        int y3;
        int x3;
        ImageProcessor proc1;
        int y4;
        int x4;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int z;
        IJ.log((String)"---011--------------");
        IJ.log((String)(filein122 + "|" + filein121));
        IJ.log((String)(filein112 + "|" + filein111));
        IJ.log((String)"--------------------");
        tempX1 = img122.getWidth() - 2 * haloX;
        tempX2 = img122.getWidth() - haloX;
        tempY1 = img122.getHeight() - haloY - stepY;
        tempY2 = img122.getHeight() - haloY;
        tempZ1 = img122.getStackSize() - haloZ - stepZ;
        tempZ2 = img122.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img122.getStack().getProcessor(z);
            proc2 = img121.getStack().getProcessor(z);
            x4 = tempX1;
            int xao3 = 0;
            int xbo3 = haloX;
            int xb3 = tempX2;
            while (x4 < tempX2) {
                for (y4 = tempY1; y4 < tempY2; ++y4) {
                    proc2.set(xao3, y4, proc12.get(x4, y4));
                    proc12.set(xb3, y4, proc2.get(xbo3, y4));
                }
                ++x4;
                ++xb3;
                ++xao3;
                ++xbo3;
            }
        }
        tempX1 = img122.getWidth() - haloX - stepX;
        tempX2 = img122.getWidth() - haloX;
        tempY1 = img122.getHeight() - 2 * haloY;
        tempY2 = img122.getHeight() - haloY;
        tempZ1 = img122.getStackSize() - haloZ - stepZ;
        tempZ2 = img122.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img122.getStack().getProcessor(z);
            proc2 = img112.getStack().getProcessor(z);
            for (x4 = tempX1; x4 < tempX2; ++x4) {
                int y5 = tempY1;
                int yao3 = 0;
                int ybo3 = haloY;
                int yb3 = tempY2;
                while (y5 < tempY2) {
                    proc2.set(x4, yao3, proc12.get(x4, y5));
                    proc12.set(x4, yb3, proc2.get(x4, ybo3));
                    ++y5;
                    ++yb3;
                    ++yao3;
                    ++ybo3;
                }
            }
        }
        tempX1 = img122.getWidth() - haloX - stepX;
        tempX2 = img122.getWidth() - haloX;
        tempY1 = img122.getHeight() - haloY - stepY;
        tempY2 = img122.getHeight() - haloY;
        tempZ1 = img122.getStackSize() - 2 * haloZ;
        tempZ2 = img122.getStackSize() - haloZ;
        z = tempZ1 + 1;
        int zao = 1;
        while (z <= tempZ2) {
            proc1 = img122.getStack().getProcessor(z);
            ImageProcessor proc22 = img222.getStack().getProcessor(zao);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc22.set(x3, y3, proc1.get(x3, y3));
                }
            }
            ++z;
            ++zao;
        }
        int zb = tempZ2 + 1;
        int zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img122.getStack().getProcessor(zb);
            ImageProcessor proc23 = img222.getStack().getProcessor(zbo);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc1.set(x3, y3, proc23.get(x3, y3));
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img122.getWidth() - 2 * haloX;
        tempX2 = img122.getWidth() - haloX;
        tempY1 = img122.getHeight() - 2 * haloY;
        tempY2 = img122.getHeight() - haloY;
        tempZ1 = img122.getStackSize() - haloZ - stepZ;
        tempZ2 = img122.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            ImageProcessor proc13 = img122.getStack().getProcessor(z);
            proc2 = img111.getStack().getProcessor(z);
            ImageProcessor proc1v = img121.getStack().getProcessor(z);
            ImageProcessor proc2v = img112.getStack().getProcessor(z);
            int x5 = tempX1;
            int xao4 = 0;
            int xbo4 = haloX;
            int xb4 = tempX2;
            while (x5 < tempX2) {
                int y6 = tempY1;
                int yao4 = 0;
                int ybo4 = haloY;
                int yb4 = tempY2;
                while (y6 < tempY2) {
                    proc2.set(xao4, yao4, proc13.get(x5, y6));
                    proc13.set(xb4, yb4, proc2.get(xbo4, ybo4));
                    proc2v.set(xb4, yao4, proc1v.get(xbo4, y6));
                    proc1v.set(xao4, yb4, proc2v.get(x5, ybo4));
                    ++y6;
                    ++yb4;
                    ++yao4;
                    ++ybo4;
                }
                ++x5;
                ++xb4;
                ++xao4;
                ++xbo4;
            }
        }
        tempX1 = img122.getWidth() - 2 * haloX;
        tempX2 = img122.getWidth() - haloX;
        tempY1 = img122.getHeight() - haloY - stepY;
        tempY2 = img122.getHeight() - haloY;
        tempZ1 = img122.getStackSize() - 2 * haloZ;
        tempZ2 = img122.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img122.getStack().getProcessor(z);
            ImageProcessor proc24 = img221.getStack().getProcessor(zao);
            ImageProcessor proc1v = img121.getStack().getProcessor(z);
            ImageProcessor proc2v = img222.getStack().getProcessor(zao);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc24.set(xao2, y2, proc1.get(x2, y2));
                    proc2v.set(xb2, y2, proc1v.get(xbo2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img122.getStack().getProcessor(zb);
            ImageProcessor proc25 = img221.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img121.getStack().getProcessor(zb);
            ImageProcessor proc2v = img222.getStack().getProcessor(zbo);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc1.set(xb2, y2, proc25.get(xbo2, y2));
                    proc1v.set(xao2, y2, proc2v.get(x2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img122.getWidth() - haloX - stepX;
        tempX2 = img122.getWidth() - haloX;
        tempY1 = img122.getHeight() - 2 * haloY;
        tempY2 = img122.getHeight() - haloY;
        tempZ1 = img122.getStackSize() - 2 * haloZ;
        tempZ2 = img122.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img122.getStack().getProcessor(z);
            ImageProcessor proc26 = img212.getStack().getProcessor(zao);
            ImageProcessor proc1v = img112.getStack().getProcessor(z);
            ImageProcessor proc2v = img222.getStack().getProcessor(zao);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc26.set(x2, yao2, proc1.get(x2, y4));
                    proc2v.set(x2, yb2, proc1v.get(x2, ybo2));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img122.getStack().getProcessor(zb);
            ImageProcessor proc27 = img212.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img112.getStack().getProcessor(zb);
            ImageProcessor proc2v = img222.getStack().getProcessor(zbo);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc1.set(x2, yb2, proc27.get(x2, ybo2));
                    proc1v.set(x2, yao2, proc2v.get(x2, y4));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img122.getWidth() - 2 * haloX;
        tempX2 = img122.getWidth() - haloX;
        tempY1 = img122.getHeight() - 2 * haloY;
        tempY2 = img122.getHeight() - haloY;
        tempZ1 = img122.getStackSize() - 2 * haloZ;
        tempZ2 = img122.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        int zb2 = tempZ2 + 1;
        int zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc14 = img122.getStack().getProcessor(z);
            ImageProcessor proc28 = img211.getStack().getProcessor(zao);
            ImageProcessor proc1v1 = img121.getStack().getProcessor(z);
            ImageProcessor proc2v1 = img212.getStack().getProcessor(zao);
            ImageProcessor proc1v2 = img112.getStack().getProcessor(z);
            ImageProcessor proc2v2 = img221.getStack().getProcessor(zao);
            ImageProcessor proc1v3 = img111.getStack().getProcessor(z);
            ImageProcessor proc2v3 = img222.getStack().getProcessor(zao);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc28.set(xao, yao, proc14.get(x, y));
                    proc2v1.set(xb, yao, proc1v1.get(xbo, y));
                    proc2v2.set(xao, yb, proc1v2.get(x, ybo));
                    proc2v3.set(xb, yb, proc1v3.get(xbo, ybo));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
        z = tempZ1 + 1;
        zao = 1;
        zb2 = tempZ2 + 1;
        zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc15 = img122.getStack().getProcessor(zb2);
            ImageProcessor proc29 = img211.getStack().getProcessor(zbo2);
            ImageProcessor proc1v1 = img121.getStack().getProcessor(zb2);
            ImageProcessor proc2v1 = img212.getStack().getProcessor(zbo2);
            ImageProcessor proc1v2 = img112.getStack().getProcessor(zb2);
            ImageProcessor proc2v2 = img221.getStack().getProcessor(zbo2);
            ImageProcessor proc1v3 = img111.getStack().getProcessor(zb2);
            ImageProcessor proc2v3 = img222.getStack().getProcessor(zbo2);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc15.set(xb, yb, proc29.get(xbo, ybo));
                    proc1v1.set(xao, yb, proc2v1.get(x, ybo));
                    proc1v2.set(xb, yao, proc2v2.get(xbo, y));
                    proc1v3.set(xao, yao, proc2v3.get(x, y));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
    }

    private void doexchangetype100() {
        int yb;
        int ybo;
        int yao;
        int y;
        int xb;
        int xbo;
        int xao;
        int x;
        int yb2;
        int ybo2;
        int yao2;
        int y2;
        int xb2;
        int xbo2;
        int xao2;
        int x2;
        int y3;
        int x3;
        ImageProcessor proc1;
        int y4;
        int x4;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int z;
        IJ.log((String)"---100--------------");
        IJ.log((String)(filein211 + "|" + filein212));
        IJ.log((String)(filein221 + "|" + filein222));
        IJ.log((String)"--------------------");
        tempX1 = img211.getWidth() - 2 * haloX;
        tempX2 = img211.getWidth() - haloX;
        tempY1 = img211.getHeight() - haloY - stepY;
        tempY2 = img211.getHeight() - haloY;
        tempZ1 = img211.getStackSize() - haloZ - stepZ;
        tempZ2 = img211.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img211.getStack().getProcessor(z);
            proc2 = img212.getStack().getProcessor(z);
            x4 = tempX1;
            int xao3 = 0;
            int xbo3 = haloX;
            int xb3 = tempX2;
            while (x4 < tempX2) {
                for (y4 = tempY1; y4 < tempY2; ++y4) {
                    proc2.set(xao3, y4, proc12.get(x4, y4));
                    proc12.set(xb3, y4, proc2.get(xbo3, y4));
                }
                ++x4;
                ++xb3;
                ++xao3;
                ++xbo3;
            }
        }
        tempX1 = img211.getWidth() - haloX - stepX;
        tempX2 = img211.getWidth() - haloX;
        tempY1 = img211.getHeight() - 2 * haloY;
        tempY2 = img211.getHeight() - haloY;
        tempZ1 = img211.getStackSize() - haloZ - stepZ;
        tempZ2 = img211.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img211.getStack().getProcessor(z);
            proc2 = img221.getStack().getProcessor(z);
            for (x4 = tempX1; x4 < tempX2; ++x4) {
                int y5 = tempY1;
                int yao3 = 0;
                int ybo3 = haloY;
                int yb3 = tempY2;
                while (y5 < tempY2) {
                    proc2.set(x4, yao3, proc12.get(x4, y5));
                    proc12.set(x4, yb3, proc2.get(x4, ybo3));
                    ++y5;
                    ++yb3;
                    ++yao3;
                    ++ybo3;
                }
            }
        }
        tempX1 = img211.getWidth() - haloX - stepX;
        tempX2 = img211.getWidth() - haloX;
        tempY1 = img211.getHeight() - haloY - stepY;
        tempY2 = img211.getHeight() - haloY;
        tempZ1 = img211.getStackSize() - 2 * haloZ;
        tempZ2 = img211.getStackSize() - haloZ;
        z = tempZ1 + 1;
        int zao = 1;
        while (z <= tempZ2) {
            proc1 = img211.getStack().getProcessor(z);
            ImageProcessor proc22 = img111.getStack().getProcessor(zao);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc22.set(x3, y3, proc1.get(x3, y3));
                }
            }
            ++z;
            ++zao;
        }
        int zb = tempZ2 + 1;
        int zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img211.getStack().getProcessor(zb);
            ImageProcessor proc23 = img111.getStack().getProcessor(zbo);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc1.set(x3, y3, proc23.get(x3, y3));
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img211.getWidth() - 2 * haloX;
        tempX2 = img211.getWidth() - haloX;
        tempY1 = img211.getHeight() - 2 * haloY;
        tempY2 = img211.getHeight() - haloY;
        tempZ1 = img211.getStackSize() - haloZ - stepZ;
        tempZ2 = img211.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            ImageProcessor proc13 = img211.getStack().getProcessor(z);
            proc2 = img222.getStack().getProcessor(z);
            ImageProcessor proc1v = img212.getStack().getProcessor(z);
            ImageProcessor proc2v = img221.getStack().getProcessor(z);
            int x5 = tempX1;
            int xao4 = 0;
            int xbo4 = haloX;
            int xb4 = tempX2;
            while (x5 < tempX2) {
                int y6 = tempY1;
                int yao4 = 0;
                int ybo4 = haloY;
                int yb4 = tempY2;
                while (y6 < tempY2) {
                    proc2.set(xao4, yao4, proc13.get(x5, y6));
                    proc13.set(xb4, yb4, proc2.get(xbo4, ybo4));
                    proc2v.set(xb4, yao4, proc1v.get(xbo4, y6));
                    proc1v.set(xao4, yb4, proc2v.get(x5, ybo4));
                    ++y6;
                    ++yb4;
                    ++yao4;
                    ++ybo4;
                }
                ++x5;
                ++xb4;
                ++xao4;
                ++xbo4;
            }
        }
        tempX1 = img211.getWidth() - 2 * haloX;
        tempX2 = img211.getWidth() - haloX;
        tempY1 = img211.getHeight() - haloY - stepY;
        tempY2 = img211.getHeight() - haloY;
        tempZ1 = img211.getStackSize() - 2 * haloZ;
        tempZ2 = img211.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img211.getStack().getProcessor(z);
            ImageProcessor proc24 = img112.getStack().getProcessor(zao);
            ImageProcessor proc1v = img212.getStack().getProcessor(z);
            ImageProcessor proc2v = img111.getStack().getProcessor(zao);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc24.set(xao2, y2, proc1.get(x2, y2));
                    proc2v.set(xb2, y2, proc1v.get(xbo2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img211.getStack().getProcessor(zb);
            ImageProcessor proc25 = img112.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img212.getStack().getProcessor(zb);
            ImageProcessor proc2v = img111.getStack().getProcessor(zbo);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc1.set(xb2, y2, proc25.get(xbo2, y2));
                    proc1v.set(xao2, y2, proc2v.get(x2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img211.getWidth() - haloX - stepX;
        tempX2 = img211.getWidth() - haloX;
        tempY1 = img211.getHeight() - 2 * haloY;
        tempY2 = img211.getHeight() - haloY;
        tempZ1 = img211.getStackSize() - 2 * haloZ;
        tempZ2 = img211.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img211.getStack().getProcessor(z);
            ImageProcessor proc26 = img121.getStack().getProcessor(zao);
            ImageProcessor proc1v = img221.getStack().getProcessor(z);
            ImageProcessor proc2v = img111.getStack().getProcessor(zao);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc26.set(x2, yao2, proc1.get(x2, y4));
                    proc2v.set(x2, yb2, proc1v.get(x2, ybo2));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img211.getStack().getProcessor(zb);
            ImageProcessor proc27 = img121.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img221.getStack().getProcessor(zb);
            ImageProcessor proc2v = img111.getStack().getProcessor(zbo);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc1.set(x2, yb2, proc27.get(x2, ybo2));
                    proc1v.set(x2, yao2, proc2v.get(x2, y4));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img211.getWidth() - 2 * haloX;
        tempX2 = img211.getWidth() - haloX;
        tempY1 = img211.getHeight() - 2 * haloY;
        tempY2 = img211.getHeight() - haloY;
        tempZ1 = img211.getStackSize() - 2 * haloZ;
        tempZ2 = img211.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        int zb2 = tempZ2 + 1;
        int zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc14 = img211.getStack().getProcessor(z);
            ImageProcessor proc28 = img122.getStack().getProcessor(zao);
            ImageProcessor proc1v1 = img212.getStack().getProcessor(z);
            ImageProcessor proc2v1 = img121.getStack().getProcessor(zao);
            ImageProcessor proc1v2 = img221.getStack().getProcessor(z);
            ImageProcessor proc2v2 = img112.getStack().getProcessor(zao);
            ImageProcessor proc1v3 = img222.getStack().getProcessor(z);
            ImageProcessor proc2v3 = img111.getStack().getProcessor(zao);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc28.set(xao, yao, proc14.get(x, y));
                    proc2v1.set(xb, yao, proc1v1.get(xbo, y));
                    proc2v2.set(xao, yb, proc1v2.get(x, ybo));
                    proc2v3.set(xb, yb, proc1v3.get(xbo, ybo));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
        z = tempZ1 + 1;
        zao = 1;
        zb2 = tempZ2 + 1;
        zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc15 = img211.getStack().getProcessor(zb2);
            ImageProcessor proc29 = img122.getStack().getProcessor(zbo2);
            ImageProcessor proc1v1 = img212.getStack().getProcessor(zb2);
            ImageProcessor proc2v1 = img121.getStack().getProcessor(zbo2);
            ImageProcessor proc1v2 = img221.getStack().getProcessor(zb2);
            ImageProcessor proc2v2 = img112.getStack().getProcessor(zbo2);
            ImageProcessor proc1v3 = img222.getStack().getProcessor(zb2);
            ImageProcessor proc2v3 = img111.getStack().getProcessor(zbo2);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc15.set(xb, yb, proc29.get(xbo, ybo));
                    proc1v1.set(xao, yb, proc2v1.get(x, ybo));
                    proc1v2.set(xb, yao, proc2v2.get(xbo, y));
                    proc1v3.set(xao, yao, proc2v3.get(x, y));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
    }

    private void doexchangetype101() {
        int yb;
        int ybo;
        int yao;
        int y;
        int xb;
        int xbo;
        int xao;
        int x;
        int yb2;
        int ybo2;
        int yao2;
        int y2;
        int xb2;
        int xbo2;
        int xao2;
        int x2;
        int y3;
        int x3;
        ImageProcessor proc1;
        int y4;
        int x4;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int z;
        IJ.log((String)"---101--------------");
        IJ.log((String)(filein212 + "|" + filein211));
        IJ.log((String)(filein222 + "|" + filein221));
        IJ.log((String)"--------------------");
        tempX1 = img212.getWidth() - 2 * haloX;
        tempX2 = img212.getWidth() - haloX;
        tempY1 = img212.getHeight() - haloY - stepY;
        tempY2 = img212.getHeight() - haloY;
        tempZ1 = img212.getStackSize() - haloZ - stepZ;
        tempZ2 = img212.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img212.getStack().getProcessor(z);
            proc2 = img211.getStack().getProcessor(z);
            x4 = tempX1;
            int xao3 = 0;
            int xbo3 = haloX;
            int xb3 = tempX2;
            while (x4 < tempX2) {
                for (y4 = tempY1; y4 < tempY2; ++y4) {
                    proc2.set(xao3, y4, proc12.get(x4, y4));
                    proc12.set(xb3, y4, proc2.get(xbo3, y4));
                }
                ++x4;
                ++xb3;
                ++xao3;
                ++xbo3;
            }
        }
        tempX1 = img212.getWidth() - haloX - stepX;
        tempX2 = img212.getWidth() - haloX;
        tempY1 = img212.getHeight() - 2 * haloY;
        tempY2 = img212.getHeight() - haloY;
        tempZ1 = img212.getStackSize() - haloZ - stepZ;
        tempZ2 = img212.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img212.getStack().getProcessor(z);
            proc2 = img222.getStack().getProcessor(z);
            for (x4 = tempX1; x4 < tempX2; ++x4) {
                int y5 = tempY1;
                int yao3 = 0;
                int ybo3 = haloY;
                int yb3 = tempY2;
                while (y5 < tempY2) {
                    proc2.set(x4, yao3, proc12.get(x4, y5));
                    proc12.set(x4, yb3, proc2.get(x4, ybo3));
                    ++y5;
                    ++yb3;
                    ++yao3;
                    ++ybo3;
                }
            }
        }
        tempX1 = img212.getWidth() - haloX - stepX;
        tempX2 = img212.getWidth() - haloX;
        tempY1 = img212.getHeight() - haloY - stepY;
        tempY2 = img212.getHeight() - haloY;
        tempZ1 = img212.getStackSize() - 2 * haloZ;
        tempZ2 = img212.getStackSize() - haloZ;
        z = tempZ1 + 1;
        int zao = 1;
        while (z <= tempZ2) {
            proc1 = img212.getStack().getProcessor(z);
            ImageProcessor proc22 = img112.getStack().getProcessor(zao);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc22.set(x3, y3, proc1.get(x3, y3));
                }
            }
            ++z;
            ++zao;
        }
        int zb = tempZ2 + 1;
        int zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img212.getStack().getProcessor(zb);
            ImageProcessor proc23 = img112.getStack().getProcessor(zbo);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc1.set(x3, y3, proc23.get(x3, y3));
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img212.getWidth() - 2 * haloX;
        tempX2 = img212.getWidth() - haloX;
        tempY1 = img212.getHeight() - 2 * haloY;
        tempY2 = img212.getHeight() - haloY;
        tempZ1 = img212.getStackSize() - haloZ - stepZ;
        tempZ2 = img212.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            ImageProcessor proc13 = img212.getStack().getProcessor(z);
            proc2 = img221.getStack().getProcessor(z);
            ImageProcessor proc1v = img211.getStack().getProcessor(z);
            ImageProcessor proc2v = img222.getStack().getProcessor(z);
            int x5 = tempX1;
            int xao4 = 0;
            int xbo4 = haloX;
            int xb4 = tempX2;
            while (x5 < tempX2) {
                int y6 = tempY1;
                int yao4 = 0;
                int ybo4 = haloY;
                int yb4 = tempY2;
                while (y6 < tempY2) {
                    proc2.set(xao4, yao4, proc13.get(x5, y6));
                    proc13.set(xb4, yb4, proc2.get(xbo4, ybo4));
                    proc2v.set(xb4, yao4, proc1v.get(xbo4, y6));
                    proc1v.set(xao4, yb4, proc2v.get(x5, ybo4));
                    ++y6;
                    ++yb4;
                    ++yao4;
                    ++ybo4;
                }
                ++x5;
                ++xb4;
                ++xao4;
                ++xbo4;
            }
        }
        tempX1 = img212.getWidth() - 2 * haloX;
        tempX2 = img212.getWidth() - haloX;
        tempY1 = img212.getHeight() - haloY - stepY;
        tempY2 = img212.getHeight() - haloY;
        tempZ1 = img212.getStackSize() - 2 * haloZ;
        tempZ2 = img212.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img212.getStack().getProcessor(z);
            ImageProcessor proc24 = img111.getStack().getProcessor(zao);
            ImageProcessor proc1v = img211.getStack().getProcessor(z);
            ImageProcessor proc2v = img112.getStack().getProcessor(zao);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc24.set(xao2, y2, proc1.get(x2, y2));
                    proc2v.set(xb2, y2, proc1v.get(xbo2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img212.getStack().getProcessor(zb);
            ImageProcessor proc25 = img111.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img211.getStack().getProcessor(zb);
            ImageProcessor proc2v = img112.getStack().getProcessor(zbo);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc1.set(xb2, y2, proc25.get(xbo2, y2));
                    proc1v.set(xao2, y2, proc2v.get(x2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img212.getWidth() - haloX - stepX;
        tempX2 = img212.getWidth() - haloX;
        tempY1 = img212.getHeight() - 2 * haloY;
        tempY2 = img212.getHeight() - haloY;
        tempZ1 = img212.getStackSize() - 2 * haloZ;
        tempZ2 = img212.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img212.getStack().getProcessor(z);
            ImageProcessor proc26 = img122.getStack().getProcessor(zao);
            ImageProcessor proc1v = img222.getStack().getProcessor(z);
            ImageProcessor proc2v = img112.getStack().getProcessor(zao);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc26.set(x2, yao2, proc1.get(x2, y4));
                    proc2v.set(x2, yb2, proc1v.get(x2, ybo2));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img212.getStack().getProcessor(zb);
            ImageProcessor proc27 = img122.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img222.getStack().getProcessor(zb);
            ImageProcessor proc2v = img112.getStack().getProcessor(zbo);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc1.set(x2, yb2, proc27.get(x2, ybo2));
                    proc1v.set(x2, yao2, proc2v.get(x2, y4));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img212.getWidth() - 2 * haloX;
        tempX2 = img212.getWidth() - haloX;
        tempY1 = img212.getHeight() - 2 * haloY;
        tempY2 = img212.getHeight() - haloY;
        tempZ1 = img212.getStackSize() - 2 * haloZ;
        tempZ2 = img212.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        int zb2 = tempZ2 + 1;
        int zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc14 = img212.getStack().getProcessor(z);
            ImageProcessor proc28 = img121.getStack().getProcessor(zao);
            ImageProcessor proc1v1 = img211.getStack().getProcessor(z);
            ImageProcessor proc2v1 = img122.getStack().getProcessor(zao);
            ImageProcessor proc1v2 = img222.getStack().getProcessor(z);
            ImageProcessor proc2v2 = img111.getStack().getProcessor(zao);
            ImageProcessor proc1v3 = img221.getStack().getProcessor(z);
            ImageProcessor proc2v3 = img112.getStack().getProcessor(zao);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc28.set(xao, yao, proc14.get(x, y));
                    proc2v1.set(xb, yao, proc1v1.get(xbo, y));
                    proc2v2.set(xao, yb, proc1v2.get(x, ybo));
                    proc2v3.set(xb, yb, proc1v3.get(xbo, ybo));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
        z = tempZ1 + 1;
        zao = 1;
        zb2 = tempZ2 + 1;
        zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc15 = img212.getStack().getProcessor(zb2);
            ImageProcessor proc29 = img121.getStack().getProcessor(zbo2);
            ImageProcessor proc1v1 = img211.getStack().getProcessor(zb2);
            ImageProcessor proc2v1 = img122.getStack().getProcessor(zbo2);
            ImageProcessor proc1v2 = img222.getStack().getProcessor(zb2);
            ImageProcessor proc2v2 = img111.getStack().getProcessor(zbo2);
            ImageProcessor proc1v3 = img221.getStack().getProcessor(zb2);
            ImageProcessor proc2v3 = img112.getStack().getProcessor(zbo2);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc15.set(xb, yb, proc29.get(xbo, ybo));
                    proc1v1.set(xao, yb, proc2v1.get(x, ybo));
                    proc1v2.set(xb, yao, proc2v2.get(xbo, y));
                    proc1v3.set(xao, yao, proc2v3.get(x, y));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
    }

    private void doexchangetype110() {
        int yb;
        int ybo;
        int yao;
        int y;
        int xb;
        int xbo;
        int xao;
        int x;
        int yb2;
        int ybo2;
        int yao2;
        int y2;
        int xb2;
        int xbo2;
        int xao2;
        int x2;
        int y3;
        int x3;
        ImageProcessor proc1;
        int y4;
        int x4;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int z;
        IJ.log((String)"---110--------------");
        IJ.log((String)(filein221 + "|" + filein222));
        IJ.log((String)(filein211 + "|" + filein212));
        IJ.log((String)"--------------------");
        tempX1 = img221.getWidth() - 2 * haloX;
        tempX2 = img221.getWidth() - haloX;
        tempY1 = img221.getHeight() - haloY - stepY;
        tempY2 = img221.getHeight() - haloY;
        tempZ1 = img221.getStackSize() - haloZ - stepZ;
        tempZ2 = img221.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img221.getStack().getProcessor(z);
            proc2 = img222.getStack().getProcessor(z);
            x4 = tempX1;
            int xao3 = 0;
            int xbo3 = haloX;
            int xb3 = tempX2;
            while (x4 < tempX2) {
                for (y4 = tempY1; y4 < tempY2; ++y4) {
                    proc2.set(xao3, y4, proc12.get(x4, y4));
                    proc12.set(xb3, y4, proc2.get(xbo3, y4));
                }
                ++x4;
                ++xb3;
                ++xao3;
                ++xbo3;
            }
        }
        tempX1 = img221.getWidth() - haloX - stepX;
        tempX2 = img221.getWidth() - haloX;
        tempY1 = img221.getHeight() - 2 * haloY;
        tempY2 = img221.getHeight() - haloY;
        tempZ1 = img221.getStackSize() - haloZ - stepZ;
        tempZ2 = img221.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img221.getStack().getProcessor(z);
            proc2 = img211.getStack().getProcessor(z);
            for (x4 = tempX1; x4 < tempX2; ++x4) {
                int y5 = tempY1;
                int yao3 = 0;
                int ybo3 = haloY;
                int yb3 = tempY2;
                while (y5 < tempY2) {
                    proc2.set(x4, yao3, proc12.get(x4, y5));
                    proc12.set(x4, yb3, proc2.get(x4, ybo3));
                    ++y5;
                    ++yb3;
                    ++yao3;
                    ++ybo3;
                }
            }
        }
        tempX1 = img221.getWidth() - haloX - stepX;
        tempX2 = img221.getWidth() - haloX;
        tempY1 = img221.getHeight() - haloY - stepY;
        tempY2 = img221.getHeight() - haloY;
        tempZ1 = img221.getStackSize() - 2 * haloZ;
        tempZ2 = img221.getStackSize() - haloZ;
        z = tempZ1 + 1;
        int zao = 1;
        while (z <= tempZ2) {
            proc1 = img221.getStack().getProcessor(z);
            ImageProcessor proc22 = img121.getStack().getProcessor(zao);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc22.set(x3, y3, proc1.get(x3, y3));
                }
            }
            ++z;
            ++zao;
        }
        int zb = tempZ2 + 1;
        int zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img221.getStack().getProcessor(zb);
            ImageProcessor proc23 = img121.getStack().getProcessor(zbo);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc1.set(x3, y3, proc23.get(x3, y3));
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img221.getWidth() - 2 * haloX;
        tempX2 = img221.getWidth() - haloX;
        tempY1 = img221.getHeight() - 2 * haloY;
        tempY2 = img221.getHeight() - haloY;
        tempZ1 = img221.getStackSize() - haloZ - stepZ;
        tempZ2 = img221.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            ImageProcessor proc13 = img221.getStack().getProcessor(z);
            proc2 = img212.getStack().getProcessor(z);
            ImageProcessor proc1v = img222.getStack().getProcessor(z);
            ImageProcessor proc2v = img211.getStack().getProcessor(z);
            int x5 = tempX1;
            int xao4 = 0;
            int xbo4 = haloX;
            int xb4 = tempX2;
            while (x5 < tempX2) {
                int y6 = tempY1;
                int yao4 = 0;
                int ybo4 = haloY;
                int yb4 = tempY2;
                while (y6 < tempY2) {
                    proc2.set(xao4, yao4, proc13.get(x5, y6));
                    proc13.set(xb4, yb4, proc2.get(xbo4, ybo4));
                    proc2v.set(xb4, yao4, proc1v.get(xbo4, y6));
                    proc1v.set(xao4, yb4, proc2v.get(x5, ybo4));
                    ++y6;
                    ++yb4;
                    ++yao4;
                    ++ybo4;
                }
                ++x5;
                ++xb4;
                ++xao4;
                ++xbo4;
            }
        }
        tempX1 = img221.getWidth() - 2 * haloX;
        tempX2 = img221.getWidth() - haloX;
        tempY1 = img221.getHeight() - haloY - stepY;
        tempY2 = img221.getHeight() - haloY;
        tempZ1 = img221.getStackSize() - 2 * haloZ;
        tempZ2 = img221.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img221.getStack().getProcessor(z);
            ImageProcessor proc24 = img122.getStack().getProcessor(zao);
            ImageProcessor proc1v = img222.getStack().getProcessor(z);
            ImageProcessor proc2v = img121.getStack().getProcessor(zao);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc24.set(xao2, y2, proc1.get(x2, y2));
                    proc2v.set(xb2, y2, proc1v.get(xbo2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img221.getStack().getProcessor(zb);
            ImageProcessor proc25 = img122.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img222.getStack().getProcessor(zb);
            ImageProcessor proc2v = img121.getStack().getProcessor(zbo);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc1.set(xb2, y2, proc25.get(xbo2, y2));
                    proc1v.set(xao2, y2, proc2v.get(x2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img221.getWidth() - haloX - stepX;
        tempX2 = img221.getWidth() - haloX;
        tempY1 = img221.getHeight() - 2 * haloY;
        tempY2 = img221.getHeight() - haloY;
        tempZ1 = img221.getStackSize() - 2 * haloZ;
        tempZ2 = img221.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img221.getStack().getProcessor(z);
            ImageProcessor proc26 = img111.getStack().getProcessor(zao);
            ImageProcessor proc1v = img211.getStack().getProcessor(z);
            ImageProcessor proc2v = img121.getStack().getProcessor(zao);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc26.set(x2, yao2, proc1.get(x2, y4));
                    proc2v.set(x2, yb2, proc1v.get(x2, ybo2));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img221.getStack().getProcessor(zb);
            ImageProcessor proc27 = img111.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img211.getStack().getProcessor(zb);
            ImageProcessor proc2v = img121.getStack().getProcessor(zbo);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc1.set(x2, yb2, proc27.get(x2, ybo2));
                    proc1v.set(x2, yao2, proc2v.get(x2, y4));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img221.getWidth() - 2 * haloX;
        tempX2 = img221.getWidth() - haloX;
        tempY1 = img221.getHeight() - 2 * haloY;
        tempY2 = img221.getHeight() - haloY;
        tempZ1 = img221.getStackSize() - 2 * haloZ;
        tempZ2 = img221.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        int zb2 = tempZ2 + 1;
        int zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc14 = img221.getStack().getProcessor(z);
            ImageProcessor proc28 = img112.getStack().getProcessor(zao);
            ImageProcessor proc1v1 = img222.getStack().getProcessor(z);
            ImageProcessor proc2v1 = img111.getStack().getProcessor(zao);
            ImageProcessor proc1v2 = img211.getStack().getProcessor(z);
            ImageProcessor proc2v2 = img122.getStack().getProcessor(zao);
            ImageProcessor proc1v3 = img212.getStack().getProcessor(z);
            ImageProcessor proc2v3 = img121.getStack().getProcessor(zao);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc28.set(xao, yao, proc14.get(x, y));
                    proc2v1.set(xb, yao, proc1v1.get(xbo, y));
                    proc2v2.set(xao, yb, proc1v2.get(x, ybo));
                    proc2v3.set(xb, yb, proc1v3.get(xbo, ybo));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
        z = tempZ1 + 1;
        zao = 1;
        zb2 = tempZ2 + 1;
        zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc15 = img221.getStack().getProcessor(zb2);
            ImageProcessor proc29 = img112.getStack().getProcessor(zbo2);
            ImageProcessor proc1v1 = img222.getStack().getProcessor(zb2);
            ImageProcessor proc2v1 = img111.getStack().getProcessor(zbo2);
            ImageProcessor proc1v2 = img211.getStack().getProcessor(zb2);
            ImageProcessor proc2v2 = img122.getStack().getProcessor(zbo2);
            ImageProcessor proc1v3 = img212.getStack().getProcessor(zb2);
            ImageProcessor proc2v3 = img121.getStack().getProcessor(zbo2);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc15.set(xb, yb, proc29.get(xbo, ybo));
                    proc1v1.set(xao, yb, proc2v1.get(x, ybo));
                    proc1v2.set(xb, yao, proc2v2.get(xbo, y));
                    proc1v3.set(xao, yao, proc2v3.get(x, y));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
    }

    private void doexchangetype111() {
        int yb;
        int ybo;
        int yao;
        int y;
        int xb;
        int xbo;
        int xao;
        int x;
        int yb2;
        int ybo2;
        int yao2;
        int y2;
        int xb2;
        int xbo2;
        int xao2;
        int x2;
        int y3;
        int x3;
        ImageProcessor proc1;
        int y4;
        int x4;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int z;
        IJ.log((String)"---111--------------");
        IJ.log((String)(filein222 + "|" + filein221));
        IJ.log((String)(filein212 + "|" + filein211));
        IJ.log((String)"--------------------");
        tempX1 = img222.getWidth() - 2 * haloX;
        tempX2 = img222.getWidth() - haloX;
        tempY1 = img222.getHeight() - haloY - stepY;
        tempY2 = img222.getHeight() - haloY;
        tempZ1 = img222.getStackSize() - haloZ - stepZ;
        tempZ2 = img222.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img222.getStack().getProcessor(z);
            proc2 = img221.getStack().getProcessor(z);
            x4 = tempX1;
            int xao3 = 0;
            int xbo3 = haloX;
            int xb3 = tempX2;
            while (x4 < tempX2) {
                for (y4 = tempY1; y4 < tempY2; ++y4) {
                    proc2.set(xao3, y4, proc12.get(x4, y4));
                    proc12.set(xb3, y4, proc2.get(xbo3, y4));
                }
                ++x4;
                ++xb3;
                ++xao3;
                ++xbo3;
            }
        }
        tempX1 = img222.getWidth() - haloX - stepX;
        tempX2 = img222.getWidth() - haloX;
        tempY1 = img222.getHeight() - 2 * haloY;
        tempY2 = img222.getHeight() - haloY;
        tempZ1 = img222.getStackSize() - haloZ - stepZ;
        tempZ2 = img222.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            proc12 = img222.getStack().getProcessor(z);
            proc2 = img212.getStack().getProcessor(z);
            for (x4 = tempX1; x4 < tempX2; ++x4) {
                int y5 = tempY1;
                int yao3 = 0;
                int ybo3 = haloY;
                int yb3 = tempY2;
                while (y5 < tempY2) {
                    proc2.set(x4, yao3, proc12.get(x4, y5));
                    proc12.set(x4, yb3, proc2.get(x4, ybo3));
                    ++y5;
                    ++yb3;
                    ++yao3;
                    ++ybo3;
                }
            }
        }
        tempX1 = img222.getWidth() - haloX - stepX;
        tempX2 = img222.getWidth() - haloX;
        tempY1 = img222.getHeight() - haloY - stepY;
        tempY2 = img222.getHeight() - haloY;
        tempZ1 = img222.getStackSize() - 2 * haloZ;
        tempZ2 = img222.getStackSize() - haloZ;
        z = tempZ1 + 1;
        int zao = 1;
        while (z <= tempZ2) {
            proc1 = img222.getStack().getProcessor(z);
            ImageProcessor proc22 = img122.getStack().getProcessor(zao);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc22.set(x3, y3, proc1.get(x3, y3));
                }
            }
            ++z;
            ++zao;
        }
        int zb = tempZ2 + 1;
        int zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img222.getStack().getProcessor(zb);
            ImageProcessor proc23 = img122.getStack().getProcessor(zbo);
            for (x3 = tempX1; x3 < tempX2; ++x3) {
                for (y3 = tempY1; y3 < tempY2; ++y3) {
                    proc1.set(x3, y3, proc23.get(x3, y3));
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img222.getWidth() - 2 * haloX;
        tempX2 = img222.getWidth() - haloX;
        tempY1 = img222.getHeight() - 2 * haloY;
        tempY2 = img222.getHeight() - haloY;
        tempZ1 = img222.getStackSize() - haloZ - stepZ;
        tempZ2 = img222.getStackSize() - haloZ;
        for (z = tempZ1 + 1; z <= tempZ2; ++z) {
            ImageProcessor proc13 = img222.getStack().getProcessor(z);
            proc2 = img211.getStack().getProcessor(z);
            ImageProcessor proc1v = img221.getStack().getProcessor(z);
            ImageProcessor proc2v = img212.getStack().getProcessor(z);
            int x5 = tempX1;
            int xao4 = 0;
            int xbo4 = haloX;
            int xb4 = tempX2;
            while (x5 < tempX2) {
                int y6 = tempY1;
                int yao4 = 0;
                int ybo4 = haloY;
                int yb4 = tempY2;
                while (y6 < tempY2) {
                    proc2.set(xao4, yao4, proc13.get(x5, y6));
                    proc13.set(xb4, yb4, proc2.get(xbo4, ybo4));
                    proc2v.set(xb4, yao4, proc1v.get(xbo4, y6));
                    proc1v.set(xao4, yb4, proc2v.get(x5, ybo4));
                    ++y6;
                    ++yb4;
                    ++yao4;
                    ++ybo4;
                }
                ++x5;
                ++xb4;
                ++xao4;
                ++xbo4;
            }
        }
        tempX1 = img222.getWidth() - 2 * haloX;
        tempX2 = img222.getWidth() - haloX;
        tempY1 = img222.getHeight() - haloY - stepY;
        tempY2 = img222.getHeight() - haloY;
        tempZ1 = img222.getStackSize() - 2 * haloZ;
        tempZ2 = img222.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img222.getStack().getProcessor(z);
            ImageProcessor proc24 = img121.getStack().getProcessor(zao);
            ImageProcessor proc1v = img221.getStack().getProcessor(z);
            ImageProcessor proc2v = img122.getStack().getProcessor(zao);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc24.set(xao2, y2, proc1.get(x2, y2));
                    proc2v.set(xb2, y2, proc1v.get(xbo2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img222.getStack().getProcessor(zb);
            ImageProcessor proc25 = img121.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img221.getStack().getProcessor(zb);
            ImageProcessor proc2v = img122.getStack().getProcessor(zbo);
            x2 = tempX1;
            xao2 = 0;
            xbo2 = haloX;
            xb2 = tempX2;
            while (x2 < tempX2) {
                for (y2 = tempY1; y2 < tempY2; ++y2) {
                    proc1.set(xb2, y2, proc25.get(xbo2, y2));
                    proc1v.set(xao2, y2, proc2v.get(x2, y2));
                }
                ++x2;
                ++xb2;
                ++xao2;
                ++xbo2;
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img222.getWidth() - haloX - stepX;
        tempX2 = img222.getWidth() - haloX;
        tempY1 = img222.getHeight() - 2 * haloY;
        tempY2 = img222.getHeight() - haloY;
        tempZ1 = img222.getStackSize() - 2 * haloZ;
        tempZ2 = img222.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        while (z <= tempZ2) {
            proc1 = img222.getStack().getProcessor(z);
            ImageProcessor proc26 = img112.getStack().getProcessor(zao);
            ImageProcessor proc1v = img212.getStack().getProcessor(z);
            ImageProcessor proc2v = img122.getStack().getProcessor(zao);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc26.set(x2, yao2, proc1.get(x2, y4));
                    proc2v.set(x2, yb2, proc1v.get(x2, ybo2));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++z;
            ++zao;
        }
        zb = tempZ2 + 1;
        zbo = haloZ + 1;
        while (zb <= tempZ2 + haloZ) {
            proc1 = img222.getStack().getProcessor(zb);
            ImageProcessor proc27 = img112.getStack().getProcessor(zbo);
            ImageProcessor proc1v = img212.getStack().getProcessor(zb);
            ImageProcessor proc2v = img122.getStack().getProcessor(zbo);
            for (x2 = tempX1; x2 < tempX2; ++x2) {
                y4 = tempY1;
                yao2 = 0;
                ybo2 = haloY;
                yb2 = tempY2;
                while (y4 < tempY2) {
                    proc1.set(x2, yb2, proc27.get(x2, ybo2));
                    proc1v.set(x2, yao2, proc2v.get(x2, y4));
                    ++y4;
                    ++yb2;
                    ++yao2;
                    ++ybo2;
                }
            }
            ++zb;
            ++zbo;
        }
        tempX1 = img222.getWidth() - 2 * haloX;
        tempX2 = img222.getWidth() - haloX;
        tempY1 = img222.getHeight() - 2 * haloY;
        tempY2 = img222.getHeight() - haloY;
        tempZ1 = img222.getStackSize() - 2 * haloZ;
        tempZ2 = img222.getStackSize() - haloZ;
        z = tempZ1 + 1;
        zao = 1;
        int zb2 = tempZ2 + 1;
        int zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc14 = img222.getStack().getProcessor(z);
            ImageProcessor proc28 = img111.getStack().getProcessor(zao);
            ImageProcessor proc1v1 = img221.getStack().getProcessor(z);
            ImageProcessor proc2v1 = img112.getStack().getProcessor(zao);
            ImageProcessor proc1v2 = img212.getStack().getProcessor(z);
            ImageProcessor proc2v2 = img121.getStack().getProcessor(zao);
            ImageProcessor proc1v3 = img211.getStack().getProcessor(z);
            ImageProcessor proc2v3 = img122.getStack().getProcessor(zao);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc28.set(xao, yao, proc14.get(x, y));
                    proc2v1.set(xb, yao, proc1v1.get(xbo, y));
                    proc2v2.set(xao, yb, proc1v2.get(x, ybo));
                    proc2v3.set(xb, yb, proc1v3.get(xbo, ybo));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
        z = tempZ1 + 1;
        zao = 1;
        zb2 = tempZ2 + 1;
        zbo2 = haloZ + 1;
        while (z <= tempZ2) {
            ImageProcessor proc15 = img222.getStack().getProcessor(zb2);
            ImageProcessor proc29 = img111.getStack().getProcessor(zbo2);
            ImageProcessor proc1v1 = img221.getStack().getProcessor(zb2);
            ImageProcessor proc2v1 = img112.getStack().getProcessor(zbo2);
            ImageProcessor proc1v2 = img212.getStack().getProcessor(zb2);
            ImageProcessor proc2v2 = img121.getStack().getProcessor(zbo2);
            ImageProcessor proc1v3 = img211.getStack().getProcessor(zb2);
            ImageProcessor proc2v3 = img122.getStack().getProcessor(zbo2);
            x = tempX1;
            xao = 0;
            xbo = haloX;
            xb = tempX2;
            while (x < tempX2) {
                y = tempY1;
                yao = 0;
                ybo = haloY;
                yb = tempY2;
                while (y < tempY2) {
                    proc15.set(xb, yb, proc29.get(xbo, ybo));
                    proc1v1.set(xao, yb, proc2v1.get(x, ybo));
                    proc1v2.set(xb, yao, proc2v2.get(xbo, y));
                    proc1v3.set(xao, yao, proc2v3.get(x, y));
                    ++y;
                    ++yb;
                    ++yao;
                    ++ybo;
                }
                ++x;
                ++xb;
                ++xao;
                ++xbo;
            }
            ++z;
            ++zao;
            ++zb2;
            ++zbo2;
        }
    }

    private void docleanexchange() {
        IJ.log((String)("clean" + String.valueOf(configuration[0]) + String.valueOf(configuration[1]) + String.valueOf(configuration[2])));
        if (!(requireClean[0].booleanValue() || requireClean[1].booleanValue() || requireClean[2].booleanValue())) {
            return;
        }
        if (configuration[0] == 0) {
            if (configuration[1] == 0) {
                if (configuration[2] == 0) {
                    this.docleanexchangetype000();
                } else {
                    this.docleanexchangetype001();
                }
            } else if (configuration[2] == 0) {
                this.docleanexchangetype010();
            } else {
                this.docleanexchangetype011();
            }
        } else if (configuration[1] == 0) {
            if (configuration[2] == 0) {
                this.docleanexchangetype100();
            } else {
                this.docleanexchangetype101();
            }
        } else if (configuration[2] == 0) {
            this.docleanexchangetype110();
        } else {
            this.docleanexchangetype111();
        }
    }

    private void docleanexchangetype000() {
        int zb;
        int y;
        int x;
        ImageProcessor proc1;
        int yb;
        int ybo;
        int yao;
        int y2;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int y3;
        int xb;
        int xbo;
        int xao;
        int x2;
        ImageProcessor proc22;
        ImageProcessor proc21;
        int z;
        if (requireClean[1].booleanValue()) {
            tempX1 = img121.getWidth() - 2 * haloX;
            tempX2 = img121.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img121.getHeight();
            tempZ1 = img121.getStackSize() - haloZ - stepZ;
            tempZ2 = img121.getStackSize() - haloZ;
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img121.getStack().getProcessor(z);
                proc22 = img122.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = img211.getWidth() - 2 * haloX;
            tempX2 = img211.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img211.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img211.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img211.getStack().getProcessor(z);
                proc22 = img212.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = img221.getWidth() - 2 * haloX;
            tempX2 = img221.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img221.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img221.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img221.getStack().getProcessor(z);
                proc22 = img222.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img112.getWidth();
            tempY1 = img112.getHeight() - 2 * haloY;
            tempY2 = img112.getHeight() - haloY;
            tempZ1 = img112.getStackSize() - haloZ - stepZ;
            tempZ2 = img112.getStackSize() - haloZ;
            IJ.log((String)("X: " + String.valueOf(tempX1) + "<" + String.valueOf(tempX2)));
            IJ.log((String)("Y: " + String.valueOf(tempY1) + "<" + String.valueOf(tempY2)));
            IJ.log((String)("Yo: " + String.valueOf(0) + "<" + String.valueOf(tempY2 - tempY1)));
            IJ.log((String)("Z: " + String.valueOf(tempZ1) + "<" + String.valueOf(tempZ2)));
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img112.getStack().getProcessor(z);
                proc2 = img122.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img211.getWidth();
            tempY1 = img211.getHeight() - 2 * haloY;
            tempY2 = img211.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img211.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img211.getStack().getProcessor(z);
                proc2 = img221.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue() && requireClean[1].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img212.getWidth();
            tempY1 = img212.getHeight() - 2 * haloY;
            tempY2 = img212.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img212.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img212.getStack().getProcessor(z);
                proc2 = img222.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img112.getWidth();
            tempY1 = img112.getHeight() - haloY - stepY;
            tempY2 = img112.getHeight() - haloY;
            tempZ1 = img112.getStackSize() - 2 * haloZ;
            tempZ2 = img112.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img112.getStack().getProcessor(z);
                ImageProcessor proc23 = img212.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc23.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img112.getStack().getProcessor(zb);
                ImageProcessor proc24 = img212.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc24.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue()) {
            tempX1 = img121.getWidth() - haloX - stepX;
            tempX2 = img121.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img121.getHeight();
            tempZ1 = img121.getStackSize() - 2 * haloZ;
            tempZ2 = img121.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img121.getStack().getProcessor(z);
                ImageProcessor proc25 = img221.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc25.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img121.getStack().getProcessor(zb);
                ImageProcessor proc26 = img221.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc26.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img122.getWidth();
            tempY1 = haloY;
            tempY2 = img122.getHeight();
            tempZ1 = img122.getStackSize() - 2 * haloZ;
            tempZ2 = img122.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img122.getStack().getProcessor(z);
                ImageProcessor proc27 = img222.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc27.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img122.getStack().getProcessor(zb);
                ImageProcessor proc28 = img222.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc28.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
    }

    private void docleanexchangetype001() {
        int zb;
        int y;
        int x;
        ImageProcessor proc1;
        int yb;
        int ybo;
        int yao;
        int y2;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int y3;
        int xb;
        int xbo;
        int xao;
        int x2;
        ImageProcessor proc22;
        ImageProcessor proc21;
        int z;
        if (requireClean[1].booleanValue()) {
            tempX1 = img122.getWidth() - 2 * haloX;
            tempX2 = img122.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img122.getHeight();
            tempZ1 = img122.getStackSize() - haloZ - stepZ;
            tempZ2 = img122.getStackSize() - haloZ;
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img122.getStack().getProcessor(z);
                proc22 = img121.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = img212.getWidth() - 2 * haloX;
            tempX2 = img212.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img212.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img212.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img212.getStack().getProcessor(z);
                proc22 = img211.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = img222.getWidth() - 2 * haloX;
            tempX2 = img222.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img222.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img222.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img222.getStack().getProcessor(z);
                proc22 = img221.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img111.getWidth();
            tempY1 = img111.getHeight() - 2 * haloY;
            tempY2 = img111.getHeight() - haloY;
            tempZ1 = img111.getStackSize() - haloZ - stepZ;
            tempZ2 = img111.getStackSize() - haloZ;
            IJ.log((String)("X: " + String.valueOf(tempX1) + "<" + String.valueOf(tempX2)));
            IJ.log((String)("Y: " + String.valueOf(tempY1) + "<" + String.valueOf(tempY2)));
            IJ.log((String)("Yo: " + String.valueOf(0) + "<" + String.valueOf(tempY2 - tempY1)));
            IJ.log((String)("Z: " + String.valueOf(tempZ1) + "<" + String.valueOf(tempZ2)));
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img111.getStack().getProcessor(z);
                proc2 = img121.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img212.getWidth();
            tempY1 = img212.getHeight() - 2 * haloY;
            tempY2 = img212.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img212.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img212.getStack().getProcessor(z);
                proc2 = img222.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue() && requireClean[1].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img211.getWidth();
            tempY1 = img211.getHeight() - 2 * haloY;
            tempY2 = img211.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img211.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img211.getStack().getProcessor(z);
                proc2 = img221.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img111.getWidth();
            tempY1 = img111.getHeight() - haloY - stepY;
            tempY2 = img111.getHeight() - haloY;
            tempZ1 = img111.getStackSize() - 2 * haloZ;
            tempZ2 = img111.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img111.getStack().getProcessor(z);
                ImageProcessor proc23 = img211.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc23.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img111.getStack().getProcessor(zb);
                ImageProcessor proc24 = img211.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc24.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue()) {
            tempX1 = img122.getWidth() - haloX - stepX;
            tempX2 = img122.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img122.getHeight();
            tempZ1 = img122.getStackSize() - 2 * haloZ;
            tempZ2 = img122.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img122.getStack().getProcessor(z);
                ImageProcessor proc25 = img222.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc25.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img122.getStack().getProcessor(zb);
                ImageProcessor proc26 = img222.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc26.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img121.getWidth();
            tempY1 = haloY;
            tempY2 = img121.getHeight();
            tempZ1 = img121.getStackSize() - 2 * haloZ;
            tempZ2 = img121.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img121.getStack().getProcessor(z);
                ImageProcessor proc27 = img221.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc27.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img121.getStack().getProcessor(zb);
                ImageProcessor proc28 = img221.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc28.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
    }

    private void docleanexchangetype010() {
        int zb;
        int y;
        int x;
        ImageProcessor proc1;
        int yb;
        int ybo;
        int yao;
        int y2;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int y3;
        int xb;
        int xbo;
        int xao;
        int x2;
        ImageProcessor proc22;
        ImageProcessor proc21;
        int z;
        if (requireClean[1].booleanValue()) {
            tempX1 = img111.getWidth() - 2 * haloX;
            tempX2 = img111.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img111.getHeight();
            tempZ1 = img111.getStackSize() - haloZ - stepZ;
            tempZ2 = img111.getStackSize() - haloZ;
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img111.getStack().getProcessor(z);
                proc22 = img112.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = img221.getWidth() - 2 * haloX;
            tempX2 = img221.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img221.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img221.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img221.getStack().getProcessor(z);
                proc22 = img222.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = img211.getWidth() - 2 * haloX;
            tempX2 = img211.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img211.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img211.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img211.getStack().getProcessor(z);
                proc22 = img212.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img122.getWidth();
            tempY1 = img122.getHeight() - 2 * haloY;
            tempY2 = img122.getHeight() - haloY;
            tempZ1 = img122.getStackSize() - haloZ - stepZ;
            tempZ2 = img122.getStackSize() - haloZ;
            IJ.log((String)("X: " + String.valueOf(tempX1) + "<" + String.valueOf(tempX2)));
            IJ.log((String)("Y: " + String.valueOf(tempY1) + "<" + String.valueOf(tempY2)));
            IJ.log((String)("Yo: " + String.valueOf(0) + "<" + String.valueOf(tempY2 - tempY1)));
            IJ.log((String)("Z: " + String.valueOf(tempZ1) + "<" + String.valueOf(tempZ2)));
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img122.getStack().getProcessor(z);
                proc2 = img112.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img221.getWidth();
            tempY1 = img221.getHeight() - 2 * haloY;
            tempY2 = img221.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img221.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img221.getStack().getProcessor(z);
                proc2 = img211.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue() && requireClean[1].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img222.getWidth();
            tempY1 = img222.getHeight() - 2 * haloY;
            tempY2 = img222.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img222.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img222.getStack().getProcessor(z);
                proc2 = img212.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img122.getWidth();
            tempY1 = img122.getHeight() - haloY - stepY;
            tempY2 = img122.getHeight() - haloY;
            tempZ1 = img122.getStackSize() - 2 * haloZ;
            tempZ2 = img122.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img122.getStack().getProcessor(z);
                ImageProcessor proc23 = img222.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc23.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img122.getStack().getProcessor(zb);
                ImageProcessor proc24 = img222.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc24.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue()) {
            tempX1 = img111.getWidth() - haloX - stepX;
            tempX2 = img111.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img111.getHeight();
            tempZ1 = img111.getStackSize() - 2 * haloZ;
            tempZ2 = img111.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img111.getStack().getProcessor(z);
                ImageProcessor proc25 = img211.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc25.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img111.getStack().getProcessor(zb);
                ImageProcessor proc26 = img211.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc26.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img112.getWidth();
            tempY1 = haloY;
            tempY2 = img112.getHeight();
            tempZ1 = img112.getStackSize() - 2 * haloZ;
            tempZ2 = img112.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img112.getStack().getProcessor(z);
                ImageProcessor proc27 = img212.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc27.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img112.getStack().getProcessor(zb);
                ImageProcessor proc28 = img212.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc28.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
    }

    private void docleanexchangetype011() {
        int zb;
        int y;
        int x;
        ImageProcessor proc1;
        int yb;
        int ybo;
        int yao;
        int y2;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int y3;
        int xb;
        int xbo;
        int xao;
        int x2;
        ImageProcessor proc22;
        ImageProcessor proc21;
        int z;
        if (requireClean[1].booleanValue()) {
            tempX1 = img112.getWidth() - 2 * haloX;
            tempX2 = img112.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img112.getHeight();
            tempZ1 = img112.getStackSize() - haloZ - stepZ;
            tempZ2 = img112.getStackSize() - haloZ;
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img112.getStack().getProcessor(z);
                proc22 = img111.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = img222.getWidth() - 2 * haloX;
            tempX2 = img222.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img222.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img222.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img222.getStack().getProcessor(z);
                proc22 = img221.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = img212.getWidth() - 2 * haloX;
            tempX2 = img212.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img212.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img212.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img212.getStack().getProcessor(z);
                proc22 = img211.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img121.getWidth();
            tempY1 = img121.getHeight() - 2 * haloY;
            tempY2 = img121.getHeight() - haloY;
            tempZ1 = img121.getStackSize() - haloZ - stepZ;
            tempZ2 = img121.getStackSize() - haloZ;
            IJ.log((String)("X: " + String.valueOf(tempX1) + "<" + String.valueOf(tempX2)));
            IJ.log((String)("Y: " + String.valueOf(tempY1) + "<" + String.valueOf(tempY2)));
            IJ.log((String)("Yo: " + String.valueOf(0) + "<" + String.valueOf(tempY2 - tempY1)));
            IJ.log((String)("Z: " + String.valueOf(tempZ1) + "<" + String.valueOf(tempZ2)));
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img121.getStack().getProcessor(z);
                proc2 = img111.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img222.getWidth();
            tempY1 = img222.getHeight() - 2 * haloY;
            tempY2 = img222.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img222.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img222.getStack().getProcessor(z);
                proc2 = img212.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue() && requireClean[1].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img221.getWidth();
            tempY1 = img221.getHeight() - 2 * haloY;
            tempY2 = img221.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img221.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img221.getStack().getProcessor(z);
                proc2 = img211.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img121.getWidth();
            tempY1 = img121.getHeight() - haloY - stepY;
            tempY2 = img121.getHeight() - haloY;
            tempZ1 = img121.getStackSize() - 2 * haloZ;
            tempZ2 = img121.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img121.getStack().getProcessor(z);
                ImageProcessor proc23 = img221.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc23.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img121.getStack().getProcessor(zb);
                ImageProcessor proc24 = img221.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc24.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue()) {
            tempX1 = img112.getWidth() - haloX - stepX;
            tempX2 = img112.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img112.getHeight();
            tempZ1 = img112.getStackSize() - 2 * haloZ;
            tempZ2 = img112.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img112.getStack().getProcessor(z);
                ImageProcessor proc25 = img212.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc25.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img112.getStack().getProcessor(zb);
                ImageProcessor proc26 = img212.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc26.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img111.getWidth();
            tempY1 = haloY;
            tempY2 = img111.getHeight();
            tempZ1 = img111.getStackSize() - 2 * haloZ;
            tempZ2 = img111.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img111.getStack().getProcessor(z);
                ImageProcessor proc27 = img211.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc27.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img111.getStack().getProcessor(zb);
                ImageProcessor proc28 = img211.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc28.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
    }

    private void docleanexchangetype100() {
        int zb;
        int y;
        int x;
        ImageProcessor proc1;
        int yb;
        int ybo;
        int yao;
        int y2;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int y3;
        int xb;
        int xbo;
        int xao;
        int x2;
        ImageProcessor proc22;
        ImageProcessor proc21;
        int z;
        if (requireClean[1].booleanValue()) {
            tempX1 = img221.getWidth() - 2 * haloX;
            tempX2 = img221.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img221.getHeight();
            tempZ1 = img221.getStackSize() - haloZ - stepZ;
            tempZ2 = img221.getStackSize() - haloZ;
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img221.getStack().getProcessor(z);
                proc22 = img222.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = img111.getWidth() - 2 * haloX;
            tempX2 = img111.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img111.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img111.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img111.getStack().getProcessor(z);
                proc22 = img112.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = img121.getWidth() - 2 * haloX;
            tempX2 = img121.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img121.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img121.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img121.getStack().getProcessor(z);
                proc22 = img122.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img212.getWidth();
            tempY1 = img212.getHeight() - 2 * haloY;
            tempY2 = img212.getHeight() - haloY;
            tempZ1 = img212.getStackSize() - haloZ - stepZ;
            tempZ2 = img212.getStackSize() - haloZ;
            IJ.log((String)("X: " + String.valueOf(tempX1) + "<" + String.valueOf(tempX2)));
            IJ.log((String)("Y: " + String.valueOf(tempY1) + "<" + String.valueOf(tempY2)));
            IJ.log((String)("Yo: " + String.valueOf(0) + "<" + String.valueOf(tempY2 - tempY1)));
            IJ.log((String)("Z: " + String.valueOf(tempZ1) + "<" + String.valueOf(tempZ2)));
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img212.getStack().getProcessor(z);
                proc2 = img222.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img111.getWidth();
            tempY1 = img111.getHeight() - 2 * haloY;
            tempY2 = img111.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img111.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img111.getStack().getProcessor(z);
                proc2 = img121.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue() && requireClean[1].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img112.getWidth();
            tempY1 = img112.getHeight() - 2 * haloY;
            tempY2 = img112.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img112.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img112.getStack().getProcessor(z);
                proc2 = img122.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img212.getWidth();
            tempY1 = img212.getHeight() - haloY - stepY;
            tempY2 = img212.getHeight() - haloY;
            tempZ1 = img212.getStackSize() - 2 * haloZ;
            tempZ2 = img212.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img212.getStack().getProcessor(z);
                ImageProcessor proc23 = img112.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc23.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img212.getStack().getProcessor(zb);
                ImageProcessor proc24 = img112.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc24.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue()) {
            tempX1 = img221.getWidth() - haloX - stepX;
            tempX2 = img221.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img221.getHeight();
            tempZ1 = img221.getStackSize() - 2 * haloZ;
            tempZ2 = img221.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img221.getStack().getProcessor(z);
                ImageProcessor proc25 = img121.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc25.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img221.getStack().getProcessor(zb);
                ImageProcessor proc26 = img121.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc26.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img222.getWidth();
            tempY1 = haloY;
            tempY2 = img222.getHeight();
            tempZ1 = img222.getStackSize() - 2 * haloZ;
            tempZ2 = img222.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img222.getStack().getProcessor(z);
                ImageProcessor proc27 = img122.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc27.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img222.getStack().getProcessor(zb);
                ImageProcessor proc28 = img122.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc28.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
    }

    private void docleanexchangetype101() {
        int zb;
        int y;
        int x;
        ImageProcessor proc1;
        int yb;
        int ybo;
        int yao;
        int y2;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int y3;
        int xb;
        int xbo;
        int xao;
        int x2;
        ImageProcessor proc22;
        ImageProcessor proc21;
        int z;
        if (requireClean[1].booleanValue()) {
            tempX1 = img222.getWidth() - 2 * haloX;
            tempX2 = img222.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img222.getHeight();
            tempZ1 = img222.getStackSize() - haloZ - stepZ;
            tempZ2 = img222.getStackSize() - haloZ;
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img222.getStack().getProcessor(z);
                proc22 = img221.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = img112.getWidth() - 2 * haloX;
            tempX2 = img112.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img112.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img112.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img112.getStack().getProcessor(z);
                proc22 = img111.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = img122.getWidth() - 2 * haloX;
            tempX2 = img122.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img122.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img122.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img122.getStack().getProcessor(z);
                proc22 = img121.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img211.getWidth();
            tempY1 = img211.getHeight() - 2 * haloY;
            tempY2 = img211.getHeight() - haloY;
            tempZ1 = img211.getStackSize() - haloZ - stepZ;
            tempZ2 = img211.getStackSize() - haloZ;
            IJ.log((String)("X: " + String.valueOf(tempX1) + "<" + String.valueOf(tempX2)));
            IJ.log((String)("Y: " + String.valueOf(tempY1) + "<" + String.valueOf(tempY2)));
            IJ.log((String)("Yo: " + String.valueOf(0) + "<" + String.valueOf(tempY2 - tempY1)));
            IJ.log((String)("Z: " + String.valueOf(tempZ1) + "<" + String.valueOf(tempZ2)));
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img211.getStack().getProcessor(z);
                proc2 = img221.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img112.getWidth();
            tempY1 = img112.getHeight() - 2 * haloY;
            tempY2 = img112.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img112.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img112.getStack().getProcessor(z);
                proc2 = img122.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue() && requireClean[1].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img111.getWidth();
            tempY1 = img111.getHeight() - 2 * haloY;
            tempY2 = img111.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img111.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img111.getStack().getProcessor(z);
                proc2 = img121.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img211.getWidth();
            tempY1 = img211.getHeight() - haloY - stepY;
            tempY2 = img211.getHeight() - haloY;
            tempZ1 = img211.getStackSize() - 2 * haloZ;
            tempZ2 = img211.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img211.getStack().getProcessor(z);
                ImageProcessor proc23 = img111.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc23.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img211.getStack().getProcessor(zb);
                ImageProcessor proc24 = img111.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc24.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue()) {
            tempX1 = img222.getWidth() - haloX - stepX;
            tempX2 = img222.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img222.getHeight();
            tempZ1 = img222.getStackSize() - 2 * haloZ;
            tempZ2 = img222.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img222.getStack().getProcessor(z);
                ImageProcessor proc25 = img122.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc25.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img222.getStack().getProcessor(zb);
                ImageProcessor proc26 = img122.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc26.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img221.getWidth();
            tempY1 = haloY;
            tempY2 = img221.getHeight();
            tempZ1 = img221.getStackSize() - 2 * haloZ;
            tempZ2 = img221.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img221.getStack().getProcessor(z);
                ImageProcessor proc27 = img121.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc27.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img221.getStack().getProcessor(zb);
                ImageProcessor proc28 = img121.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc28.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
    }

    private void docleanexchangetype110() {
        int zb;
        int y;
        int x;
        ImageProcessor proc1;
        int yb;
        int ybo;
        int yao;
        int y2;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int y3;
        int xb;
        int xbo;
        int xao;
        int x2;
        ImageProcessor proc22;
        ImageProcessor proc21;
        int z;
        if (requireClean[1].booleanValue()) {
            tempX1 = img211.getWidth() - 2 * haloX;
            tempX2 = img211.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img211.getHeight();
            tempZ1 = img211.getStackSize() - haloZ - stepZ;
            tempZ2 = img211.getStackSize() - haloZ;
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img211.getStack().getProcessor(z);
                proc22 = img212.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = img121.getWidth() - 2 * haloX;
            tempX2 = img121.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img121.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img121.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img121.getStack().getProcessor(z);
                proc22 = img122.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = img111.getWidth() - 2 * haloX;
            tempX2 = img111.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img111.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img111.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img111.getStack().getProcessor(z);
                proc22 = img112.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img222.getWidth();
            tempY1 = img222.getHeight() - 2 * haloY;
            tempY2 = img222.getHeight() - haloY;
            tempZ1 = img222.getStackSize() - haloZ - stepZ;
            tempZ2 = img222.getStackSize() - haloZ;
            IJ.log((String)("X: " + String.valueOf(tempX1) + "<" + String.valueOf(tempX2)));
            IJ.log((String)("Y: " + String.valueOf(tempY1) + "<" + String.valueOf(tempY2)));
            IJ.log((String)("Yo: " + String.valueOf(0) + "<" + String.valueOf(tempY2 - tempY1)));
            IJ.log((String)("Z: " + String.valueOf(tempZ1) + "<" + String.valueOf(tempZ2)));
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img222.getStack().getProcessor(z);
                proc2 = img212.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img121.getWidth();
            tempY1 = img121.getHeight() - 2 * haloY;
            tempY2 = img121.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img121.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img121.getStack().getProcessor(z);
                proc2 = img111.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue() && requireClean[1].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img122.getWidth();
            tempY1 = img122.getHeight() - 2 * haloY;
            tempY2 = img122.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img122.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img122.getStack().getProcessor(z);
                proc2 = img112.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img222.getWidth();
            tempY1 = img222.getHeight() - haloY - stepY;
            tempY2 = img222.getHeight() - haloY;
            tempZ1 = img222.getStackSize() - 2 * haloZ;
            tempZ2 = img222.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img222.getStack().getProcessor(z);
                ImageProcessor proc23 = img122.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc23.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img222.getStack().getProcessor(zb);
                ImageProcessor proc24 = img122.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc24.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue()) {
            tempX1 = img211.getWidth() - haloX - stepX;
            tempX2 = img211.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img211.getHeight();
            tempZ1 = img211.getStackSize() - 2 * haloZ;
            tempZ2 = img211.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img211.getStack().getProcessor(z);
                ImageProcessor proc25 = img111.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc25.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img211.getStack().getProcessor(zb);
                ImageProcessor proc26 = img111.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc26.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img212.getWidth();
            tempY1 = haloY;
            tempY2 = img212.getHeight();
            tempZ1 = img212.getStackSize() - 2 * haloZ;
            tempZ2 = img212.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img212.getStack().getProcessor(z);
                ImageProcessor proc27 = img112.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc27.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img212.getStack().getProcessor(zb);
                ImageProcessor proc28 = img112.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc28.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
    }

    private void docleanexchangetype111() {
        int zb;
        int y;
        int x;
        ImageProcessor proc1;
        int yb;
        int ybo;
        int yao;
        int y2;
        ImageProcessor proc2;
        ImageProcessor proc12;
        int y3;
        int xb;
        int xbo;
        int xao;
        int x2;
        ImageProcessor proc22;
        ImageProcessor proc21;
        int z;
        if (requireClean[1].booleanValue()) {
            tempX1 = img212.getWidth() - 2 * haloX;
            tempX2 = img212.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img212.getHeight();
            tempZ1 = img212.getStackSize() - haloZ - stepZ;
            tempZ2 = img212.getStackSize() - haloZ;
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img212.getStack().getProcessor(z);
                proc22 = img211.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = img122.getWidth() - 2 * haloX;
            tempX2 = img122.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img122.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img122.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img122.getStack().getProcessor(z);
                proc22 = img121.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[1].booleanValue() && requireClean[0].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = img112.getWidth() - 2 * haloX;
            tempX2 = img112.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img112.getHeight();
            tempZ1 = haloZ;
            tempZ2 = img112.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc21 = img112.getStack().getProcessor(z);
                proc22 = img111.getStack().getProcessor(z);
                x2 = tempX1;
                xao = 0;
                xbo = haloX;
                xb = tempX2;
                while (x2 < tempX2) {
                    for (y3 = tempY1; y3 < tempY2; ++y3) {
                        proc22.set(xao, y3, proc21.get(x2, y3));
                        proc21.set(xb, y3, proc22.get(xbo, y3));
                    }
                    ++x2;
                    ++xb;
                    ++xao;
                    ++xbo;
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img221.getWidth();
            tempY1 = img221.getHeight() - 2 * haloY;
            tempY2 = img221.getHeight() - haloY;
            tempZ1 = img221.getStackSize() - haloZ - stepZ;
            tempZ2 = img221.getStackSize() - haloZ;
            IJ.log((String)("X: " + String.valueOf(tempX1) + "<" + String.valueOf(tempX2)));
            IJ.log((String)("Y: " + String.valueOf(tempY1) + "<" + String.valueOf(tempY2)));
            IJ.log((String)("Yo: " + String.valueOf(0) + "<" + String.valueOf(tempY2 - tempY1)));
            IJ.log((String)("Z: " + String.valueOf(tempZ1) + "<" + String.valueOf(tempZ2)));
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img221.getStack().getProcessor(z);
                proc2 = img211.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img122.getWidth();
            tempY1 = img122.getHeight() - 2 * haloY;
            tempY2 = img122.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img122.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img122.getStack().getProcessor(z);
                proc2 = img112.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue() && requireClean[0].booleanValue() && requireClean[1].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img121.getWidth();
            tempY1 = img121.getHeight() - 2 * haloY;
            tempY2 = img121.getHeight() - haloY;
            tempZ1 = haloZ;
            tempZ2 = img121.getStackSize();
            for (z = tempZ1 + 1; z <= tempZ2; ++z) {
                proc12 = img121.getStack().getProcessor(z);
                proc2 = img111.getStack().getProcessor(z);
                for (x2 = tempX1; x2 < tempX2; ++x2) {
                    y2 = tempY1;
                    yao = 0;
                    ybo = haloY;
                    yb = tempY2;
                    while (y2 < tempY2) {
                        proc2.set(x2, yao, proc12.get(x2, y2));
                        proc12.set(x2, yb, proc2.get(x2, ybo));
                        ++y2;
                        ++yb;
                        ++yao;
                        ++ybo;
                    }
                }
            }
        }
        if (requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img221.getWidth();
            tempY1 = img221.getHeight() - haloY - stepY;
            tempY2 = img221.getHeight() - haloY;
            tempZ1 = img221.getStackSize() - 2 * haloZ;
            tempZ2 = img221.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img221.getStack().getProcessor(z);
                ImageProcessor proc23 = img121.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc23.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img221.getStack().getProcessor(zb);
                ImageProcessor proc24 = img121.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc24.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue()) {
            tempX1 = img212.getWidth() - haloX - stepX;
            tempX2 = img212.getWidth() - haloX;
            tempY1 = haloY;
            tempY2 = img212.getHeight();
            tempZ1 = img212.getStackSize() - 2 * haloZ;
            tempZ2 = img212.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img212.getStack().getProcessor(z);
                ImageProcessor proc25 = img112.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc25.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img212.getStack().getProcessor(zb);
                ImageProcessor proc26 = img112.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc26.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
        if (requireClean[1].booleanValue() && requireClean[2].booleanValue()) {
            tempX1 = haloX;
            tempX2 = img211.getWidth();
            tempY1 = haloY;
            tempY2 = img211.getHeight();
            tempZ1 = img211.getStackSize() - 2 * haloZ;
            tempZ2 = img211.getStackSize() - haloZ;
            z = tempZ1 + 1;
            int zao = 1;
            while (z <= tempZ2) {
                proc1 = img211.getStack().getProcessor(z);
                ImageProcessor proc27 = img111.getStack().getProcessor(zao);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc27.set(x, y, proc1.get(x, y));
                    }
                }
                ++z;
                ++zao;
            }
            zb = tempZ2 + 1;
            int zbo = haloZ + 1;
            while (zb <= tempZ2 + haloZ) {
                proc1 = img211.getStack().getProcessor(zb);
                ImageProcessor proc28 = img111.getStack().getProcessor(zbo);
                for (x = tempX1; x < tempX2; ++x) {
                    for (y = tempY1; y < tempY2; ++y) {
                        proc1.set(x, y, proc28.get(x, y));
                    }
                }
                ++zb;
                ++zbo;
            }
        }
    }
}

