/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.plugin.BrowserLauncher;
import ij.plugin.PlugIn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import lj.LJPrefs;

public class Help
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_AUTHOR = "L. Wollatz, S. J. Johnston, P. M. Lackie, and S. J. Cox";
    public static final String PLUGIN_AUTHOR_Bib = "Wollatz, Lasse and Johnston, Steven J. and Lackie, Peter M. and Cox, Simon J.";
    public static final String PLUGIN_PubYear = "2016";
    public static final String PLUGIN_URL = "http://sites.imagej.net/LungJ";
    public static final String PLUGIN_PubURL = "http://dx.doi.org/10.5258/SOTON/401280";
    public static final String PLUGIN_Help = "http://imagej.net/LungJ";
    public static final String PLUGIN_JAVA = "1.8.0_40";
    public static final String PLUGIN_TWS = "2.3.0";
    public static final String PLUGIN_IJ = "1.51d";
    public static final String IJ_VERSION = LJPrefs.IJ_VERSION;

    public void run(String arg) {
        if (arg.equals("about")) {
            this.showAbout();
            return;
        }
    }

    private void showAbout() {
        String JAVA_VERSION = "1.4";
        if (IJ.isJava15()) {
            JAVA_VERSION = "1.5";
        }
        if (IJ.isJava16()) {
            JAVA_VERSION = "1.6";
        }
        if (IJ.isJava17()) {
            JAVA_VERSION = "1.7";
        }
        if (IJ.isJava18()) {
            JAVA_VERSION = "1.8 or higher";
        }
        JEditorPane htmlPane = new JEditorPane("text/html", "<html>\n  <body>\n<h1>LungJ version 0.5.1</h1><p>LungJ is an ImageJ plugin designed for (but not limited to) &mu;-CT lung tissue image analysis.</p><p>User and developer documentation can be found on our <a href=http://imagej.net/LungJ>ImageJ Page</a></p><h2>Citing &amp; Referencing</h2><p>When you use this plugin for any of your academic work, please cite LungJ like<br/>L. Wollatz, S. J. Johnston, P. M. Lackie, and S. J. Cox (2016). <i>LungJ</i> [Computer software]. DOI:<a href=http://dx.doi.org/10.5258/SOTON/401280>" + PLUGIN_PubURL.replace("http://dx.doi.org/", "") + "</a>.<br/>" + "</p>" + "<h2>Requirements</h2>" + "<ul>" + "<li>ImageJ " + PLUGIN_IJ + " (currently " + IJ_VERSION + ")</li>" + "<li>Java " + PLUGIN_JAVA + " (currently " + JAVA_VERSION + ") Note that ImageJ comes with its own Java!</li>" + "<li>Trainable Weka Segmentation " + PLUGIN_TWS + " (comes with Fiji)</li>" + "<li>Flood Fill(3D) (comes with Fiji)</li>" + "</ul>" + "\n" + "  </body>\n" + "</html>");
        htmlPane.setEditable(false);
        htmlPane.setOpaque(false);
        htmlPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                    try {
                        BrowserLauncher.openURL((String)e.getURL().toString());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)htmlPane, "Center");
        JFrame frame = new JFrame("About LungJ...");
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
    }
}

