/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import lj.LJPrefs;

public class Invert_Values
implements ExtendedPlugInFilter,
DialogListener {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private boolean previewing = false;
    private FloatProcessor previewEdm;
    private double globMin = 0.0;
    private double globMax = 1.0;
    private int flags = 16810029;

    public int setup(String arg, ImagePlus imp) {
        if (IJ.versionLessThan((String)"1.48n")) {
            return 4096;
        }
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        if (imp == null) {
            return 4096;
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        float[] minmax = new float[2];
        minmax = LJPrefs.getMinMax(imp);
        this.globMin = minmax[0];
        this.globMax = minmax[1];
        GenericDialog gd = new GenericDialog(command + "...");
        gd.addNumericField("minimum Value", this.globMin, 4);
        gd.addNumericField("maximum Value", this.globMax, 4);
        gd.addPreviewCheckbox(pfr);
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.addDialogListener((DialogListener)this);
        this.previewing = true;
        gd.showDialog();
        this.previewing = false;
        if (gd.wasCanceled()) {
            return 4096;
        }
        IJ.register(this.getClass());
        return IJ.setupDialog((ImagePlus)imp, (int)this.flags);
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        this.globMin = gd.getNextNumber();
        this.globMax = gd.getNextNumber();
        return !gd.invalidNumber();
    }

    public void run(ImageProcessor ip) {
        block15: {
            Rectangle roiRect;
            double tsum;
            double tmax;
            double tmin;
            int width;
            block16: {
                block14: {
                    FloatProcessor floatIP;
                    width = ip.getWidth();
                    int height = ip.getHeight();
                    tmin = this.globMin;
                    tmax = this.globMax;
                    tsum = tmax + tmin;
                    if (this.previewing && this.previewEdm != null) {
                        floatIP = this.previewEdm;
                    } else {
                        this.previewEdm = floatIP = new FloatProcessor(width, height, (float[])ip.convertToFloat().getPixels());
                    }
                    roiRect = ip.getRoi();
                    if (ip.getBitDepth() != 8) break block14;
                    byte[] bPixels = (byte[])ip.getPixels();
                    for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                        int x = roiRect.x;
                        int p = x + y * width;
                        while (x < roiRect.x + roiRect.width) {
                            tsum = tmax + tmin - (double)bPixels[p];
                            if ((double)(bPixels[p] & 0xFF) < tmin) {
                                tsum = tmax;
                            }
                            if ((double)(bPixels[p] & 0xFF) > tmax) {
                                tsum = tmin;
                            }
                            bPixels[p] = (byte)tsum;
                            ++x;
                            ++p;
                        }
                    }
                    break block15;
                }
                if (ip.getBitDepth() != 16) break block16;
                short[] bPixels = (short[])ip.getPixels();
                for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                    int x = roiRect.x;
                    int p = x + y * width;
                    while (x < roiRect.x + roiRect.width) {
                        tsum = tmax + tmin - (double)bPixels[p];
                        if ((double)(bPixels[p] & 0xFFFF) < tmin) {
                            tsum = tmax;
                        }
                        if ((double)(bPixels[p] & 0xFFFF) > tmax) {
                            tsum = tmin;
                        }
                        bPixels[p] = (short)tsum;
                        ++x;
                        ++p;
                    }
                }
                break block15;
            }
            if (ip.getBitDepth() != 32) break block15;
            float[] bPixels = (float[])ip.getPixels();
            for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                int x = roiRect.x;
                int p = x + y * width;
                while (x < roiRect.x + roiRect.width) {
                    tsum = tmax + tmin - (double)bPixels[p];
                    if ((double)bPixels[p] < tmin) {
                        tsum = tmax;
                    }
                    if ((double)bPixels[p] > tmax) {
                        tsum = tmin;
                    }
                    bPixels[p] = (float)tsum;
                    ++x;
                    ++p;
                }
            }
        }
    }

    public void setNPasses(int nPasses) {
    }

    void showAbout() {
        IJ.showMessage((String)"About Invert Values...", (String)"This plugin filter inverts 8-bit, 16-bit and 32-bit images.\nThe default minimum and maximum value suggested equal the\nglobal minimum and maximum value of the hyperstack. Values \nare being mirrored at the centre between minimum and maximum\nand are saturated at the boundaries.\n");
    }
}

