/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;

public class Label_Hyperstack
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";

    public void run(String command) {
        int c;
        int f;
        IJ.showStatus((String)"Labeling Hyperstack");
        ImagePlus image = WindowManager.getCurrentImage();
        int tChannels = image.getNChannels();
        int tFrames = image.getNFrames();
        int tSlices = image.getNSlices();
        int tWidth = image.getWidth();
        int tHeight = image.getHeight();
        Calibration cal = image.getCalibration();
        Double xres = cal.pixelWidth;
        Double yres = cal.pixelHeight;
        Double zres = cal.pixelDepth;
        int a = 0;
        int b = 0;
        String unit = "";
        String dimstr = "";
        Object prop = image.getProperty("Info");
        String imginfo = (String)prop;
        a = imginfo.indexOf("\nXResolution ");
        a = imginfo.indexOf("\nUnit ");
        if (a > 0) {
            a = imginfo.indexOf("=", a) + 2;
            b = imginfo.indexOf("\n", a);
            unit = imginfo.substring(a, b);
            dimstr = " (" + (double)tWidth * xres + "x" + (double)tHeight * yres + "x" + (double)tSlices * zres + " " + unit + ")";
        }
        String[] ChannelNames = new String[tChannels];
        String[] FrameNames = new String[tFrames];
        Double FramelabelStart = 0.0;
        Double FramelabelInc = 1.0;
        String FramelabelEnd = "";
        Double SlicelabelStart = 0.0;
        Double SlicelabelInc = zres;
        String SlicelabelEnd = unit;
        String seperator = " - ";
        boolean doSliceN = true;
        boolean doFrameN = true;
        Double tempnum = 0.0;
        GenericDialog gd = new GenericDialog(command + " Relabel Image Slices");
        gd.addMessage("Dimensions: " + tWidth + "x" + tHeight + "x" + tSlices + " px" + dimstr);
        if (tFrames > 10) {
            gd.addMessage("Frame Labels:");
            gd.addCheckbox("frame number included", doFrameN);
            gd.addStringField("frame_starting_string", "t = ", 40);
            gd.addNumericField("frame_starting_number", FramelabelStart.doubleValue(), 5);
            gd.addNumericField("frame_increment_number", FramelabelInc.doubleValue(), 5);
            gd.addStringField("frame_ending_string", FramelabelEnd, 5);
        } else if (tFrames > 1) {
            gd.addMessage("Frame Labels:");
            for (f = 1; f <= tFrames; ++f) {
                gd.addStringField("Frame-" + f, "", 40);
            }
        } else {
            gd.addMessage("(only single frame found)");
        }
        if (tChannels > 1) {
            gd.addMessage("Channel Labels:");
            for (c = 1; c <= tChannels; ++c) {
                gd.addStringField("Channel-" + c, "", 40);
            }
        } else {
            gd.addMessage("(only single channel found)");
        }
        gd.addMessage("Slice Labels:");
        gd.addCheckbox("slice number included", doSliceN);
        gd.addNumericField("slice_starting_number", SlicelabelStart.doubleValue(), 5);
        gd.addNumericField("slice_increment_number", SlicelabelInc.doubleValue(), 5);
        gd.addStringField("slice_ending_string", SlicelabelEnd, 5);
        gd.addMessage("Settings:");
        gd.addStringField("Seperator", seperator, 5);
        IJ.showStatus((String)"Waiting for User Input...");
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            IJ.showProgress((int)100, (int)100);
            return;
        }
        IJ.showStatus((String)"Labeling Hyperstack");
        if (tFrames > 10) {
            doFrameN = gd.getNextBoolean();
            FrameNames[0] = gd.getNextString();
            FramelabelStart = gd.getNextNumber();
            FramelabelInc = gd.getNextNumber();
            FramelabelEnd = gd.getNextString();
        } else if (tFrames > 1) {
            for (f = 0; f < tFrames; ++f) {
                FrameNames[f] = gd.getNextString();
            }
        }
        if (tChannels > 1) {
            for (c = 0; c < tChannels; ++c) {
                ChannelNames[c] = gd.getNextString();
            }
        }
        doSliceN = gd.getNextBoolean();
        SlicelabelStart = gd.getNextNumber();
        SlicelabelInc = gd.getNextNumber();
        SlicelabelEnd = gd.getNextString();
        seperator = gd.getNextString();
        for (f = 1; f <= tFrames; ++f) {
            for (int c2 = 1; c2 <= tChannels; ++c2) {
                for (int s = 1; s <= tSlices; ++s) {
                    int index = image.getStackIndex(c2, s, f);
                    String label = "";
                    if (tFrames > 10) {
                        if (doFrameN) {
                            if (!label.equals("")) {
                                label = label + seperator;
                            }
                            tempnum = FramelabelStart + ((double)f - 1.0) * FramelabelInc;
                            label = label + FrameNames[0] + tempnum.toString() + FramelabelEnd;
                        }
                    } else if (tFrames > 1 && !FrameNames[f - 1].equals("")) {
                        if (!label.equals("")) {
                            label = label + seperator;
                        }
                        label = label + FrameNames[f - 1];
                    }
                    if (tChannels > 1 && !ChannelNames[c2 - 1].equals("")) {
                        if (!label.equals("")) {
                            label = label + seperator;
                        }
                        label = label + ChannelNames[c2 - 1];
                    }
                    if (doSliceN) {
                        if (!label.equals("")) {
                            label = label + seperator;
                        }
                        tempnum = SlicelabelStart + ((double)s - 1.0) * SlicelabelInc;
                        label = label + tempnum.toString() + "";
                        label = label + SlicelabelEnd;
                    }
                    IJ.log((String)label);
                    image.getStack().setSliceLabel(label + " ", index);
                }
            }
        }
        IJ.showStatus((String)"Labeled Hyperstack.");
    }
}

