/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import lj.LJPrefs;

public class LungJ_Settings
implements PlugIn,
ActionListener {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private static String clsDir = LJPrefs.LJ_clsDirectory;
    private final Border ColPrevBorder = new MatteBorder(1, 1, 1, 1, new Color(0, 0, 0));
    private static int Ncolours = 5;
    private static int rowInp = 0;
    private static int rowCol = 5;
    GridBagConstraints cCol = new GridBagConstraints();
    GenericDialog gd;
    JButton filebtn;
    JButton clsbtn;
    JComboBox cmbClassifier1 = new JComboBox();
    JTextField inpdirtxt;

    public void run(String arg) {
        this.showDialog();
    }

    public int showDialog() {
        GenericDialog gd = new GenericDialog("LungJ Settings...");
        GridBagConstraints c = new GridBagConstraints();
        Font gdFont = gd.getFont();
        this.cCol.fill = 10;
        this.cCol.insets = new Insets(0, 5, 5, 0);
        this.cCol.gridy = rowCol;
        JLabel inpdirlbl = new JLabel("Input directory ", 4);
        inpdirlbl.setFont(gdFont);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = rowInp;
        gd.add((Component)inpdirlbl, (Object)c);
        this.inpdirtxt = new JTextField(LJPrefs.LJ_inpDirectory, 70);
        this.inpdirtxt.setFont(gdFont);
        c.fill = 2;
        c.gridwidth = Ncolours + 2;
        c.gridx = 1;
        c.gridy = rowInp;
        gd.add((Component)this.inpdirtxt, (Object)c);
        this.filebtn = new JButton("...");
        this.filebtn.addActionListener(this);
        c.fill = 2;
        c.gridwidth = 1;
        c.gridx = Ncolours + 3;
        c.gridy = rowInp;
        gd.add((Component)this.filebtn, (Object)c);
        gd.addMessage("");
        gd.addCheckbox("Use WEKA", LJPrefs.LJ_makeMap);
        LJPrefs.loadClassifier();
        String[] classifiers = new String[LJPrefs.LJ_classifiers.size()];
        classifiers = LJPrefs.LJ_classifiers.toArray(classifiers);
        File model = new File(LJPrefs.LJ_clsDirectory);
        this.cmbClassifier1.setModel(new DefaultComboBoxModel<String>(classifiers));
        this.cmbClassifier1.setSelectedItem(model.getName());
        c.fill = 2;
        c.gridwidth = Ncolours + 2;
        c.gridx = 1;
        c.gridy = 2;
        gd.add((Component)this.cmbClassifier1, (Object)c);
        this.clsbtn = new JButton("...");
        this.clsbtn.addActionListener(this);
        c.fill = 2;
        c.gridwidth = 1;
        c.gridx = Ncolours + 3;
        c.gridy = 2;
        gd.add((Component)this.clsbtn, (Object)c);
        gd.addMessage("");
        gd.addCheckbox("Create Mask", LJPrefs.LJ_makeMask);
        gd.addNumericField("Threshold", LJPrefs.LJ_threshold * 100.0, 1);
        gd.addMessage("Colours for Colour by Segment");
        final JPanel pnlcol0 = new JPanel();
        pnlcol0.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                LJPrefs.LJ_Colors[0] = LJPrefs.getColor("Choose Color", LJPrefs.LJ_Colors[0]);
                pnlcol0.setBackground(LJPrefs.LJ_Colors[0]);
            }
        });
        pnlcol0.setBorder(this.ColPrevBorder);
        pnlcol0.setBackground(LJPrefs.LJ_Colors[0]);
        this.cCol.gridx = 2;
        gd.add((Component)pnlcol0, (Object)this.cCol);
        final JPanel pnlcol1 = new JPanel();
        pnlcol1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                LJPrefs.LJ_Colors[1] = LJPrefs.getColor("Choose Color", LJPrefs.LJ_Colors[1]);
                pnlcol1.setBackground(LJPrefs.LJ_Colors[1]);
            }
        });
        pnlcol1.setBorder(this.ColPrevBorder);
        pnlcol1.setBackground(LJPrefs.LJ_Colors[1]);
        this.cCol.gridx = 3;
        gd.add((Component)pnlcol1, (Object)this.cCol);
        final JPanel pnlcol2 = new JPanel();
        pnlcol2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                LJPrefs.LJ_Colors[2] = LJPrefs.getColor("Choose Color", LJPrefs.LJ_Colors[2]);
                pnlcol2.setBackground(LJPrefs.LJ_Colors[2]);
            }
        });
        pnlcol2.setBorder(this.ColPrevBorder);
        pnlcol2.setBackground(LJPrefs.LJ_Colors[2]);
        this.cCol.gridx = 4;
        gd.add((Component)pnlcol2, (Object)this.cCol);
        final JPanel pnlcol3 = new JPanel();
        pnlcol3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                LJPrefs.LJ_Colors[3] = LJPrefs.getColor("Choose Color", LJPrefs.LJ_Colors[3]);
                pnlcol3.setBackground(LJPrefs.LJ_Colors[3]);
            }
        });
        pnlcol3.setBorder(this.ColPrevBorder);
        pnlcol3.setBackground(LJPrefs.LJ_Colors[3]);
        this.cCol.gridx = 5;
        gd.add((Component)pnlcol3, (Object)this.cCol);
        final JPanel pnlcol4 = new JPanel();
        pnlcol4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                LJPrefs.LJ_Colors[4] = LJPrefs.getColor("Choose Color", LJPrefs.LJ_Colors[4]);
                pnlcol4.setBackground(LJPrefs.LJ_Colors[4]);
            }
        });
        pnlcol4.setBorder(this.ColPrevBorder);
        pnlcol4.setBackground(LJPrefs.LJ_Colors[4]);
        this.cCol.gridx = 6;
        gd.add((Component)pnlcol4, (Object)this.cCol);
        gd.addMessage("");
        gd.doLayout();
        gd.addHelp("https://bitbucket.org/lwollatz/lungj/wiki/Home");
        gd.hideCancelButton();
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        LJPrefs.LJ_inpDirectory = this.inpdirtxt.getText();
        LJPrefs.LJ_makeMap = gd.getNextBoolean();
        File file = new File(LJPrefs.LJ_clsDirectory);
        File folder = file.getParentFile();
        LJPrefs.LJ_clsDirectory = folder.getPath() + "\\" + this.cmbClassifier1.getItemAt(this.cmbClassifier1.getSelectedIndex());
        LJPrefs.LJ_makeMask = gd.getNextBoolean();
        LJPrefs.LJ_threshold = gd.getNextNumber() / 100.0;
        LJPrefs.savePreferences();
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        JFileChooser chooser;
        if (arg0.getSource() == this.clsbtn) {
            chooser = new JFileChooser(LJPrefs.LJ_clsDirectory);
            FileNameExtensionFilter modelfilter = new FileNameExtensionFilter("WEKA model (*.model)", "model");
            chooser.addChoosableFileFilter(modelfilter);
            chooser.setFileSelectionMode(0);
            chooser.setSelectedFile(new File(LJPrefs.LJ_clsDirectory));
            int returnVal = chooser.showDialog((Component)this.gd, "Choose WEKA Classifier");
            if (returnVal == 0) {
                clsDir = chooser.getSelectedFile().getPath();
                IJ.log((String)clsDir);
                LJPrefs.LJ_clsDirectory = clsDir;
                LJPrefs.loadClassifier();
                String[] classifiers = new String[LJPrefs.LJ_classifiers.size()];
                classifiers = LJPrefs.LJ_classifiers.toArray(classifiers);
                File model = new File(LJPrefs.LJ_clsDirectory);
                this.cmbClassifier1.setModel(new DefaultComboBoxModel<String>(classifiers));
                this.cmbClassifier1.setSelectedItem(model.getName());
            }
        }
        if (arg0.getSource() == this.filebtn) {
            chooser = new JFileChooser(LJPrefs.LJ_inpDirectory);
            chooser.setFileSelectionMode(1);
            chooser.setSelectedFile(new File(LJPrefs.LJ_inpDirectory));
            int returnVal = chooser.showDialog((Component)this.gd, "Choose Folder");
            if (returnVal == 0) {
                this.inpdirtxt.setText(chooser.getSelectedFile().getPath());
            }
        }
    }
}

