/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Matrix_Operation
implements PlugInFilter {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    ImagePlus origImg = null;
    int radius = 2;
    int numBins = 256;
    double[][] matrix;
    private int flags = 32805;

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        this.origImg = imp;
        if (imp == null) {
            return 4096;
        }
        GenericDialog gd = new GenericDialog("Matrix Operation");
        gd.addTextAreas("[[-1.0,0.0,1.0],[-2.0,0.0,2.0],[-1.0,0.0,1.0]]", null, 10, 40);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        String tempstr = gd.getNextText();
        IJ.log((String)tempstr);
        String[] items = tempstr.replaceAll("\\[", "").replaceAll("\\]", "").split(",");
        int size = (int)Math.sqrt(items.length);
        this.matrix = new double[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                try {
                    this.matrix[j][i] = Float.parseFloat(items[i * size + j]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        IJ.log((String)(String.valueOf(this.matrix[0][0]) + " " + String.valueOf(this.matrix[1][0]) + " " + String.valueOf(this.matrix[2][0])));
        IJ.log((String)(String.valueOf(this.matrix[0][1]) + " " + String.valueOf(this.matrix[1][1]) + " " + String.valueOf(this.matrix[2][1])));
        IJ.log((String)(String.valueOf(this.matrix[0][2]) + " " + String.valueOf(this.matrix[1][2]) + " " + String.valueOf(this.matrix[2][2])));
        return this.flags;
    }

    public void run(ImageProcessor ip) {
        int matsize = this.matrix.length;
        int halfsize = (matsize - 1) / 2;
        double tempsum = 0.0;
        ip.resetMinAndMax();
        int width = ip.getWidth();
        FloatProcessor bp = new FloatProcessor(ip.getWidth(), ip.getHeight(), (float[])ip.convertToFloat().getPixels());
        float[] bPixels = (float[])bp.getPixels();
        for (int i = halfsize; i < bp.getWidth() - halfsize; ++i) {
            for (int j = halfsize; j < bp.getHeight() - halfsize; ++j) {
                tempsum = 0.0;
                int x = i - halfsize;
                int xm = 0;
                while (x <= i + halfsize) {
                    int y = j - halfsize;
                    int ym = 0;
                    while (y <= j + halfsize) {
                        tempsum += (double)bPixels[x + y * width] * this.matrix[ym][xm];
                        ++y;
                        ++ym;
                    }
                    ++x;
                    ++xm;
                }
                ip.putPixelValue(i, j, tempsum);
            }
            IJ.showProgress((int)(i - halfsize), (int)(bp.getWidth() - halfsize));
        }
    }

    void showAbout() {
        IJ.showMessage((String)"Matrix Operations...", (String)"Convolves a matrix with an image\nmatrix has to be 2D\n");
    }
}

