/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class Pathfinder_2D
implements PlugIn {
    public void run(String command) {
        if (IJ.versionLessThan((String)"1.48n")) {
            return;
        }
        IJ.showStatus((String)"Applying Mask...");
        GenericDialog gd = new GenericDialog(command + " Define Start and End");
        gd.addNumericField("x0", 80.0, 0);
        gd.addNumericField("y0", 80.0, 0);
        gd.addNumericField("x2", 200.0, 0);
        gd.addNumericField("y2", 200.0, 0);
        gd.addNumericField("Fm", 1.0, 2);
        gd.addNumericField("Fb", 1.0, 2);
        gd.addNumericField("rb", 10.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double x0 = (int)gd.getNextNumber();
        double y0 = (int)gd.getNextNumber();
        double x2 = (int)gd.getNextNumber();
        double y2 = (int)gd.getNextNumber();
        double Fm = gd.getNextNumber();
        double Fb = gd.getNextNumber();
        int r = (int)gd.getNextNumber();
        ImagePlus image = WindowManager.getCurrentImage();
        int tWidth = image.getWidth();
        int tHeight = image.getHeight();
        ImageProcessor imageIP = image.getStack().getProcessor(1).convertToByte(true);
        byte[] Pixels = (byte[])imageIP.getPixels();
        double dist0 = Math.sqrt((x2 - x0) * (x2 - x0) + (y2 - y0) * (y2 - y0));
        double x1 = x0;
        double y1 = y0;
        double dist = dist0;
        double vx = 0.0;
        double vy = 0.0;
        double Fx = 0.0;
        double Fy = 0.0;
        int p = 0;
        for (int t = 1; t <= 1000; ++t) {
            vx = 0.0;
            vy = 0.0;
            Fx = 0.0;
            Fy = 0.0;
            dist = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            vx += (x2 - x1) * Fm / dist;
            vy += (y2 - y1) * Fm / dist;
            int nx = (int)x1 - r;
            while ((double)nx <= x1 + (double)r) {
                int ny = (int)y1 - r;
                while ((double)ny <= y1 + (double)r) {
                    p = nx + ny * tWidth;
                    if (Pixels[p] == -1) {
                        dist = Math.sqrt(((double)nx - x1) * ((double)nx - x1) + ((double)ny - y1) * ((double)ny - y1));
                        Fx -= Fb * (1.0 / dist) * ((double)nx - x1) / dist;
                        Fy -= Fb * (1.0 / dist) * ((double)ny - y1) / dist;
                    }
                    ++ny;
                }
                ++nx;
            }
            if ((int)(x1 += (vx += Fx)) < 0 || (int)x1 >= tWidth || (int)(y1 += (vy += Fy)) < 0 || (int)y1 >= tHeight) continue;
            p = (int)x1 + (int)y1 * tWidth;
            Pixels[p] = -36;
        }
        image.show();
        IJ.showStatus((String)"Path Completed.");
    }
}

