/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class Pathfinder_3D
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";

    public void run(String command) {
        if (IJ.versionLessThan((String)"1.48n")) {
            return;
        }
        IJ.showStatus((String)"Finding Path");
        GenericDialog gd = new GenericDialog(command + " Define Start and End");
        gd.addNumericField("x0", 145.0, 0);
        gd.addNumericField("y0", 97.0, 0);
        gd.addNumericField("z0", 5.0, 0);
        gd.addNumericField("x2", 142.0, 0);
        gd.addNumericField("y2", 224.0, 0);
        gd.addNumericField("z2", 244.0, 0);
        gd.addNumericField("Fm", 5.0, 2);
        gd.addNumericField("Fb", 0.1, 2);
        gd.addNumericField("rb", 5.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double x0 = (int)gd.getNextNumber();
        double y0 = (int)gd.getNextNumber();
        double z0 = (int)gd.getNextNumber();
        double x2 = (int)gd.getNextNumber();
        double y2 = (int)gd.getNextNumber();
        double z2 = (int)gd.getNextNumber();
        double Fm = gd.getNextNumber();
        double Fb = gd.getNextNumber();
        int r = (int)gd.getNextNumber();
        ImagePlus image = WindowManager.getCurrentImage();
        int tWidth = image.getWidth();
        int tHeight = image.getHeight();
        int tDepth = image.getNSlices();
        double dist0 = Math.sqrt((x2 - x0) * (x2 - x0) + (y2 - y0) * (y2 - y0) + (z2 - z0) * (z2 - z0));
        double x1 = x0;
        double y1 = y0;
        double z1 = z0;
        double dist = dist0;
        double vx = 0.0;
        double vy = 0.0;
        double vz = 0.0;
        double Fx = 0.0;
        double Fy = 0.0;
        double Fz = 0.0;
        int p = 0;
        int xp = (int)x1;
        int yp = (int)y1;
        int zp = (int)z1;
        int t = 1;
        while (t < 100000) {
            vx = 0.0;
            vy = 0.0;
            vz = 0.0;
            Fx = 0.0;
            Fy = 0.0;
            Fz = 0.0;
            xp = (int)x1;
            yp = (int)y1;
            zp = (int)z1;
            if ((double)xp == x2 && (double)yp == y2 && (double)zp == z2) {
                IJ.showStatus((String)"Path Completed.");
                break;
            }
            dist = Math.sqrt((x2 - x0) * (x2 - x0) + (y2 - y0) * (y2 - y0) + (z2 - z0) * (z2 - z0));
            vx += (x2 - x1) * Fm / dist;
            vy += (y2 - y1) * Fm / dist;
            vz += (z2 - z1) * Fm / dist;
            int nz = Math.max((int)z1 - r, 1);
            while ((double)nz <= Math.min(z1 + (double)r, (double)tDepth)) {
                ImageProcessor imageIP = image.getStack().getProcessor(nz).convertToByte(true);
                byte[] Pixels = (byte[])imageIP.getPixels();
                int nx = Math.max((int)x1 - r, 0);
                while ((double)nx <= Math.min(x1 + (double)r, (double)(tWidth - 1))) {
                    int ny = Math.max((int)y1 - r, 0);
                    while ((double)ny <= Math.min(y1 + (double)r, (double)(tHeight - 1))) {
                        p = nx + ny * tWidth;
                        if (Pixels[p] == -1) {
                            dist = Math.sqrt(((double)nx - x1) * ((double)nx - x1) + ((double)ny - y1) * ((double)ny - y1) + ((double)nz - z1) * ((double)nz - z1));
                            Fx -= Fb * (1.0 / dist) * ((double)nx - x1) / dist;
                            Fy -= Fb * (1.0 / dist) * ((double)ny - y1) / dist;
                            Fz -= Fb * (1.0 / dist) * ((double)nz - z1) / dist;
                        }
                        ++ny;
                    }
                    ++nx;
                }
                ++nz;
            }
            vx += Fx;
            vy += Fy;
            vz += Fz;
            double vmax = Math.max(Math.max(Math.abs(vx), Math.abs(vy)), Math.abs(vz));
            if (vmax < 0.1) {
                IJ.showStatus((String)"Dead End.");
                IJ.log((String)("t=" + String.valueOf(vmax) + "v=" + String.valueOf(vmax)));
                break;
            }
            if ((int)(x1 += (vx /= vmax)) >= 0 && (int)x1 < tWidth && (int)(y1 += (vy /= vmax)) >= 0 && (int)y1 < tHeight && (int)(z1 += (vz /= vmax)) > 0 && (int)z1 <= tDepth) {
                p = (int)x1 + (int)y1 * tWidth;
                ImageProcessor imageIP = image.getStack().getProcessor((int)z1).convertToByte(true);
                byte[] Pixels = (byte[])imageIP.getPixels();
                Pixels[p] = -66;
                continue;
            }
            IJ.log((String)("[" + String.valueOf(x1) + ";" + String.valueOf(y1) + ";" + String.valueOf(z1) + "]"));
        }
        IJ.showStatus((String)"Out of Time.");
        image.show();
    }
}

